package cc.concurrent.config.server.dao.impl;

import cc.concurrent.config.server.dao.UserDao;
import cc.concurrent.config.server.model.FileHistory;
import cc.concurrent.config.server.model.User;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcDaoSupport;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

/**
 * User: yanghe.liang
 * Date: 13-10-20
 * Time: 下午9:28
 */
public class UserDaoImpl extends NamedParameterJdbcDaoSupport implements UserDao {

    @Override
    public User getUser(String username) {
        String sql = "select username, password from config_user where username=?";
        List<User> r = getJdbcTemplate().query(sql, new Object[]{username}, new RowMapper<User>() {
            @Override
            public User mapRow(ResultSet rs, int rowNum) throws SQLException {
                return new User(rs.getString(1), rs.getString(2));
            }
        });
        return !r.isEmpty() ? r.get(0) : null;
    }

}
