package cc.concurrent.config.server.dao.impl;

import cc.concurrent.config.core.model.FilePublished;
import cc.concurrent.config.server.dao.FilePublishedDao;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.BeanPropertySqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcDaoSupport;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

/**
 * User: yanghe.liang
 * Date: 13-10-31
 * Time: 下午9:09
 */
public class FilePublishedDaoImpl extends NamedParameterJdbcDaoSupport implements FilePublishedDao {

    @Override
    public int addFilePublished(FilePublished filePublished) {
        String sql = "insert into config_file_published(app_name, file_name, version, xml, md5) " +
                "values(:appName, :fileName, :version, :xml, :md5)";
        SqlParameterSource bpsp = new BeanPropertySqlParameterSource(filePublished);
        return getNamedParameterJdbcTemplate().update(sql, bpsp);
    }

    @Override
    public int updateFilePublished(FilePublished filePublished) {
        String sql = "update config_file_published set version=:version, xml=:xml, md5=:md5 " +
                "where app_name=:appName and file_name=:fileName";
        SqlParameterSource bpsp = new BeanPropertySqlParameterSource(filePublished);
        return getNamedParameterJdbcTemplate().update(sql, bpsp);
    }

    @Override
    public List<FilePublished> getFilePublisheds(String appName) {
        String sql = "select app_name, file_name, version, xml, md5 from config_file_published " +
                "where app_name=?";
        List<FilePublished> r = getJdbcTemplate().query(sql, new Object[]{appName}, new RowMapper<FilePublished>() {
            @Override
            public FilePublished mapRow(ResultSet rs, int rowNum) throws SQLException {
                return new FilePublished(rs.getString(1), rs.getString(2), rs.getInt(3), rs.getString(4), rs.getString(5));
            }
        });
        return r;
    }

    @Override
    public FilePublished getFilePublished(String appName, String fileName) {
        String sql = "select app_name, file_name, version, xml, md5 from config_file_published " +
                "where app_name=? and file_name=?";
        List<FilePublished> r = getJdbcTemplate().query(sql, new Object[]{appName, fileName}, new RowMapper<FilePublished>() {
            @Override
            public FilePublished mapRow(ResultSet rs, int rowNum) throws SQLException {
                return new FilePublished(rs.getString(1), rs.getString(2), rs.getInt(3), rs.getString(4), rs.getString(5));
            }
        });
        return !r.isEmpty() ? r.get(0) : null;
    }

}
