package cc.concurrent.config.server.dao.impl;

import cc.concurrent.config.server.dao.FileHistoryDao;
import cc.concurrent.config.server.model.FileHistory;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.BeanPropertySqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcDaoSupport;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;

/**
 * User: yanghe.liang
 * Date: 13-10-13
 * Time: 下午5:32
 */
public class FileHistoryDaoImpl extends NamedParameterJdbcDaoSupport implements FileHistoryDao{

    @Override
    public int addFileHistory(FileHistory fileHistory) {
        String sql = "insert into config_file_history(app_name, file_name, version, xml, comment, creator, create_time, is_published, publisher, publish_time) " +
                "values(:appName, :fileName, :version, :xml, :comment, :creator, :createTime, :published, :publisher, :publishTime)";
        SqlParameterSource bpsp = new BeanPropertySqlParameterSource(fileHistory);
        return getNamedParameterJdbcTemplate().update(sql, bpsp);
    }

    @Override
    public List<FileHistory> getFileHistories(String appName, String fileName) {
        String sql = "select app_name, file_name, version, xml, comment, creator, create_time, is_published, publisher, publish_time " +
                "from config_file_history where app_name=? and file_name=? order by version desc";
        return getJdbcTemplate().query(sql, new Object[]{appName, fileName}, new RowMapper<FileHistory>() {
            @Override
            public FileHistory mapRow(ResultSet rs, int rowNum) throws SQLException {
                return new FileHistory(rs.getString(1), rs.getString(2), rs.getInt(3), rs.getString(4),
                        rs.getString(5), rs.getString(6), rs.getDate(7), rs.getBoolean(8), rs.getString(9), rs.getDate(10));
            }
        });
    }

    @Override
    public FileHistory getFileHistory(String appName, String fileName, int version) {
        String sql = "select app_name, file_name, version, xml, comment, creator, create_time, is_published, publisher, publish_time " +
                "from config_file_history where app_name=? and file_name=? and version=?";
        List<FileHistory> r = getJdbcTemplate().query(sql, new Object[]{appName, fileName, version}, new RowMapper<FileHistory>() {
            @Override
            public FileHistory mapRow(ResultSet rs, int rowNum) throws SQLException {
                return new FileHistory(rs.getString(1), rs.getString(2), rs.getInt(3), rs.getString(4),
                        rs.getString(5), rs.getString(6), rs.getDate(7), rs.getBoolean(8), rs.getString(9), rs.getDate(10));
            }
        });
        return !r.isEmpty() ? r.get(0) : null;
    }

    @Override
    public int updatePublish(String appName, String fileName, int version, boolean isPublished, String publisher, Date publishTime) {
        String sql = "update config_file_history set is_published=?, publisher=?, publish_time=? " +
                "where app_name=? and file_name=? and version=?";
        return getJdbcTemplate().update(sql, new Object[]{isPublished, publisher, publishTime, appName, fileName, version});
    }


}
