package cc.concurrent.config.server.dao.impl;

import cc.concurrent.config.server.dao.FileCurrentDao;
import cc.concurrent.config.server.model.FileCurrent;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.BeanPropertySqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcDaoSupport;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

/**
 * User: yanghe.liang
 * Date: 13-10-13
 * Time: 下午4:35
 */
public class FileCurrentDaoImpl extends NamedParameterJdbcDaoSupport implements FileCurrentDao {

    @Override
    public int addFileCurrent(FileCurrent fileCurrent) {
        String sql = "insert into config_file_current(app_name, file_name, version, xml, comment, creator, create_time, last_publish_version, last_publisher, last_publish_time) " +
                "values(:appName, :fileName, :version, :xml, :comment, :creator, :createTime, :lastPublishVersion, :lastPublisher, :lastPublishTime)";
        SqlParameterSource bpsp = new BeanPropertySqlParameterSource(fileCurrent);
        return getNamedParameterJdbcTemplate().update(sql, bpsp);
    }

    @Override
    public List<FileCurrent> getFileCurrents(String appName) {
        String sql = "select app_name, file_name, version, xml, comment, creator, create_time, last_publish_version, last_publisher, last_publish_time " +
                "from config_file_current where app_name=?";
        return getJdbcTemplate().query(sql, new Object[]{appName}, new RowMapper<FileCurrent>() {
            @Override
            public FileCurrent mapRow(ResultSet rs, int rowNum) throws SQLException {
                return new FileCurrent(rs.getString(1), rs.getString(2), rs.getInt(3), rs.getString(4),
                        rs.getString(5), rs.getString(6), rs.getDate(7), rs.getInt(8), rs.getString(9), rs.getDate(10));
            }
        });
    }

    @Override
    public FileCurrent getFileCurrent(String appName, String fileName) {
        String sql = "select app_name, file_name, version, xml, comment, creator, create_time, last_publish_version, last_publisher, last_publish_time " +
                "from config_file_current where app_name=? and file_name=?";
        List<FileCurrent> r = getJdbcTemplate().query(sql, new Object[]{appName, fileName}, new RowMapper<FileCurrent>() {
            @Override
            public FileCurrent mapRow(ResultSet rs, int rowNum) throws SQLException {
                return new FileCurrent(rs.getString(1), rs.getString(2), rs.getInt(3), rs.getString(4),
                        rs.getString(5), rs.getString(6), rs.getDate(7), rs.getInt(8), rs.getString(9), rs.getDate(10));
            }
        });
        return !r.isEmpty() ? r.get(0) : null;
    }

    @Override
    public int updateFileCurrent(FileCurrent fileCurrent) {
        String sql = "update config_file_current " +
                "set version=:version, xml=:xml, comment=:comment, creator=:creator, create_time=:createTime, " +
                "last_publish_version=:lastPublishVersion, last_publisher=:lastPublisher, last_publish_time=:lastPublishTime" +
                " where app_name=:appName and file_name=:fileName";
        SqlParameterSource bpsp = new BeanPropertySqlParameterSource(fileCurrent);
        return getNamedParameterJdbcTemplate().update(sql, bpsp);
    }

}
