package cc.concurrent.config.server.dao.impl;

import cc.concurrent.config.server.dao.AppDao;
import cc.concurrent.config.server.model.App;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.BeanPropertySqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcDaoSupport;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

/**
 * User: yanghe.liang
 * Date: 13-10-11
 * Time: 下午9:58
 */
public class AppDaoImpl extends NamedParameterJdbcDaoSupport implements AppDao {

    @Override
    public int addApp(App app) {
        String sql = "insert into config_app(app_name, description, creator, create_time) " +
                "values(:appName, :description, :creator, :createTime)";
        SqlParameterSource bpsp = new BeanPropertySqlParameterSource(app);
        return getNamedParameterJdbcTemplate().update(sql, bpsp);
    }

    @Override
    public List<App> getApps() {
        String sql = "select app_name, description, creator, create_time from config_app";
        return getNamedParameterJdbcTemplate().query(sql, new RowMapper<App>() {
            @Override
            public App mapRow(ResultSet rs, int rowNum) throws SQLException {
                return new App(rs.getString(1), rs.getString(2), rs.getString(3), rs.getDate(4));
            }
        });
    }

    @Override
    public App getApp(String appName) {
        String sql = "select app_name, description, creator, create_time from config_app where app_name=?";
        List<App> r = getJdbcTemplate().query(sql, new Object[]{appName}, new RowMapper<App>() {
            @Override
            public App mapRow(ResultSet rs, int rowNum) throws SQLException {
                return new App(rs.getString(1), rs.getString(2), rs.getString(3), rs.getDate(4));
            }
        });
        return !r.isEmpty() ? r.get(0) : null;
    }

}



