package cc.concurrent.config.server.controller;

import cc.concurrent.config.server.model.User;
import cc.concurrent.config.server.service.UserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.DigestUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;

import static com.google.common.base.Preconditions.*;

/**
 * User: yanghe.liang
 * Date: 13-10-20
 * Time: 下午4:54
 */
@Controller
public class LoginController {

    @Autowired
    UserService userService;

    @RequestMapping(value = "/login", method = RequestMethod.GET)
    public String login() {
        return "login";
    }

    @RequestMapping(value = "/login", method = RequestMethod.POST)
    public String login(User user, HttpServletResponse response, Model model) {
        checkNotNull(user);
        String username = user.getUsername();
        String passward = user.getPassword();
        checkNotNull(username);
        checkNotNull(passward);
        username = username.trim();
        passward = passward.trim();
        checkArgument(!username.isEmpty(), "username can't be blank");
        checkArgument(!passward.isEmpty(), "password can't be blank");

        boolean isLogin = userService.login(username, passward);
        if (!isLogin) {
            model.addAttribute("errorMsg", "用户名或密码错误");
            return "login";
        }

        Cookie nameCookie = new Cookie("username", username);
        Cookie markCookie = new Cookie("mark", DigestUtils.md5DigestAsHex(username.getBytes()));
        nameCookie.setMaxAge(60 * 60);
        markCookie.setMaxAge(60 * 60);
        response.addCookie(nameCookie);
        response.addCookie(markCookie);
        return "redirect:/";
    }

    @RequestMapping(value = "/logout", method = RequestMethod.GET)
    public String logout(HttpServletResponse response) {
        Cookie nameCookie = new Cookie("username", null);
        Cookie markCookie = new Cookie("mark", null);
        nameCookie.setMaxAge(0);
        markCookie.setMaxAge(0);
        response.addCookie(nameCookie);
        response.addCookie(markCookie);
        return "redirect:/login";
    }

}
