package cc.concurrent.config.server.controller;

import cc.concurrent.config.server.model.App;
import cc.concurrent.config.server.service.AppService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.validation.Valid;
import java.util.List;

/**
 * User: yanghe.liang
 * Date: 13-10-8
 * Time: 下午11:04
 */
@Controller
public class AppController {

    @Autowired
    AppService appService;

    /**
     * 列出所有的app
     */
    @RequestMapping(value = "/", method = RequestMethod.GET)
    public String apps(Model model) {
        List<App> apps = appService.getApps();
        model.addAttribute("apps", apps);
        return "apps";
    }

    /**
     * app添加页面
     */
    @RequestMapping(value = "/addApp", method = RequestMethod.GET)
    public String addApp(Model model) {
        model.addAttribute("app", new App());
        return "addApp";
    }

    /**
     * 执行app添加
     */
    @RequestMapping(value = "/addApp", method = RequestMethod.POST)
    public String addApp(@Valid App app, BindingResult bindingResult, Model model) {
        if (bindingResult.hasErrors()) {
            model.addAttribute("errors", bindingResult);
            return "addApp";
        }
        appService.addApp(app);
        return "redirect:/";
    }

}
