package cc.concurrent.config.client.loader;

import com.google.common.base.Charsets;
import com.google.common.io.Files;

import java.io.File;

import static com.google.common.base.Preconditions.checkState;

/**
 * User: yanghe.liang
 * Date: 13-11-2
 * Time: 下午9:55
 */
public class LocalLoader extends Loader {

    private final String localDir;

    public LocalLoader(String appName, String localDir) {
        super(appName);
        this.localDir = localDir;
    }

    @Override
    public void init() throws Exception {
        String appDir = getAppDir();
        File file = new File(appDir);
        if (!file.exists()) { // app目录不存在需要创建
            file.mkdirs();
        }
    }

    @Override
    String getXml(String fileName) throws Exception {
        String path = getAppDir() + "/" + fileName + ".xml";
        File file = new File(path);
        checkState(file.exists(), "file " + path + " don't exists");
        return Files.toString(file, Charsets.UTF_8);
    }

    private String getAppDir() {
        return localDir.endsWith("/") ?
                localDir + appName :
                localDir + "/" + appName;
    }

}
