package cc.concurrent.config.client.loader;

import cc.concurrent.config.client.BeanDesc;
import cc.concurrent.config.core.util.Md5Util;
import com.google.common.base.Charsets;
import com.google.common.hash.Hashing;
import org.simpleframework.xml.Serializer;
import org.simpleframework.xml.core.Persister;

import static com.google.common.base.Preconditions.checkState;

/**
 * User: yanghe.liang
 * Date: 13-11-2
 * Time: 下午8:38
 */
public abstract class Loader {

    protected final String appName;

    protected Loader(String appName) {
        this.appName = appName;
    }

    public <T> BeanDesc<T> load(String fileName, Class<? extends T> clazz) throws Exception {
        String xml = getXml(fileName);
        checkState(xml != null, "loader[%s] appName[%s] fileName[%s] get xml null", getClass().getSimpleName(), appName, fileName);
        Serializer serializer = new Persister();
        T bean = serializer.read(clazz, xml, false);
        checkState(bean != null, "xml[%s] to bean null", xml.replaceAll("\\s+", ""));
        cacheXml(fileName, xml);
        String md5 = Md5Util.md5(xml);
        return new BeanDesc<T>(fileName, md5, bean);
    }

    public abstract void init() throws Exception;
    abstract String getXml(String fileName) throws Exception;
    public void cacheXml(String fileName, String xml) {}

}
