/*
 * Decompiled with CFR 0.152.
 */
package cc.ccoke.validate.verify;

import cc.ccoke.validate.exception.ParamNullOrEmptyException;
import cc.ccoke.validate.verify.BaseParamVerify;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import org.aspectj.lang.reflect.MethodSignature;

public class IgnoreParamVerify
extends BaseParamVerify {
    @Override
    public void doVerify(Object[] args, MethodSignature methodSignature, String[] value) throws IllegalAccessException {
        Annotation[][] annotations = methodSignature.getMethod().getParameterAnnotations();
        for (int i = 0; i < args.length; ++i) {
            String parameterName = methodSignature.getParameterNames()[i];
            if (this.isItemInArray(parameterName, value)) continue;
            if (this.isEmpty(args[i])) {
                throw new ParamNullOrEmptyException(parameterName);
            }
            this.checkParamType(annotations, i, args[i], parameterName);
            if (this.isBasicType(args[i].getClass().getTypeName())) continue;
            Field[] fields = args[i].getClass().getDeclaredFields();
            for (int j = 0; j < fields.length; ++j) {
                fields[j].setAccessible(true);
                String fieldName = parameterName + "." + fields[j].getName();
                if (this.isItemInArray(fieldName, value)) continue;
                if (this.isEmpty(fields[j].get(args[i]))) {
                    throw new ParamNullOrEmptyException(fieldName);
                }
                this.checkParamType(fields[j], args[i], parameterName);
            }
        }
    }
}

