/*
 * Decompiled with CFR 0.152.
 */
package cc.ccoke.validate.verify;

import cc.ccoke.validate.annotation.ParamType;
import cc.ccoke.validate.entity.Regular;
import cc.ccoke.validate.exception.ParamAnnotationException;
import cc.ccoke.validate.exception.ParamRegularException;
import cc.ccoke.validate.factory.RegularFactory;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.regex.Pattern;
import org.aspectj.lang.reflect.MethodSignature;

public abstract class BaseParamVerify {
    private static final String[] TYPES = new String[]{"java.lang.Integer", "java.lang.Double", "java.lang.Float", "java.lang.Long", "java.lang.Short", "java.lang.Byte", "java.lang.Boolean", "java.lang.Character", "java.lang.String", "int", "double", "long", "short", "byte", "boolean", "char", "float"};

    protected boolean isItemInArray(Object item, Object[] array) {
        for (int i = 0; i < array.length; ++i) {
            if (!item.equals(array[i])) continue;
            return true;
        }
        return false;
    }

    protected boolean isBasicType(String type) {
        return this.isItemInArray(type, TYPES);
    }

    protected boolean isEmpty(Object obj) {
        return obj == null || obj instanceof String && "".equals(obj);
    }

    public abstract void doVerify(Object[] var1, MethodSignature var2, String[] var3) throws IllegalAccessException;

    private boolean isMatchPattern(Object obj, String regex) {
        if (obj == null) {
            return false;
        }
        if (!this.isBasicType(obj.getClass().getTypeName())) {
            throw new ParamAnnotationException("Target param must be Basic type");
        }
        return Pattern.matches(regex, String.valueOf(obj));
    }

    protected void checkParamType(Annotation[][] annotations, int index, Object arg, String paramName) throws ParamAnnotationException, ParamRegularException {
        for (int j = 0; j < annotations[index].length; ++j) {
            Annotation annotation = annotations[index][j];
            if (annotation.annotationType() != ParamType.class) continue;
            this.checkParamType((ParamType)annotation, paramName, arg);
            break;
        }
    }

    protected void checkParamType(Field field, Object arg, String paramName) throws IllegalAccessException, ParamAnnotationException, ParamRegularException {
        ParamType paramType = field.getAnnotation(ParamType.class);
        if (paramType == null) {
            return;
        }
        this.checkParamType(paramType, paramName, field.get(arg));
    }

    private void checkParamType(ParamType paramType, String paramName, Object var1) {
        String regex = paramType.regex();
        String describe = paramType.describe();
        if (!"".equals(regex) && !this.isMatchPattern(var1, regex)) {
            throw new ParamRegularException(paramName, "".equals(describe) ? paramType.regex() : describe);
        }
        String key = paramType.value();
        if ("".equals(key)) {
            return;
        }
        Regular regular = RegularFactory.DEFAULT_REGULARS.get(key);
        if (regular == null) {
            throw new ParamAnnotationException(key + " not define!");
        }
        if (!this.isMatchPattern(var1, regular.getRegex())) {
            throw new ParamRegularException(paramName, "".equals(describe) ? regular.getDescribe() : describe);
        }
    }
}

