/*
 * Decompiled with CFR 0.152.
 */
package cc.ccoke.validate.factory;

import cc.ccoke.validate.entity.Regular;
import cc.ccoke.validate.exception.ParamException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RegularFactory {
    public static Map<String, Regular> DEFAULT_REGULARS = new HashMap<String, Regular>();

    public static void setRegulars(List<Regular> regulars) {
        if (regulars == null || regulars.size() == 0) {
            return;
        }
        for (int i = 0; i < regulars.size(); ++i) {
            Regular regular = regulars.get(i);
            if (regular.getName() == null || "".equals(regular.getName().trim())) {
                throw new ParamException("\u4ece\u914d\u7f6e\u6587\u4ef6\u8bfb\u53d6\u89c4\u5219\u51fa\u9519\uff0c\u9519\u8bef\u5728\u7b2c" + (i + 1) + "\u884c");
            }
            if (regular.getRegex() == null || "".equals(regular.getRegex().trim())) {
                throw new ParamException("\u4ece\u914d\u7f6e\u6587\u4ef6\u8bfb\u53d6\u89c4\u5219\u51fa\u9519\uff0c\u89c4\u5219:" + regular.getName() + " \u7684\u6b63\u5219\u4e0d\u80fd\u4e3a\u7a7a");
            }
            DEFAULT_REGULARS.put(regular.getName(), regular);
        }
    }

    static {
        DEFAULT_REGULARS.put("EMAIL", new Regular("[\\w!#$%&'*+/=?^_`{|}~-]+(?:\\.[\\w!#$%&'*+/=?^_`{|}~-]+)*@(?:[\\w](?:[\\w-]*[\\w])?\\.)+[\\w](?:[\\w-]*[\\w])?", "\u90ae\u7bb1"));
        DEFAULT_REGULARS.put("URL", new Regular("[a-zA-z]+://[^\\s]*", "\u94fe\u63a5"));
        DEFAULT_REGULARS.put("QQ", new Regular("[1-9][0-9]{4,}", "QQ"));
        DEFAULT_REGULARS.put("POSTAL_CODE", new Regular("[1-9]\\d{5}(?!\\d)", "\u90ae\u7f16\u5e94\u4e3a6\u4f4d\u6570\u5b57"));
        DEFAULT_REGULARS.put("ID_NUMBER", new Regular("^(\\d{6})(\\d{4})(\\d{2})(\\d{2})(\\d{3})([0-9]|X)$", "\u8eab\u4efd\u8bc1\u53f7(18\u4f4d\uff0c\u524d17\u4f4d\u5fc5\u987b\u4e3a\u6570\u5b57\uff0c\u6700\u540e\u4e00\u4f4d\u53ef\u4ee5\u662f\u5927\u5199\u7684X)"));
    }
}

