/*
 * Decompiled with CFR 0.152.
 */
package cc.ccoke.validate.verify;

import cc.ccoke.validate.annotation.IgnoreVerify;
import cc.ccoke.validate.exception.ParamNullOrEmptyException;
import cc.ccoke.validate.verify.BaseParamVerify;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import org.aspectj.lang.reflect.MethodSignature;

public class IgnoreAnnotationParamVerify
extends BaseParamVerify {
    @Override
    public void doVerify(Object[] args, MethodSignature methodSignature, String[] value) throws IllegalAccessException {
        Annotation[][] annotations = methodSignature.getMethod().getParameterAnnotations();
        for (int i = 0; i < args.length; ++i) {
            String parameterName = methodSignature.getParameterNames()[i];
            for (int j = 0; j < annotations[i].length; ++j) {
                Annotation annotation = annotations[i][j];
                if (annotation.annotationType() != IgnoreVerify.class) continue;
            }
            if (this.isEmpity(args[i])) {
                throw new ParamNullOrEmptyException(parameterName);
            }
            this.checkParamType(annotations, i, args[i], parameterName);
            Field[] fields = args[i].getClass().getDeclaredFields();
            boolean isBasciType = this.isBasicType(args[i].getClass().getTypeName());
            for (int j = 0; j < fields.length && !isBasciType; ++j) {
                fields[j].setAccessible(true);
                String fieldName = parameterName + "." + fields[j].getName();
                if (fields[j].getAnnotation(IgnoreVerify.class) != null) continue;
                if (this.isEmpity(fields[j].get(args[i]))) {
                    throw new ParamNullOrEmptyException(fieldName);
                }
                this.checkParamType(fields[j], args[i], parameterName);
            }
        }
    }
}

