/*
 * Decompiled with CFR 0.152.
 */
package cc.ccoke.validate.verify;

import cc.ccoke.validate.annotation.ParamType;
import cc.ccoke.validate.exception.ParamAnnotationException;
import cc.ccoke.validate.exception.ParamRegularException;
import cc.ccoke.validate.factory.RegularFactory;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.regex.Pattern;
import org.aspectj.lang.reflect.MethodSignature;

public abstract class BaseParamVerify {
    private static final String[] TYPES = new String[]{"java.lang.Integer", "java.lang.Double", "java.lang.Float", "java.lang.Long", "java.lang.Short", "java.lang.Byte", "java.lang.Boolean", "java.lang.Character", "java.lang.String", "int", "double", "long", "short", "byte", "boolean", "char", "float"};

    protected boolean isItemInArray(String item, String[] array) {
        for (int i = 0; i < array.length; ++i) {
            if (!item.equals(array[i])) continue;
            return true;
        }
        return false;
    }

    protected boolean isBasicType(String type) {
        return this.isItemInArray(type, TYPES);
    }

    protected boolean isEmpity(Object obj) {
        return obj == null || obj instanceof String && "".equals(obj);
    }

    public abstract void doVerify(Object[] var1, MethodSignature var2, String[] var3) throws IllegalAccessException;

    private boolean isMatchPattern(Object obj, String regex) {
        if (obj != null) {
            if (!(obj instanceof String)) {
                throw new ParamAnnotationException("ParamType: Target param must be type: String");
            }
            return Pattern.matches(regex, (String)obj);
        }
        return true;
    }

    protected void checkParamType(Annotation[][] annotations, int i, Object arg, String parameterName) {
        for (int j = 0; j < annotations[i].length; ++j) {
            Annotation annotation = annotations[i][j];
            if (annotation.annotationType() != ParamType.class) continue;
            String key = ((ParamType)annotation).value();
            String val = RegularFactory.DEFAULT_REGULARS.get(key);
            if (val == null) {
                throw new ParamAnnotationException(key + ": Regular not define");
            }
            if (this.isMatchPattern(arg, val)) break;
            throw new ParamRegularException(parameterName, key);
        }
    }

    protected void checkParamType(Field field, Object arg, String parameterName) throws IllegalAccessException {
        ParamType paramType = field.getAnnotation(ParamType.class);
        if (paramType != null) {
            String key = paramType.value();
            String val = RegularFactory.DEFAULT_REGULARS.get(key);
            if (val == null) {
                throw new ParamAnnotationException(key + ": Regular not define");
            }
            if (!this.isMatchPattern(field.get(arg), val)) {
                throw new ParamRegularException(parameterName + "." + field.getName(), key);
            }
        }
    }
}

