/*
 * Decompiled with CFR 0.152.
 */
package cc.catalysts.maven.dmuncle;

import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.FileUtils;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mojo(name="dmuncle-send", defaultPhase=LifecyclePhase.PACKAGE, aggregator=true)
public class DmUncleSendMojo
extends AbstractMojo {
    private static final Logger LOG = LoggerFactory.getLogger(DmUncleSendMojo.class);
    public static final String JSON_PACKAGE_FILENAME = "dmuncle-package.json";
    @Parameter(required=true)
    private String serverAddress;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;

    public void execute() throws MojoExecutionException, MojoFailureException {
        String url = this.serverAddress + "/import";
        LOG.info("Sending POST request to server " + url);
        Path jsonFilePath = Paths.get(JSON_PACKAGE_FILENAME, new String[0]);
        this.addProjectNameToJSONPackage();
        try {
            URL obj = new URL(url);
            HttpURLConnection con = (HttpURLConnection)obj.openConnection();
            con.setRequestMethod("POST");
            con.setRequestProperty("Content-Type", "application/json");
            con.setDoOutput(true);
            OutputStream os = con.getOutputStream();
            os.write(Files.readAllBytes(jsonFilePath));
            os.flush();
            if (con.getResponseCode() != 200) {
                throw new RuntimeException("Failed : HTTP error code : " + con.getResponseCode());
            }
            LOG.info("Successfully sent data.");
            con.disconnect();
            Files.delete(jsonFilePath);
        }
        catch (MalformedURLException e) {
            LOG.error("Error encountered with server URL: " + e.getMessage(), (Throwable)e);
        }
        catch (ProtocolException e) {
            LOG.error("Error encountered on sending data: " + e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            LOG.error("Error encountered on finding json file: " + e.getMessage(), (Throwable)e);
        }
    }

    private void addProjectNameToJSONPackage() {
        try {
            JSONParser parser = new JSONParser();
            FileReader fileReader = new FileReader(JSON_PACKAGE_FILENAME);
            JSONObject jsonPackage = (JSONObject)parser.parse((Reader)fileReader);
            jsonPackage.put((Object)"projectName", (Object)this.project.getName());
            FileUtils.fileWrite((String)JSON_PACKAGE_FILENAME, (String)jsonPackage.toString());
            fileReader.close();
        }
        catch (IOException e) {
            LOG.error("Error encountered on finding json file: " + e.getMessage(), (Throwable)e);
        }
        catch (ParseException e) {
            LOG.error("Error encountered on parsing json file: " + e.getMessage(), (Throwable)e);
        }
    }
}

