/*
 * Decompiled with CFR 0.152.
 */
package cc.catalysts.maven.dmuncle;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.FileUtils;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mojo(name="dmuncle-watch", defaultPhase=LifecyclePhase.PACKAGE)
public class DmUncleMavenMojo
extends AbstractMojo {
    private static final Logger LOG = LoggerFactory.getLogger(DmUncleMavenMojo.class);
    public static final String JSON_PACKAGE_FILENAME = "dmuncle-package.json";
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    private JSONObject JSONPackage;
    private JSONArray compileDeps;
    private JSONArray testCompileDeps;
    private JSONArray runtimeDeps;
    private JSONArray systemDeps;

    public void execute() throws MojoExecutionException, MojoFailureException {
        LOG.info("Gathering dependencies for project " + this.project.getName());
        File JSONFile = new File(JSON_PACKAGE_FILENAME);
        if (JSONFile.exists()) {
            this.getExistingJSONPackage();
        } else {
            this.initializeJSONPackage();
        }
        for (int i = 0; i < this.project.getDependencies().size(); ++i) {
            Dependency dependency = (Dependency)this.project.getDependencies().get(i);
            this.addDependencyToJSONPackage(dependency);
        }
        this.saveJSONPackage(this.JSONPackage);
    }

    private void initializeJSONPackage() {
        this.JSONPackage = new JSONObject();
        this.compileDeps = new JSONArray();
        this.testCompileDeps = new JSONArray();
        this.runtimeDeps = new JSONArray();
        this.systemDeps = new JSONArray();
        this.JSONPackage.put((Object)"compileArtifacts", (Object)this.compileDeps);
        this.JSONPackage.put((Object)"testCompileArtifacts", (Object)this.testCompileDeps);
        this.JSONPackage.put((Object)"runtimeArtifacts", (Object)this.runtimeDeps);
        this.JSONPackage.put((Object)"testRuntimeArtifacts", (Object)this.systemDeps);
    }

    private void getExistingJSONPackage() {
        JSONParser parser = new JSONParser();
        try {
            this.JSONPackage = (JSONObject)parser.parse((Reader)new FileReader(JSON_PACKAGE_FILENAME));
            this.compileDeps = (JSONArray)this.JSONPackage.get((Object)"compileArtifacts");
            this.testCompileDeps = (JSONArray)this.JSONPackage.get((Object)"testCompileArtifacts");
            this.runtimeDeps = (JSONArray)this.JSONPackage.get((Object)"runtimeArtifacts");
            this.systemDeps = (JSONArray)this.JSONPackage.get((Object)"testRuntimeArtifacts");
        }
        catch (IOException e) {
            LOG.error("Error encountered on getting json file: " + e.getMessage(), (Throwable)e);
        }
        catch (ParseException e) {
            LOG.error("Error encountered on parsing json file: " + e.getMessage(), (Throwable)e);
        }
    }

    private void addDependencyToJSONPackage(Dependency dependency) {
        JSONObject jsonDep = new JSONObject();
        jsonDep.put((Object)"groupId", (Object)dependency.getGroupId());
        jsonDep.put((Object)"artifactId", (Object)dependency.getArtifactId());
        jsonDep.put((Object)"version", (Object)dependency.getVersion());
        if (dependency.getScope().equals("compile")) {
            this.compileDeps.add((Object)jsonDep);
        }
        if (dependency.getScope().equals("runtime")) {
            this.runtimeDeps.add((Object)jsonDep);
        }
        if (dependency.getScope().equals("system")) {
            this.systemDeps.add((Object)jsonDep);
        }
        if (dependency.getScope().equals("test")) {
            this.testCompileDeps.add((Object)jsonDep);
        }
    }

    void saveJSONPackage(JSONObject jsonPackage) {
        try {
            FileUtils.fileWrite((String)JSON_PACKAGE_FILENAME, (String)jsonPackage.toString());
        }
        catch (IOException e) {
            LOG.error("Error encountered on saving json file: " + e.getMessage(), (Throwable)e);
        }
    }
}

