/*
 * Decompiled with CFR 0.152.
 */
package cc.catalysts.cdoclet.handler;

import cc.catalysts.cdoclet.generator.Generator;
import cc.catalysts.cdoclet.generator.utils.GeneratorUtils;
import cc.catalysts.cdoclet.handler.AbstractHandler;
import cc.catalysts.cdoclet.handler.TagParser;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.Type;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public class ClassHandler
extends AbstractHandler {
    public ClassHandler(Generator generator) {
        super(generator);
    }

    @Override
    public void process(ClassDoc classDoc) {
        Map<String, String> commands = TagParser.processClassTags(this.getGenerator(), classDoc);
        Set<String> ignore = this.getIgnore(commands);
        cc.catalysts.cdoclet.generator.Type type = GeneratorUtils.getType((Type)classDoc, this.getGenerator(), ignore);
        this.getGenerator().beginClass(type);
        this.processAnnotations(classDoc.annotations());
        this.processAnnotationCommands(commands);
        this.processSuperCommands(commands);
        this.processSuperClass(classDoc, ignore);
        this.processInterfaces(classDoc, ignore);
        this.processClassComment(classDoc);
        this.processClassConstants(type, classDoc, ignore);
        this.processBeanProperties(type, classDoc, ignore, commands);
        this.getGenerator().endClass();
    }

    private void processBeanProperties(cc.catalysts.cdoclet.generator.Type type, ClassDoc classDoc, Set<String> ignore, Map<String, String> commands) {
        for (MethodDoc methodDoc : classDoc.methods()) {
            this.processBeanProperty(classDoc, type, methodDoc, ignore, commands);
        }
    }

    private void processSuperClass(ClassDoc classDoc, Collection<String> ignore) {
        cc.catalysts.cdoclet.generator.Type superClass;
        Type type = classDoc.superclassType();
        if (type != null && !type.qualifiedTypeName().equals(Object.class.getCanonicalName()) && (superClass = GeneratorUtils.getType(type, this.getGenerator(), ignore)) != cc.catalysts.cdoclet.generator.Type.NULL && !ignore.contains(superClass.getName())) {
            this.getGenerator().setSuperclass(superClass, this.isException(classDoc));
        }
    }

    private boolean isException(ClassDoc classDoc) {
        while (classDoc != null) {
            if (Exception.class.getCanonicalName().equals(classDoc.qualifiedTypeName())) {
                return true;
            }
            classDoc = classDoc.superclass();
        }
        return false;
    }
}

