/*
 * Decompiled with CFR 0.152.
 */
package cc.catalysts.cdoclet.generator;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import org.apache.commons.lang.ClassUtils;

public class Type {
    public static final Type EMPTY = new Type("", null, null, 0, false, false, null);
    public static final Type NULL = new Type("null", null, null, 0, false, false, null);
    public static final Type VOID = new Type("void", null, null, 0, false, false, null);
    private final String name;
    private final Collection<Type> arguments;
    private final Map<String, Type> bounds;
    private final int dimensions;
    private final boolean _abstract;
    private final boolean generic;
    private final Map<String, String> classMap;
    private Map<String, Type> typeMap;

    public Type(String name, Collection<Type> arguments, Map<String, Type> bounds, int dimensions, boolean _abstract, boolean generic, Map<String, String> classMap) {
        if (name == null) {
            throw new IllegalArgumentException("name");
        }
        this.name = name;
        this.arguments = arguments;
        this.bounds = bounds;
        this.dimensions = dimensions;
        this._abstract = _abstract;
        this.generic = generic;
        this.classMap = classMap;
    }

    public int getDimensions() {
        return this.dimensions;
    }

    public Collection<String> getImports() {
        Collection<String> imports = this.getImportsInternal();
        imports.remove(this.getName());
        return imports;
    }

    protected Collection<String> getImportsInternal() {
        TreeSet<String> set = new TreeSet<String>();
        this.addImports(set, this.getArguments());
        if (this.getBounds() != null) {
            this.addImports(set, this.getBounds().values());
        }
        return set;
    }

    public Collection<Type> getArguments() {
        return this.arguments == null || this.arguments.isEmpty() ? null : this.arguments;
    }

    public Map<String, Type> getBounds() {
        return this.bounds == null || this.bounds.isEmpty() ? null : this.bounds;
    }

    protected Collection<String> addImports(Collection<String> set, Collection<? extends Type> types) {
        if (types != null) {
            for (Type type : types) {
                set.addAll(type.getImports());
                if (type.getName().indexOf(46) <= -1) continue;
                set.add(type.getName());
            }
        }
        return set;
    }

    public String getName() {
        return this.name;
    }

    public Map<String, Type> getTypeMap() {
        if (this.typeMap == null) {
            this.typeMap = new HashMap<String, Type>();
        }
        return this.typeMap;
    }

    public void setTypeMap(Map<String, Type> typeMap) {
        this.typeMap = typeMap;
    }

    public boolean isGeneric() {
        return this.generic;
    }

    public String toString() {
        return this.getName();
    }

    public Collection<String> getPackageImports() {
        TreeSet<String> set = new TreeSet<String>();
        for (String imp : this.getImports()) {
            set.add(ClassUtils.getPackageName((String)imp));
        }
        set.remove(this.getNameSpace());
        return set;
    }

    public String getNameSpace() {
        return ClassUtils.getPackageName((String)this.getQualifiedTypeName());
    }

    public String getQualifiedTypeName() {
        String typeName = this.getName();
        if (this.classMap != null && this.classMap.containsKey(typeName)) {
            return this.classMap.get(typeName);
        }
        return typeName;
    }

    public String getTypeName() {
        return ClassUtils.getShortClassName((String)this.getQualifiedTypeName());
    }

    public boolean isAbstract() {
        return this._abstract;
    }
}

