/*
 * Decompiled with CFR 0.152.
 */
package cc.catalysts.cdoclet.generator;

import cc.catalysts.cdoclet.generator.Generator;
import cc.catalysts.cdoclet.generator.Type;
import cc.catalysts.cdoclet.generator.utils.GeneratorUtils;
import cc.catalysts.cdoclet.generator.velocity.ClassDescriptor;
import cc.catalysts.cdoclet.generator.velocity.EnumDescriptor;
import cc.catalysts.cdoclet.generator.velocity.FieldDescriptor;
import cc.catalysts.cdoclet.generator.velocity.InterfaceDescriptor;
import cc.catalysts.cdoclet.generator.velocity.MethodDescriptor;
import cc.catalysts.cdoclet.generator.velocity.ParameterDescriptor;
import cc.catalysts.cdoclet.generator.velocity.PropertyDescriptor;
import cc.catalysts.cdoclet.generator.velocity.ProxyDescriptor;
import cc.catalysts.cdoclet.generator.velocity.TypeDescriptor;
import cc.catalysts.cdoclet.map.TypeMap;
import com.sun.javadoc.ClassDoc;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;

public class TemplateGenerator
implements Generator {
    private static final Map<String, String> classMap = new HashMap<String, String>();
    private Collection<TypeDescriptor> typeDescriptors = new ArrayList<TypeDescriptor>();
    private TypeDescriptor typeDescriptor;
    private ClassDescriptor proxyTypeDescriptor;
    private FieldDescriptor fieldDescriptor;
    private MethodDescriptor methodDescriptor;
    private MethodDescriptor proxyMethodDescriptor;
    private PropertyDescriptor propertyDescriptor;
    private final File destination;
    private final String encoding;
    private final String language;
    private final String namespace;
    private final String suffix;
    private final TypeMap annotationMap;
    private final TypeMap annotationTypeMap;
    private final TypeMap packageMap;
    private final TypeMap typeMap;
    private final Class<? extends Annotation> enumAnnotation;

    public TemplateGenerator(String destination, String encoding, String namespace, String language, String suffix, Class<? extends Annotation> enumAnnotation, TypeMap typeMap, TypeMap packageMap, TypeMap annotationTypeMap, TypeMap annotationMap) throws Exception {
        this.destination = new File(destination);
        this.encoding = encoding;
        this.namespace = namespace;
        this.language = language;
        this.suffix = suffix;
        this.enumAnnotation = enumAnnotation;
        this.typeMap = typeMap;
        this.packageMap = packageMap;
        this.annotationTypeMap = annotationTypeMap;
        this.annotationMap = annotationMap;
        Velocity.setProperty((String)"runtime.log.logsystem.class", (Object)"cc.catalysts.cdoclet.generator.velocity.SLF4JLogChute");
        Velocity.setProperty((String)"resource.loader", (Object)"class");
        Velocity.setProperty((String)"class.resource.loader.class", (Object)"org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
        Velocity.init();
        this.initTypeMap();
    }

    private void initTypeMap() {
        if ("cs".equals(this.language)) {
            this.initCsTypeMap();
        } else if ("java".equals(this.language)) {
            this.initJavaTypeMap();
        }
    }

    private void initJavaTypeMap() {
        this.annotationMap.addTypeMapping("java.lang.Deprecated", "Deprecated");
        this.typeMap.addTypeMapping("java.lang.Boolean", "Boolean");
        this.typeMap.addTypeMapping("java.lang.Byte", "Byte");
        this.typeMap.addTypeMapping("java.lang.Double", "Double");
        this.typeMap.addTypeMapping("java.lang.Float", "Float");
        this.typeMap.addTypeMapping("java.lang.Integer", "Integer");
        this.typeMap.addTypeMapping("java.lang.Long", "Long");
        this.typeMap.addTypeMapping("java.lang.Number", "Number");
        this.typeMap.addTypeMapping("java.lang.Short", "Short");
        this.typeMap.addTypeMapping("java.lang.Class", "Class");
        this.typeMap.addTypeMapping("java.lang.Object", "Object");
        this.typeMap.addTypeMapping("java.lang.String", "String");
        this.typeMap.addTypeMapping("java.lang.Exception", "Exception");
        this.typeMap.addTypeMapping("java.lang.Throwable", "Throwable");
    }

    private void initCsTypeMap() {
        this.annotationMap.addTypeMapping("java.lang.Deprecated", "System.Obsolete");
        this.typeMap.addTypeMapping("boolean", "bool");
        this.typeMap.addTypeMapping("java.lang.Boolean", "bool?");
        this.typeMap.addTypeMapping("java.lang.Byte", "byte?");
        this.typeMap.addTypeMapping("java.lang.Double", "double?");
        this.typeMap.addTypeMapping("java.lang.Float", "float?");
        this.typeMap.addTypeMapping("java.lang.Integer", "int?");
        this.typeMap.addTypeMapping("java.lang.Long", "long?");
        this.typeMap.addTypeMapping("java.lang.Number", "long?");
        this.typeMap.addTypeMapping("java.lang.Short", "short?");
        this.typeMap.addTypeMapping("java.lang.Class", "System.Type<>");
        this.typeMap.addTypeMapping("java.lang.Object", "object");
        this.typeMap.addTypeMapping("java.lang.String", "string");
        this.typeMap.addTypeMapping("java.lang.Exception", "System.Exception");
        this.typeMap.addTypeMapping("java.util.Date", "System.DateTime?");
        this.typeMap.addTypeMapping("java.util.Collection", "System.Collections.ICollection");
        this.typeMap.addTypeMapping("java.util.List", "System.Collections.IList");
        this.typeMap.addTypeMapping("java.util.Map", "System.Collections.IDictionary");
        this.typeMap.addTypeMapping("java.util.Set", "System.Collections.ICollection");
        this.typeMap.addGenericTypeMapping("java.util.Collection", "System.Collections.Generic.ICollection");
        this.typeMap.addGenericTypeMapping("java.util.List", "System.Collections.Generic.IList");
        this.typeMap.addGenericTypeMapping("java.util.Map", "System.Collections.Generic.IDictionary");
        this.typeMap.addGenericTypeMapping("java.util.Set", "System.Collections.Generic.ICollection");
    }

    @Override
    public Map<String, String> getClassMap() {
        return classMap;
    }

    @Override
    public TypeMap getAnnotationMap() {
        return this.annotationMap;
    }

    @Override
    public TypeMap getAnnotationTypeMap() {
        return this.annotationTypeMap;
    }

    @Override
    public Class<? extends Annotation> getEnumAnnotation() {
        return this.enumAnnotation;
    }

    @Override
    public TypeMap getTypeMap() {
        return this.typeMap;
    }

    @Override
    public TypeMap getPackageMap() {
        return this.packageMap;
    }

    @Override
    public void addAnnotation(Type annotation) {
        if (this.methodDescriptor != null || this.proxyMethodDescriptor != null) {
            if (this.methodDescriptor != null) {
                this.methodDescriptor.addAnnotation(annotation);
            }
            if (this.proxyMethodDescriptor != null) {
                this.proxyMethodDescriptor.addAnnotation(annotation);
            }
        } else if (this.propertyDescriptor != null) {
            this.propertyDescriptor.addAnnotation(annotation);
        } else {
            this.typeDescriptor.addAnnotation(annotation);
        }
    }

    @Override
    public void addSuperclass(Type tag) {
        if (this.methodDescriptor != null || this.proxyMethodDescriptor != null) {
            if (this.methodDescriptor != null) {
                this.methodDescriptor.addSuperclass(tag);
            }
            if (this.proxyMethodDescriptor != null) {
                this.proxyMethodDescriptor.addSuperclass(tag);
            }
        } else if (this.propertyDescriptor != null) {
            this.propertyDescriptor.addSuperclass(tag);
        } else {
            this.typeDescriptor.addSuperclass(tag);
        }
    }

    @Override
    public void addBody(String body) {
        if (this.methodDescriptor != null) {
            this.methodDescriptor.addBody(body);
        }
        if (this.proxyMethodDescriptor != null) {
            this.proxyMethodDescriptor.addBody(body);
        }
    }

    @Override
    public void addConstant(Type classType, Type constantType, String name, String initializer, String comment) {
        this.addField(classType, 8, constantType, name, initializer, comment);
    }

    @Override
    public void addEnumField(Type classType, Type fieldType, String name, Object value, String comment) {
        this.addField(classType, 0, fieldType, name, value, comment);
    }

    @Override
    public void addField(Type classType, int modifier, Type fieldType, String propertyName, Object value, String comment) {
        this.fieldDescriptor = new FieldDescriptor(modifier, fieldType, propertyName, value, this.getClassMap());
        this.setFieldDescription(comment);
        this.typeDescriptor.addFieldDescriptor(this.fieldDescriptor);
    }

    @Override
    public void addInterface(Type name) {
        this.typeDescriptor.addInterface(name);
    }

    @Override
    public void addParameter(Type classType, Type methodType, Type type, String name) {
        ParameterDescriptor parameterDescriptor;
        if (this.methodDescriptor != null) {
            parameterDescriptor = new ParameterDescriptor(type, name, this.getClassMap());
            this.methodDescriptor.addParameterDescriptor(parameterDescriptor);
        }
        if (this.proxyMethodDescriptor != null) {
            type = this.replaceType(type);
            parameterDescriptor = new ParameterDescriptor(type, name, this.getClassMap());
            this.proxyMethodDescriptor.addParameterDescriptor(parameterDescriptor);
        }
    }

    private Type replaceType(Type type) {
        if (type.getTypeMap().containsKey(type.getName())) {
            return type.getTypeMap().get(type.getName());
        }
        ArrayList<Type> arguments = new ArrayList<Type>();
        if (type.getArguments() != null) {
            for (Type argument : type.getArguments()) {
                argument.setTypeMap(type.getTypeMap());
                arguments.add(this.replaceType(argument));
            }
        }
        return new Type(type.getName(), arguments, type.getBounds(), type.getDimensions(), false, type.isGeneric(), this.getClassMap());
    }

    @Override
    public void beginClass(Type type) {
        this.getClassMap().put(type.getName(), type.getName() + this.suffix);
        this.beginType(new ClassDescriptor(type, this.getClassMap()));
    }

    @Override
    public void beginEnum(Type type) {
        this.beginType(new EnumDescriptor(type, this.getClassMap()));
    }

    @Override
    public void beginGetter(Type classType, Type methodType, int modifier, Type returnType, String propertyName, String description, boolean override) {
        this.propertyDescriptor = new PropertyDescriptor(modifier, returnType, methodType, propertyName, this.getClassMap());
        this.propertyDescriptor.setGetter(true);
        this.propertyDescriptor.setOverride(override);
        this.propertyDescriptor.setDescription(description);
        this.typeDescriptor.addPropertyDescriptor(this.propertyDescriptor);
        if (!override && this.typeDescriptor instanceof ClassDescriptor) {
            this.addField(classType, 2, returnType, propertyName, null, description);
        }
    }

    @Override
    public void beginInterface(Type type) {
        this.beginType(new InterfaceDescriptor(type, this.getClassMap()));
    }

    @Override
    public void beginMethod(Type classType, Type methodType, int modifier, Type returnType, String methodName, boolean asnyc, boolean override) {
        this.beginMethod(classType, methodType, modifier, returnType, methodName, asnyc, override, null);
    }

    @Override
    public void beginMethod(Type classType, Type methodType, int modifier, Type returnType, String methodName, boolean asnyc, boolean override, String verb) {
        if (this.typeDescriptor != null) {
            this.methodDescriptor = new MethodDescriptor(modifier, returnType, methodType, methodName, asnyc, this);
            this.methodDescriptor.setOverride(override);
            this.typeDescriptor.addMethodDescriptor(this.methodDescriptor);
        }
        if (this.proxyTypeDescriptor != null) {
            this.proxyMethodDescriptor = new MethodDescriptor(modifier, returnType, methodType, methodName, asnyc, this, verb);
            this.proxyTypeDescriptor.addMethodDescriptor(this.proxyMethodDescriptor);
        }
    }

    @Override
    public void beginProxy(Type proxy, Type baseType, Type interfaceType) {
        this.proxyTypeDescriptor = new ProxyDescriptor(proxy, this.getClassMap());
        this.proxyTypeDescriptor.addInterface(interfaceType);
        if (baseType != Type.NULL) {
            this.proxyTypeDescriptor.setSuperclass(baseType);
        }
        this.typeDescriptors.add(this.proxyTypeDescriptor);
    }

    @Override
    public void beginSetter(Type classType, Type methodType, int modifier, Type returnType, String propertyName, String description, boolean override) {
        this.propertyDescriptor = new PropertyDescriptor(modifier, returnType, methodType, propertyName, this.getClassMap());
        this.propertyDescriptor.setSetter(true);
        this.propertyDescriptor.setOverride(override);
        this.propertyDescriptor.setDescription(description);
        this.typeDescriptor.addPropertyDescriptor(this.propertyDescriptor);
        if (!override && this.typeDescriptor instanceof ClassDescriptor) {
            this.addField(classType, 2, returnType, propertyName, null, description);
        }
    }

    @Override
    public void endClass() {
        this.typeDescriptor = null;
    }

    @Override
    public void endEnum() {
        this.typeDescriptor = null;
    }

    @Override
    public void endGetter() {
        this.propertyDescriptor = null;
    }

    @Override
    public void endInterface() {
        this.typeDescriptor = null;
    }

    @Override
    public void endMethod(Type callbackType) {
        if (callbackType != Type.EMPTY) {
            if (this.methodDescriptor != null) {
                this.methodDescriptor.setCallbackType(callbackType);
            }
            if (this.proxyMethodDescriptor != null) {
                this.proxyMethodDescriptor.setCallbackType(this.replaceType(callbackType));
            }
        }
        this.methodDescriptor = null;
        this.proxyMethodDescriptor = null;
    }

    @Override
    public void endProxy() {
        this.proxyTypeDescriptor = null;
    }

    @Override
    public void endSetter() {
        this.propertyDescriptor = null;
    }

    @Override
    public void generate() throws Exception {
        for (TypeDescriptor descriptor : this.typeDescriptors) {
            String ns = descriptor.getNameSpace();
            if (this.namespace != null && ns.indexOf(this.namespace) == 0 && (ns = ns.substring(this.namespace.length())).startsWith(".")) {
                ns = ns.substring(1);
            }
            String folderName = ns.replace('.', File.separatorChar);
            File folder = new File(this.destination, folderName);
            folder.mkdirs();
            FileWriter writer = new FileWriter(new File(folder, descriptor.getTypeName() + "." + this.language));
            VelocityContext context = new VelocityContext();
            String s = descriptor.getTemplate();
            Template template = Velocity.getTemplate((String)("templates/" + this.language + "/" + s), (String)this.encoding);
            context.put("typeDescriptor", (Object)descriptor);
            template.merge((Context)context, (Writer)writer);
            ((Writer)writer).close();
        }
    }

    @Override
    public String getName() {
        return this.language;
    }

    @Override
    public boolean hasEnumSupport() {
        return true;
    }

    @Override
    public Type postProcessType(Type type) {
        return type;
    }

    @Override
    public void setMethodDescription(String description) {
        if (!StringUtils.isEmpty((String)description)) {
            if (this.methodDescriptor != null) {
                this.methodDescriptor.setDescription(description.trim());
            }
            if (this.proxyMethodDescriptor != null) {
                this.proxyMethodDescriptor.setDescription(description.trim());
            }
        }
    }

    @Override
    public void setSuperclass(Type type, boolean exception) {
        ((ClassDescriptor)this.typeDescriptor).setSuperclass(type);
        if (exception) {
            if ("cs".equals(this.language)) {
                this.beginMethod(type, Type.EMPTY, 1, Type.EMPTY, this.typeDescriptor.getTypeName(), false, false);
                this.addBody(" : base() {}");
                this.endMethod(Type.EMPTY);
                this.beginMethod(type, Type.EMPTY, 1, Type.EMPTY, this.typeDescriptor.getTypeName(), false, false);
                this.addParameter(type, Type.EMPTY, GeneratorUtils.getType(String.class.getCanonicalName(), this), "message");
                this.addBody(" : base(message) {}");
                this.endMethod(Type.EMPTY);
                this.beginMethod(type, Type.EMPTY, 1, Type.EMPTY, this.typeDescriptor.getTypeName(), false, false);
                this.addParameter(type, Type.EMPTY, GeneratorUtils.getType(String.class.getCanonicalName(), this), "message");
                this.addParameter(type, Type.EMPTY, GeneratorUtils.getType(Exception.class.getCanonicalName(), this), "exception");
                this.addBody(" : base(message, exception) {}");
                this.endMethod(Type.EMPTY);
            } else if ("java".equals(this.language)) {
                this.beginMethod(type, Type.EMPTY, 1, Type.EMPTY, this.typeDescriptor.getTypeName(), false, false);
                this.addBody("{\n\t}");
                this.endMethod(Type.EMPTY);
                this.beginMethod(type, Type.EMPTY, 1, Type.EMPTY, this.typeDescriptor.getTypeName(), false, false);
                this.addParameter(type, Type.EMPTY, GeneratorUtils.getType(String.class.getCanonicalName(), this), "message");
                this.addBody("{\n\t\tsuper(message);\n\t}");
                this.endMethod(Type.EMPTY);
                this.beginMethod(type, Type.EMPTY, 1, Type.EMPTY, this.typeDescriptor.getTypeName(), false, false);
                this.addParameter(type, Type.EMPTY, GeneratorUtils.getType(Throwable.class.getCanonicalName(), this), "cause");
                this.addBody("{\n\t\tsuper(cause);\n\t}");
                this.endMethod(Type.EMPTY);
                this.beginMethod(type, Type.EMPTY, 1, Type.EMPTY, this.typeDescriptor.getTypeName(), false, false);
                this.addParameter(type, Type.EMPTY, GeneratorUtils.getType(String.class.getCanonicalName(), this), "message");
                this.addParameter(type, Type.EMPTY, GeneratorUtils.getType(Throwable.class.getCanonicalName(), this), "cause");
                this.addBody("{\n\t\tsuper(message, cause);\n\t}");
                this.endMethod(Type.EMPTY);
            }
        }
    }

    @Override
    public void setTypeDescription(String description) {
        if (!StringUtils.isEmpty((String)description)) {
            this.typeDescriptor.setDescription(description.trim());
        }
    }

    @Override
    public boolean traverse(ClassDoc classDoc) {
        return classDoc.isIncluded();
    }

    private void beginType(TypeDescriptor typeDescriptor) {
        this.typeDescriptor = typeDescriptor;
        this.typeDescriptors.add(typeDescriptor);
    }

    private void setFieldDescription(String description) {
        if (!StringUtils.isEmpty((String)description)) {
            this.fieldDescriptor.setDescription(description.trim());
        }
    }
}

