/*
 * Decompiled with CFR 0.152.
 */
package cc.catalysts.cdoclet.handler;

import cc.catalysts.cdoclet.generator.Generator;
import cc.catalysts.cdoclet.generator.utils.GeneratorUtils;
import cc.catalysts.cdoclet.handler.AbstractHandler;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.Type;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnumHandler
extends AbstractHandler {
    private final Logger logger = LoggerFactory.getLogger(EnumHandler.class);

    public EnumHandler(Generator generator) {
        super(generator);
    }

    @Override
    public void process(ClassDoc classDoc) throws ClassNotFoundException, InvocationTargetException, IllegalAccessException {
        cc.catalysts.cdoclet.generator.Type type = GeneratorUtils.getType(classDoc.qualifiedName(), this.getGenerator());
        this.getGenerator().beginEnum(type);
        this.processClassComment(classDoc);
        this.processEnumConstants(type, classDoc);
        this.getGenerator().endEnum();
    }

    private void processEnumConstants(cc.catalysts.cdoclet.generator.Type type, ClassDoc classDoc) throws InvocationTargetException, IllegalAccessException, ClassNotFoundException {
        Method getter = this.findGetter(classDoc);
        cc.catalysts.cdoclet.generator.Type valueType = GeneratorUtils.getType((Type)classDoc, this.getGenerator(), new HashSet<String>());
        for (FieldDoc fieldDoc : classDoc.enumConstants()) {
            Object value = null;
            if (getter != null) {
                Object enuum = Enum.valueOf(getter.getDeclaringClass(), fieldDoc.name());
                value = getter.invoke(enuum, new Object[0]);
            }
            this.getGenerator().addEnumField(type, valueType, fieldDoc.name(), value, fieldDoc.commentText());
        }
    }

    private Method findGetter(ClassDoc classDoc) throws ClassNotFoundException {
        Class<? extends Annotation> annotation = this.getGenerator().getEnumAnnotation();
        Method getter = null;
        if (annotation != null) {
            try {
                Class<?> clazz = Class.forName(classDoc.qualifiedName());
                boolean present = false;
                for (Method method : clazz.getMethods()) {
                    if (!method.isAnnotationPresent(annotation)) continue;
                    if (present) {
                        throw new RuntimeException("enumeration " + classDoc + " has multiple annotations");
                    }
                    getter = method;
                    present = true;
                }
            }
            catch (ClassNotFoundException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return getter;
    }
}

