/*
 * Decompiled with CFR 0.152.
 */
package cc.catalysts.cdoclet.generator;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import org.apache.commons.lang.ClassUtils;

public class Type {
    public static final Type EMPTY = new Type("", null, null, 0, false);
    public static final Type NULL = new Type("null", null, null, 0, false);
    public static final Type VOID = new Type("void", null, null, 0, false);
    private String name;
    private Collection<Type> arguments;
    private Map<String, Type> bounds;
    private int dimensions;
    private boolean generic;
    private Map<String, Type> typeMap;

    public Type(String name, Collection<Type> arguments, Map<String, Type> bounds, int dimensions, boolean generic) {
        if (name == null) {
            throw new IllegalArgumentException("name");
        }
        this.name = name;
        this.arguments = arguments;
        this.bounds = bounds;
        this.dimensions = dimensions;
        this.generic = generic;
    }

    public int getDimensions() {
        return this.dimensions;
    }

    public Collection<String> getImports() {
        Collection<String> imports = this.getImportsInternal();
        imports.remove(this.getName());
        return imports;
    }

    protected Collection<String> getImportsInternal() {
        TreeSet<String> set = new TreeSet<String>();
        this.addImports(set, this.getArguments());
        if (this.getBounds() != null) {
            this.addImports(set, this.getBounds().values());
        }
        return set;
    }

    public Collection<Type> getArguments() {
        return this.arguments == null || this.arguments.isEmpty() ? null : this.arguments;
    }

    public Map<String, Type> getBounds() {
        return this.bounds == null || this.bounds.isEmpty() ? null : this.bounds;
    }

    protected Collection<String> addImports(Collection<String> set, Collection<? extends Type> types) {
        if (types != null) {
            for (Type type : types) {
                set.addAll(type.getImports());
                if (type.getName().indexOf(46) <= -1) continue;
                set.add(type.getName());
            }
        }
        return set;
    }

    public String getName() {
        return this.name;
    }

    public Map<String, Type> getTypeMap() {
        if (this.typeMap == null) {
            this.typeMap = new HashMap<String, Type>();
        }
        return this.typeMap;
    }

    public void setTypeMap(Map<String, Type> typeMap) {
        this.typeMap = typeMap;
    }

    public boolean isGeneric() {
        return this.generic;
    }

    public String toString() {
        return this.getName();
    }

    public Collection<String> getPackageImports() {
        TreeSet<String> set = new TreeSet<String>();
        for (String imp : this.getImports()) {
            set.add(ClassUtils.getPackageName((String)imp));
        }
        set.remove(this.getNameSpace());
        return set;
    }

    public String getNameSpace() {
        return ClassUtils.getPackageName((String)this.getName());
    }

    public String getQualifiedTypeName() {
        return this.getName();
    }

    public String getTypeName() {
        return ClassUtils.getShortClassName((String)this.getName());
    }
}

