/*
 * Decompiled with CFR 0.152.
 */
package cc.catalysts.cdoclet.generator.velocity;

import cc.catalysts.cdoclet.generator.Type;
import cc.catalysts.cdoclet.generator.velocity.Descriptor;
import cc.catalysts.cdoclet.generator.velocity.FieldDescriptor;
import cc.catalysts.cdoclet.generator.velocity.MethodDescriptor;
import cc.catalysts.cdoclet.generator.velocity.PropertyDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

public abstract class TypeDescriptor
extends Descriptor {
    private Map<String, PropertyDescriptor> propertyDescriptors = new LinkedHashMap<String, PropertyDescriptor>();
    private Map<String, FieldDescriptor> fieldDescriptors = new LinkedHashMap<String, FieldDescriptor>();
    private Collection<MethodDescriptor> methodDescriptors = new ArrayList<MethodDescriptor>();
    private Collection<Type> interfaces = new ArrayList<Type>();

    public TypeDescriptor(Type type, String name) {
        super(type, name);
    }

    @Override
    public Collection<String> getImportsInternal() {
        Collection<String> imports = super.getImportsInternal();
        this.addImports(imports, this.propertyDescriptors.values());
        this.addImports(imports, this.fieldDescriptors.values());
        this.addImports(imports, this.methodDescriptors);
        this.addImports(imports, this.interfaces);
        return imports;
    }

    public Collection<Type> getInterfaces() {
        return this.interfaces;
    }

    public Collection<MethodDescriptor> getMethodDescriptors() {
        return this.methodDescriptors;
    }

    public void addFieldDescriptor(FieldDescriptor fieldDescriptor) {
        this.fieldDescriptors.put(fieldDescriptor.getFieldName(), fieldDescriptor);
    }

    public void addInterface(Type interfaceName) {
        this.interfaces.add(interfaceName);
    }

    public void addMethodDescriptor(MethodDescriptor methodDescriptor) {
        this.methodDescriptors.add(methodDescriptor);
    }

    public void addPropertyDescriptor(PropertyDescriptor propertyDescriptor) {
        PropertyDescriptor pd = this.propertyDescriptors.get(propertyDescriptor.getPropertyName());
        if (pd != null) {
            pd.setGetter(pd.isGetter() || propertyDescriptor.isGetter());
            pd.setSetter(pd.isSetter() || propertyDescriptor.isSetter());
        } else {
            this.propertyDescriptors.put(propertyDescriptor.getPropertyName(), propertyDescriptor);
        }
    }

    public Collection<FieldDescriptor> getFieldDescriptors() {
        return this.fieldDescriptors.values();
    }

    public Collection<PropertyDescriptor> getPropertyDescriptors() {
        return this.propertyDescriptors.values();
    }

    public abstract String getTemplate();
}

