/*
 * Decompiled with CFR 0.152.
 */
package cc.catalysts.cdoclet.generator;

import cc.catalysts.cdoclet.generator.Generator;
import cc.catalysts.cdoclet.generator.Type;
import cc.catalysts.cdoclet.generator.utils.GeneratorUtils;
import cc.catalysts.cdoclet.map.TypeMap;
import com.sun.javadoc.ClassDoc;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.co.badgersinfoil.metaas.ActionScriptFactory;
import uk.co.badgersinfoil.metaas.ActionScriptProject;
import uk.co.badgersinfoil.metaas.dom.ASArg;
import uk.co.badgersinfoil.metaas.dom.ASClassType;
import uk.co.badgersinfoil.metaas.dom.ASCompilationUnit;
import uk.co.badgersinfoil.metaas.dom.ASField;
import uk.co.badgersinfoil.metaas.dom.ASInterfaceType;
import uk.co.badgersinfoil.metaas.dom.ASMethod;
import uk.co.badgersinfoil.metaas.dom.ASType;
import uk.co.badgersinfoil.metaas.dom.Visibility;

public class AsGenerator
implements Generator {
    private static ActionScriptFactory factory = new ActionScriptFactory();
    private final Logger logger = LoggerFactory.getLogger(AsGenerator.class);
    private ActionScriptProject project;
    private ASCompilationUnit unit;
    private ASCompilationUnit proxyUnit;
    private ASType type;
    private ASClassType eventType;
    private ASClassType proxyType;
    private ASMethod method;
    private ASMethod proxyMethod;
    private final TypeMap annotationMap;
    private final TypeMap annotationTypeMap;
    private final TypeMap typeMap;
    private final Class<? extends Annotation> enumAnnotation;
    private final String suffix;
    private Collection<String> imports;
    private Collection<String> proxyImports;

    public AsGenerator(String destination, String namespace, String suffix, Class<? extends Annotation> enumAnnotation, TypeMap typeMap, TypeMap annotationTypeMap, TypeMap annotationMap) {
        this.enumAnnotation = enumAnnotation;
        this.typeMap = typeMap;
        this.annotationTypeMap = annotationTypeMap;
        this.annotationMap = annotationMap;
        this.suffix = suffix;
        this.project = factory.newEmptyASProject(destination);
        this.initTypeMap();
    }

    private void initTypeMap() {
        this.annotationMap.addTypeMapping("java.lang.Deprecated", "Deprecated");
        this.typeMap.setEnumType("String");
        this.typeMap.addTypeMapping("boolean", "Boolean");
        this.typeMap.addTypeMapping("byte", "Number");
        this.typeMap.addTypeMapping("double", "Number");
        this.typeMap.addTypeMapping("float", "Number");
        this.typeMap.addTypeMapping("long", "Number");
        this.typeMap.addTypeMapping("short", "Number");
        this.typeMap.addTypeMapping("java.lang.Boolean", "Object");
        this.typeMap.addTypeMapping("java.lang.Byte", "Object");
        this.typeMap.addTypeMapping("java.lang.Double", "Object");
        this.typeMap.addTypeMapping("java.lang.Float", "Object");
        this.typeMap.addTypeMapping("java.lang.Integer", "Object");
        this.typeMap.addTypeMapping("java.lang.Long", "Object");
        this.typeMap.addTypeMapping("java.lang.Number", "Object");
        this.typeMap.addTypeMapping("java.lang.Short", "Object");
        this.typeMap.addTypeMapping("java.lang.Class", "Object");
        this.typeMap.addTypeMapping("java.lang.Object", "Object");
        this.typeMap.addTypeMapping("java.lang.String", "String");
        this.typeMap.addTypeMapping("java.util.Collection", "Array");
        this.typeMap.addTypeMapping("java.util.Date", "Date");
        this.typeMap.addTypeMapping("java.util.List", "Array");
        this.typeMap.addTypeMapping("java.util.Map", "Array");
        this.typeMap.addTypeMapping("java.util.Set", "Array");
        this.typeMap.addTypeMapping("java.lang.Exception", "null");
    }

    @Override
    public TypeMap getAnnotationMap() {
        return this.annotationMap;
    }

    @Override
    public TypeMap getAnnotationTypeMap() {
        return this.annotationTypeMap;
    }

    @Override
    public Class<? extends Annotation> getEnumAnnotation() {
        return this.enumAnnotation;
    }

    @Override
    public TypeMap getTypeMap() {
        return this.typeMap;
    }

    @Override
    public void addAnnotation(Type tag) {
        if (this.method != null) {
            this.method.newMetaTag(tag.getName());
        } else {
            this.type.newMetaTag(tag.getName());
        }
    }

    @Override
    public void addSuperclass(Type tag) {
    }

    @Override
    public void addBody(String body) {
    }

    @Override
    public void addConstant(Type classType, Type constantType, String name, String initializer, String comment) {
        this.createConst((ASClassType)this.type, name, initializer, constantType.getName(), comment);
    }

    @Override
    public void addEnumField(Type classType, Type fieldType, String name, Object value, String comment) {
        if (value == null) {
            value = name;
        }
        String s = value instanceof Number ? value.toString() : MessageFormat.format("\"{0}\"", name);
        this.addConstant(classType, fieldType, name, s, comment);
    }

    @Override
    public void addField(Type classType, int modifier, Type fieldType, String fieldName, Object value, String comment) {
        fieldType = this.resolveTypeArguments(classType, null, fieldType);
        ASClassType asClassType = (ASClassType)this.type;
        if (asClassType.getField(fieldName) == null) {
            asClassType.newField(fieldName, this.getVisibility(modifier), fieldType.getName());
        }
    }

    @Override
    public void addInterface(Type name) {
        if (this.type instanceof ASInterfaceType) {
            ASInterfaceType interfaceType = (ASInterfaceType)this.type;
            interfaceType.addSuperInterface(name.getName());
        } else {
            ASClassType classType = (ASClassType)this.type;
            classType.addImplementedInterface(name.getName());
        }
        this.addImport(name.getName());
    }

    @Override
    public void addParameter(Type classType, Type methodType, Type type, String name) {
        type = this.resolveTypeArguments(classType, methodType, type);
        if (this.method != null) {
            this.method.addParam(name, type.getName());
        }
        if (this.proxyMethod != null) {
            this.proxyMethod.addParam(name, type.getName());
        }
        this.addImport(type.getName());
    }

    @Override
    public void beginClass(Type classType) {
        this.logger.info("Creating ActionScript class {}", (Object)classType);
        this.newClass(classType.getName() + this.suffix, false);
        this.addAnnotation(GeneratorUtils.getType("RemoteClass(alias=\"" + classType.getName() + "\")", this));
    }

    @Override
    public void beginEnum(Type name) {
        this.logger.info("Creating ActionScript enumeration {}", (Object)name);
        this.newClass(name.getName(), true);
    }

    @Override
    public void beginGetter(Type classType, Type methodType, int modifier, Type fieldType, String propertyName, String comment, boolean override) {
        fieldType = this.resolveTypeArguments(classType, methodType, fieldType);
        if (this.type instanceof ASClassType) {
            this.addField(classType, 2, fieldType, "_" + propertyName, null, null);
            this.beginMethod(classType, Type.EMPTY, modifier, fieldType, "get " + propertyName, false, override);
            this.method.addStmt("return _" + propertyName + ";");
        } else {
            this.beginMethod(classType, Type.EMPTY, modifier, fieldType, "get " + propertyName, false, override);
        }
        this.setMethodDescription(comment);
    }

    @Override
    public void beginInterface(Type name) {
        this.logger.info("Creating ActionScript interface {}", (Object)name);
        this.unit = this.project.newInterface(name.getName());
        this.type = this.unit.getType();
        this.imports = new TreeSet<String>();
    }

    @Override
    public void beginMethod(Type classType, Type methodType, int modifier, Type returnType, String methodName, boolean asnyc, boolean override) {
        this.beginMethod(classType, methodType, modifier, returnType, methodName, asnyc, override, null);
    }

    @Override
    public void beginMethod(Type classType, Type methodType, int modifier, Type returnType, String methodName, boolean asnyc, boolean override, String verb) {
        returnType = this.resolveTypeArguments(classType, methodType, returnType);
        if (this.unit != null) {
            this.method = this.type.newMethod(methodName, this.getVisibility(modifier), returnType.getName());
            this.method.setOverride(override);
        }
        if (this.proxyUnit != null) {
            String proxyMethodName = this.firstToUpper(methodName);
            boolean hasField = false;
            for (Object o : this.eventType.getFields()) {
                ASField field = (ASField)o;
                if (!field.getName().equals(proxyMethodName)) continue;
                hasField = true;
                break;
            }
            if (!hasField) {
                this.createConst(this.eventType, proxyMethodName, MessageFormat.format("\"{0}\"", methodName), "String", null);
                this.proxyMethod = this.proxyType.newMethod(methodName, Visibility.PUBLIC, returnType.getName());
            }
        }
        this.addImport(returnType.getName());
    }

    @Override
    public void beginProxy(Type proxy, Type baseType, Type interfaceType) {
        this.logger.info("Creating ActionScript proxy {}", (Object)proxy.getName());
        ASCompilationUnit eventUnit = this.project.newClass(proxy.getName() + "Events");
        this.proxyUnit = this.project.newClass(proxy.getName());
        this.eventType = (ASClassType)eventUnit.getType();
        this.proxyType = (ASClassType)this.proxyUnit.getType();
        this.proxyType.addImplementedInterface(interfaceType.getName());
        this.proxyImports = new TreeSet<String>();
        this.proxyImports.add(interfaceType.getName());
        if (baseType != Type.NULL) {
            this.proxyType.setSuperclass(baseType.getName());
            this.proxyImports.add(baseType.getName());
        }
        ASMethod callMethod = this.proxyType.newMethod("dispatchCall", Visibility.PROTECTED, "Object");
        callMethod.addParam("name", "String");
        callMethod.addParam("...args", null);
        callMethod.addStmt("throw new Error(\"Not Implemented\");");
        ASMethod resultMethod = this.proxyType.newMethod("onResult", Visibility.PROTECTED, Type.VOID.getName());
        resultMethod.addParam("result", "Object");
        ASMethod statusMethod = this.proxyType.newMethod("onStatus", Visibility.PROTECTED, Type.VOID.getName());
        statusMethod.addParam("status", "Object");
    }

    @Override
    public void beginSetter(Type classType, Type methodType, int modifier, Type fieldType, String propertyName, String comment, boolean override) {
        fieldType = this.resolveTypeArguments(classType, methodType, fieldType);
        if (this.type instanceof ASClassType) {
            this.addField(classType, 2, fieldType, "_" + propertyName, null, null);
            this.beginMethod(classType, Type.EMPTY, modifier, Type.VOID, "set " + propertyName, false, override);
            this.method.addParam("value", fieldType.getName());
            this.method.addStmt("_" + propertyName + "=value;");
        } else {
            this.beginMethod(classType, Type.EMPTY, modifier, Type.VOID, "set " + propertyName, false, override);
            this.method.addParam("value", fieldType.getName());
        }
        this.setMethodDescription(comment);
    }

    @Override
    public void endClass() {
        this.end();
    }

    @Override
    public void endEnum() {
        this.end();
    }

    @Override
    public void endGetter() {
        this.endMethod(Type.EMPTY);
    }

    @Override
    public void endInterface() {
        this.end();
    }

    @Override
    public void endMethod(Type asyncType) {
        if (this.proxyMethod != null) {
            String event = this.eventType.getName() + '.' + this.firstToUpper(this.proxyMethod.getName());
            StringBuilder args = new StringBuilder();
            for (Object o : this.proxyMethod.getArgs()) {
                ASArg arg = (ASArg)o;
                args.append(", ").append(arg.getName());
            }
            if (Type.VOID.getQualifiedTypeName().equals(this.proxyMethod.getType())) {
                this.proxyMethod.addStmt(MessageFormat.format("{0}({1}{2});", "dispatchCall", event, args));
            } else {
                this.proxyMethod.addStmt(MessageFormat.format("return {0}({1}{2}) as {3};", "dispatchCall", event, args, this.proxyMethod.getType()));
            }
        }
        this.proxyMethod = null;
        this.method = null;
    }

    @Override
    public void endProxy() {
        for (String imp : this.proxyImports) {
            this.proxyUnit.getPackage().addImport(imp);
        }
        this.proxyImports = null;
        this.proxyUnit = null;
    }

    @Override
    public void endSetter() {
        this.endMethod(Type.EMPTY);
    }

    @Override
    public void generate() throws IOException {
        this.project.writeAll();
    }

    @Override
    public String getName() {
        return "actionscript";
    }

    @Override
    public boolean hasEnumSupport() {
        return false;
    }

    @Override
    public Type postProcessType(Type type) {
        if (type.getDimensions() > 0) {
            return GeneratorUtils.getType(Collection.class.getCanonicalName(), this);
        }
        return type;
    }

    @Override
    public void setMethodDescription(String description) {
        if (this.unit != null && !StringUtils.isEmpty((String)description)) {
            this.method.setDescription(description.trim());
        }
    }

    @Override
    public void setSuperclass(Type name, boolean exception) {
        ((ASClassType)this.type).setSuperclass(name.getName());
        this.addImport(name.getName());
    }

    @Override
    public void setTypeDescription(String description) {
        if (!StringUtils.isEmpty((String)description)) {
            this.type.setDescription(description.trim());
        }
    }

    @Override
    public boolean traverse(ClassDoc classDoc) {
        return true;
    }

    private void createConst(ASClassType classType, String name, String initializer, String type, String comment) {
        ASField field = classType.newField(name, Visibility.PUBLIC, type);
        field.setInitializer(initializer);
        field.setStatic(true);
        field.setConst(true);
        if (!StringUtils.isEmpty((String)comment)) {
            field.setDescription(comment.trim());
        }
    }

    private void end() {
        for (String imp : this.imports) {
            this.unit.getPackage().addImport(imp);
        }
        this.type = null;
        this.unit = null;
        this.imports = null;
    }

    private String firstToUpper(String methodName) {
        return methodName.length() > 1 ? methodName.substring(0, 1).toUpperCase() + methodName.substring(1) : methodName.toUpperCase();
    }

    private Visibility getVisibility(int modifier) {
        switch (modifier) {
            case 1: {
                return Visibility.PUBLIC;
            }
            case 4: {
                return Visibility.PROTECTED;
            }
            case 2: {
                return Visibility.PRIVATE;
            }
            case 256: {
                return Visibility.INTERNAL;
            }
        }
        return Visibility.DEFAULT;
    }

    private void newClass(String name, boolean isFinal) {
        this.unit = this.project.newClass(name);
        this.type = this.unit.getType();
        ((ASClassType)this.type).setFinal(isFinal);
        this.imports = new TreeSet<String>();
    }

    private Type resolveTypeArguments(Type classType, Type methodType, Type type) {
        Type returnType;
        if (!type.isGeneric()) {
            return type;
        }
        String name = type.getName();
        if (methodType != null && methodType.getBounds() != null && methodType.getBounds().containsKey(name) && (returnType = methodType.getBounds().get(type.getName())) != null) {
            name = type.getName();
            this.addImport(name);
            return returnType;
        }
        if (classType != null && classType.getBounds() != null && classType.getBounds().containsKey(name) && (returnType = classType.getBounds().get(type.getName())) != null) {
            name = type.getName();
            this.addImport(name);
            return returnType;
        }
        return GeneratorUtils.getType(Object.class.getCanonicalName(), this);
    }

    private void addImport(String name) {
        if (name.indexOf(46) > -1) {
            if (this.unit != null) {
                this.imports.add(name);
            }
            if (this.proxyUnit != null) {
                this.proxyImports.add(name);
            }
        }
    }
}

