/*
 * Decompiled with CFR 0.152.
 */
package cc.catalysts.cdoclet;

import cc.catalysts.cdoclet.generator.AsGenerator;
import cc.catalysts.cdoclet.generator.Generator;
import cc.catalysts.cdoclet.generator.TemplateGenerator;
import cc.catalysts.cdoclet.handler.AbstractHandler;
import cc.catalysts.cdoclet.handler.ClassHandler;
import cc.catalysts.cdoclet.handler.EnumHandler;
import cc.catalysts.cdoclet.handler.Handler;
import cc.catalysts.cdoclet.handler.InterfaceHandler;
import cc.catalysts.cdoclet.handler.TagParser;
import cc.catalysts.cdoclet.map.ClassTypeMap;
import cc.catalysts.cdoclet.map.TypeMap;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.util.StatusPrinter;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.DocErrorReporter;
import com.sun.javadoc.LanguageVersion;
import com.sun.javadoc.RootDoc;
import java.net.URL;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CDoclet {
    private static final String PARAM_DESTINATION = "-d";
    private static final String PARAM_NAMESPACE = "-namespace";
    private static final String PARAM_GENERATOR = "-generator";
    private static final String PARAM_ENUM = "-enum";
    private static final String PARAM_MAP = "-map";
    private static final String PARAM_SUFFIX = "-suffix";
    private static final String PARAM_GENERIC_MAP = "-genericmap";
    private static final String PARAM_ANNOTATION_MAP = "-annotation";
    private static final String PARAM_ANNOTATION_TYPE_MAP = "-annotationmap";
    private static final Logger logger = LoggerFactory.getLogger(CDoclet.class);

    public static boolean start(RootDoc root) throws Exception {
        Generator generator = CDoclet.readOptions(root.options());
        ClassDoc[] docs = root.specifiedClasses();
        if (docs.length == 0) {
            docs = root.classes();
        }
        for (ClassDoc classDoc : docs) {
            logger.info("Processing {}", (Object)classDoc.qualifiedName());
            if (!TagParser.hasClassTags(generator, classDoc)) continue;
            Handler handler = CDoclet.createHandler(generator, classDoc);
            handler.process(classDoc);
        }
        generator.generate();
        return true;
    }

    private static Generator readOptions(String[][] options) throws Exception {
        String destination = ".";
        String namespace = null;
        String generator = null;
        String suffix = null;
        Class<?> enumAnnotation = null;
        ClassTypeMap typeMap = new ClassTypeMap();
        TypeMap annotationMap = new TypeMap();
        TypeMap annotationTypeMap = new TypeMap();
        for (String[] opt : options) {
            String[] strings;
            if (opt[0].equals(PARAM_DESTINATION)) {
                destination = opt[1];
                continue;
            }
            if (opt[0].equals(PARAM_NAMESPACE)) {
                namespace = opt[1];
                continue;
            }
            if (opt[0].equals(PARAM_GENERATOR)) {
                generator = opt[1];
                continue;
            }
            if (opt[0].equals(PARAM_SUFFIX)) {
                suffix = opt[1];
                continue;
            }
            if (opt[0].equals(PARAM_ENUM)) {
                enumAnnotation = Class.forName(opt[1]);
                continue;
            }
            if (opt[0].equals(PARAM_MAP)) {
                strings = opt[1].split(":");
                if (strings.length != 2) continue;
                typeMap.addTypeMapping(strings[0], strings[1]);
                continue;
            }
            if (opt[0].equals(PARAM_GENERIC_MAP)) {
                strings = opt[1].split(":");
                if (strings.length != 2) continue;
                typeMap.addGenericTypeMapping(strings[0], strings[1]);
                continue;
            }
            if (opt[0].equals(PARAM_ANNOTATION_MAP)) {
                strings = opt[1].split(":");
                if (strings.length != 2) continue;
                annotationMap.addTypeMapping(strings[0], strings[1]);
                continue;
            }
            if (!opt[0].equals(PARAM_ANNOTATION_TYPE_MAP) || (strings = opt[1].split(":")).length != 2) continue;
            annotationTypeMap.addTypeMapping(strings[0], strings[1]);
        }
        if (suffix == null) {
            suffix = "";
        }
        if ("actionscript".equals(generator)) {
            return new AsGenerator(destination, namespace, suffix, enumAnnotation, typeMap, annotationTypeMap, annotationMap);
        }
        if ("cs".equals(generator) || "java".equals(generator) || "js".equals(generator)) {
            return new TemplateGenerator(destination, namespace, generator, suffix, enumAnnotation, typeMap, annotationTypeMap, annotationMap);
        }
        return null;
    }

    private static Handler createHandler(Generator generator, ClassDoc classDoc) {
        AbstractHandler handler = classDoc.isInterface() ? new InterfaceHandler(generator) : (classDoc.isEnum() ? new EnumHandler(generator) : new ClassHandler(generator));
        return handler;
    }

    public static int optionLength(String option) {
        int length = 0;
        if (Arrays.asList(PARAM_DESTINATION, PARAM_NAMESPACE, PARAM_GENERATOR, PARAM_ENUM, PARAM_MAP, PARAM_GENERIC_MAP, PARAM_ANNOTATION_MAP, PARAM_ANNOTATION_TYPE_MAP).contains(option)) {
            length = 2;
        }
        return length;
    }

    public static boolean validOptions(String[][] options, DocErrorReporter reporter) {
        return true;
    }

    public static LanguageVersion languageVersion() {
        return LanguageVersion.JAVA_1_5;
    }

    private CDoclet() {
    }

    static {
        try {
            URL config = CDoclet.class.getResource("logback-test.xml");
            if (config == null) {
                config = CDoclet.class.getResource("logback.xml");
            }
            LoggerContext lc = (LoggerContext)LoggerFactory.getILoggerFactory();
            lc.reset();
            JoranConfigurator configurator = new JoranConfigurator();
            configurator.setContext((Context)lc);
            configurator.doConfigure(config);
            StatusPrinter.printInCaseOfErrorsOrWarnings((Context)lc);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

