/*
 * Decompiled with CFR 0.152.
 */
package cc.catalysts.cdoclet.handler;

import cc.catalysts.cdoclet.generator.Generator;
import cc.catalysts.cdoclet.generator.utils.GeneratorUtils;
import cc.catalysts.cdoclet.handler.AbstractHandler;
import cc.catalysts.cdoclet.handler.TagParser;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.Parameter;
import com.sun.javadoc.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class InterfaceHandler
extends AbstractHandler {
    public InterfaceHandler(Generator generator) {
        super(generator);
    }

    @Override
    public void process(ClassDoc classDoc) {
        Map<String, String> commands = TagParser.processClassTags(this.getGenerator(), classDoc);
        boolean proxy = TagParser.getBooleanCommand("proxy", commands);
        if (proxy) {
            cc.catalysts.cdoclet.generator.Type interfaceName = GeneratorUtils.getType((Type)classDoc, this.getGenerator(), new HashSet<String>());
            String proxyName = TagParser.getStringCommand("proxy.name", interfaceName + "Proxy", commands);
            String baseType = TagParser.getStringCommand("proxy.superclass", commands);
            cc.catalysts.cdoclet.generator.Type proxyType = GeneratorUtils.getType(proxyName, this.getGenerator());
            cc.catalysts.cdoclet.generator.Type proxyBaseType = GeneratorUtils.getType(baseType, this.getGenerator());
            this.getGenerator().beginProxy(proxyType, proxyBaseType, interfaceName);
        }
        this.processInterfaceInternal(classDoc, commands);
        if (proxy) {
            Set<String> ignore = this.getIgnore(commands);
            this.traverseInterfaces(classDoc, ignore, commands);
            this.getGenerator().endProxy();
        }
    }

    private void processInterfaceInternal(ClassDoc classDoc, Map<String, String> commands) {
        boolean bean = TagParser.getBooleanCommand("bean", commands);
        Set<String> ignore = this.getIgnore(commands);
        cc.catalysts.cdoclet.generator.Type interfaceName = GeneratorUtils.getType((Type)classDoc, this.getGenerator(), ignore);
        this.getGenerator().beginInterface(interfaceName);
        this.processAnnotations(classDoc.annotations());
        this.processAnnotationCommands(commands);
        this.processInterfaces(classDoc, ignore);
        this.processClassComment(classDoc);
        this.processMethods(classDoc, interfaceName, bean, ignore, commands, null);
        this.getGenerator().endInterface();
    }

    private void processMethods(ClassDoc classDoc, cc.catalysts.cdoclet.generator.Type classType, boolean bean, Set<String> ignore, Map<String, String> commands, Map<String, cc.catalysts.cdoclet.generator.Type> typeMap) {
        for (MethodDoc methodDoc : classDoc.methods()) {
            boolean setter;
            boolean getter = (methodDoc.name().startsWith("get") || methodDoc.name().startsWith("is")) && methodDoc.parameters().length == 0;
            boolean bl = setter = methodDoc.name().startsWith("set") && methodDoc.parameters().length == 1;
            if (bean && (getter || setter)) {
                this.processBeanProperty(classDoc, classType, methodDoc, ignore, commands);
                continue;
            }
            this.processMethod(classDoc, classType, methodDoc, ignore, commands, typeMap);
        }
    }

    private void processMethod(ClassDoc classDoc, cc.catalysts.cdoclet.generator.Type classType, MethodDoc methodDoc, Set<String> ignore, Map<String, String> commands, Map<String, cc.catalysts.cdoclet.generator.Type> typeMap) {
        HashMap<String, String> methodCommands = new HashMap<String, String>(commands);
        HashMap<String, String> methodOnlyCommands = new HashMap<String, String>();
        cc.catalysts.cdoclet.generator.Type returnType = GeneratorUtils.getType(methodDoc.returnType(), this.getGenerator(), ignore);
        cc.catalysts.cdoclet.generator.Type methodType = GeneratorUtils.getType(methodDoc, this.getGenerator(), ignore);
        if (typeMap != null) {
            if (typeMap.containsKey(returnType.getName())) {
                returnType = typeMap.get(returnType.getName());
            }
            if (typeMap.containsKey(methodType.getName())) {
                methodType = typeMap.get(methodType.getName());
            }
        }
        returnType.setTypeMap(typeMap);
        cc.catalysts.cdoclet.generator.Type actualReturnType = returnType;
        TagParser.processTags(methodDoc.tags(this.getGenerator().getName() + ".method"), methodOnlyCommands);
        methodCommands.putAll(methodOnlyCommands);
        if (!TagParser.getBooleanCommand("ignore", methodCommands)) {
            cc.catalysts.cdoclet.generator.Type asyncType = cc.catalysts.cdoclet.generator.Type.EMPTY;
            boolean async = TagParser.getBooleanCommand("async", methodCommands);
            if (async) {
                String methodReturnType = TagParser.getStringCommand("async.returntype", methodCommands);
                String callbackType = TagParser.getStringCommand("async.callbacktype", methodCommands);
                if (callbackType != null) {
                    if (callbackType.endsWith("<$type$>")) {
                        ArrayList<cc.catalysts.cdoclet.generator.Type> arguments = new ArrayList<cc.catalysts.cdoclet.generator.Type>();
                        if (!cc.catalysts.cdoclet.generator.Type.VOID.getQualifiedTypeName().equals(returnType.getQualifiedTypeName())) {
                            arguments.add(returnType);
                        }
                        asyncType = new cc.catalysts.cdoclet.generator.Type(callbackType.substring(0, callbackType.length() - 8), arguments, null, 0, false);
                    } else {
                        asyncType = new cc.catalysts.cdoclet.generator.Type(callbackType, null, null, 0, false);
                    }
                    asyncType.setTypeMap(typeMap);
                }
                actualReturnType = methodReturnType != null ? GeneratorUtils.getType(methodReturnType, this.getGenerator()) : cc.catalysts.cdoclet.generator.Type.VOID;
            }
            boolean isasync = asyncType != cc.catalysts.cdoclet.generator.Type.EMPTY;
            String name = methodDoc.name();
            boolean override = this.isOverridden(classDoc, name, ignore);
            this.getGenerator().beginMethod(classType, methodType, 0, actualReturnType, name, isasync, override);
            this.processAnnotations(methodDoc.annotations());
            this.processAnnotationCommands(methodOnlyCommands);
            if (isasync) {
                this.getGenerator().addParameter(classType, methodType, asyncType, "async");
            }
            for (Parameter parameter : methodDoc.parameters()) {
                cc.catalysts.cdoclet.generator.Type type = GeneratorUtils.getType(parameter.type(), this.getGenerator(), ignore);
                type.setTypeMap(typeMap);
                this.getGenerator().addParameter(classType, methodType, type, parameter.name());
            }
            this.processMethodComment(methodDoc);
            this.getGenerator().endMethod(returnType);
        }
    }

    private void processMethodComment(MethodDoc methodDoc) {
        StringBuilder description = new StringBuilder();
        String comment = methodDoc.commentText();
        if (comment != null) {
            description.append(comment.trim());
        }
        this.getGenerator().setMethodDescription(description.toString());
    }

    private void traverseInterfaces(ClassDoc interfaceDoc, Set<String> ignore, Map<String, String> parentCommands) {
        for (Type type : interfaceDoc.interfaceTypes()) {
            cc.catalysts.cdoclet.generator.Type interfaceType;
            ClassDoc classDoc = type.asClassDoc();
            if (!this.getGenerator().traverse(classDoc) || (interfaceType = GeneratorUtils.getType(type, this.getGenerator(), ignore)) == cc.catalysts.cdoclet.generator.Type.NULL) continue;
            HashMap<String, String> commands = new HashMap<String, String>(parentCommands);
            commands.putAll(TagParser.processClassTags(this.getGenerator(), classDoc));
            ignore = this.getIgnore(commands);
            cc.catalysts.cdoclet.generator.Type interfaceClass = GeneratorUtils.getType((Type)classDoc, this.getGenerator(), ignore);
            HashMap<String, cc.catalysts.cdoclet.generator.Type> typeMap = null;
            if (interfaceClass.getArguments() != null && interfaceType.getArguments() != null) {
                typeMap = new HashMap<String, cc.catalysts.cdoclet.generator.Type>();
                Iterator<cc.catalysts.cdoclet.generator.Type> classIterator = interfaceClass.getArguments().iterator();
                Iterator<cc.catalysts.cdoclet.generator.Type> typeIterator = interfaceType.getArguments().iterator();
                while (classIterator.hasNext() && typeIterator.hasNext()) {
                    typeMap.put(classIterator.next().getName(), typeIterator.next());
                }
            }
            boolean bean = TagParser.getBooleanCommand("bean", commands);
            this.processMethods(classDoc, interfaceClass, bean, ignore, commands, typeMap);
            this.traverseInterfaces(classDoc, ignore, commands);
        }
    }
}

