/*
 * Decompiled with CFR 0.152.
 */
package cc.catalysts.cdoclet.handler;

import cc.catalysts.cdoclet.generator.Generator;
import cc.catalysts.cdoclet.generator.utils.GeneratorUtils;
import cc.catalysts.cdoclet.handler.Handler;
import cc.catalysts.cdoclet.handler.TagParser;
import com.sun.javadoc.AnnotationDesc;
import com.sun.javadoc.AnnotationTypeDoc;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.Type;
import java.beans.Introspector;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public abstract class AbstractHandler
implements Handler {
    private static final String COMMENT_PREFIX = "\t * ";
    private final Generator generator;

    protected AbstractHandler(Generator generator) {
        this.generator = generator;
    }

    protected Generator getGenerator() {
        return this.generator;
    }

    protected String getBeanPropertyName(String name) {
        String value = null;
        if (name.startsWith("set")) {
            value = Introspector.decapitalize(name.substring(3));
        } else if (name.startsWith("get")) {
            value = Introspector.decapitalize(name.substring(3));
        } else if (name.startsWith("is")) {
            value = Introspector.decapitalize(name.substring(2));
        }
        return value;
    }

    protected void processBeanProperty(ClassDoc classDoc, cc.catalysts.cdoclet.generator.Type classType, MethodDoc methodDoc, Set<String> ignore, Map<String, String> commands) {
        String propertyName;
        HashMap<String, String> propertyCommands = new HashMap<String, String>(commands);
        HashMap<String, String> propertyOnlyCommands = new HashMap<String, String>();
        TagParser.processTags(methodDoc.tags(this.getGenerator().getName() + ".property"), propertyOnlyCommands);
        propertyCommands.putAll(propertyOnlyCommands);
        if (!TagParser.getBooleanCommand("ignore", propertyCommands) && (propertyName = this.getBeanPropertyName(methodDoc)) != null) {
            String overriddenType = TagParser.getStringCommand("type", propertyCommands);
            cc.catalysts.cdoclet.generator.Type fieldType = this.getFieldType(methodDoc, this.findField(classDoc, propertyName), overriddenType);
            cc.catalysts.cdoclet.generator.Type methodType = cc.catalysts.cdoclet.generator.Type.EMPTY;
            if (fieldType == null) {
                fieldType = GeneratorUtils.getType(methodDoc.returnType(), this.getGenerator(), ignore);
                methodType = GeneratorUtils.getType(methodDoc, this.getGenerator(), ignore);
            }
            String name = methodDoc.name();
            String comment = methodDoc.commentText();
            if (fieldType != cc.catalysts.cdoclet.generator.Type.NULL && (name.startsWith("get") || name.startsWith("is"))) {
                String setterName = "set" + propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1);
                if (classDoc.isInterface()) {
                    this.getGenerator().beginGetter(classType, methodType, 0, fieldType, propertyName, comment, false);
                    this.processAnnotations(methodDoc.annotations());
                    this.processAnnotationCommands(propertyOnlyCommands);
                    this.getGenerator().endGetter();
                    if (this.findMethod(setterName, classDoc)) {
                        this.getGenerator().beginSetter(classType, methodType, 0, fieldType, propertyName, comment, false);
                        this.processAnnotations(methodDoc.annotations());
                        this.processAnnotationCommands(propertyOnlyCommands);
                        this.getGenerator().endSetter();
                    }
                } else {
                    boolean overridden = this.isOverridden(classDoc, name, ignore);
                    this.getGenerator().beginGetter(classType, methodType, 1, fieldType, propertyName, comment, overridden);
                    this.processAnnotations(methodDoc.annotations());
                    this.processAnnotationCommands(propertyOnlyCommands);
                    this.getGenerator().endGetter();
                    this.getGenerator().beginSetter(classType, methodType, 1, fieldType, propertyName, comment, overridden);
                    this.processAnnotations(methodDoc.annotations());
                    this.processAnnotationCommands(propertyOnlyCommands);
                    this.getGenerator().endSetter();
                }
            }
        }
    }

    private String getBeanPropertyName(MethodDoc methodDoc) {
        String propertyName = null;
        if (methodDoc.parameters().length == 0) {
            propertyName = this.getBeanPropertyName(methodDoc.name());
        }
        return propertyName;
    }

    private cc.catalysts.cdoclet.generator.Type getFieldType(MethodDoc methodDoc, FieldDoc fieldDoc, String overriddenType) {
        cc.catalysts.cdoclet.generator.Type fieldType;
        if (overriddenType == null) {
            fieldType = this.checkAnnotations(methodDoc.annotations());
            if (fieldType == null && fieldDoc != null) {
                fieldType = this.checkAnnotations(fieldDoc.annotations());
            }
        } else {
            fieldType = GeneratorUtils.getType(overriddenType, this.getGenerator());
        }
        return fieldType;
    }

    private cc.catalysts.cdoclet.generator.Type checkAnnotations(AnnotationDesc[] annotationDescs) {
        AnnotationDesc annotationDesc;
        AnnotationTypeDoc annotationTypeDoc;
        cc.catalysts.cdoclet.generator.Type fieldType = null;
        AnnotationDesc[] arr$ = annotationDescs;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$ && (fieldType = GeneratorUtils.getAnnotationType((annotationTypeDoc = (annotationDesc = arr$[i$]).annotationType()).qualifiedTypeName(), this.getGenerator())) == null; ++i$) {
        }
        return fieldType;
    }

    private FieldDoc findField(ClassDoc classDoc, String propertyName) {
        FieldDoc fieldDoc = null;
        for (FieldDoc doc : classDoc.fields(false)) {
            if (!doc.name().equals(propertyName)) continue;
            fieldDoc = doc;
            break;
        }
        return fieldDoc;
    }

    private boolean findMethod(String name, ClassDoc superClass) {
        for (MethodDoc superMethod : superClass.methods()) {
            if (!name.equals(superMethod.name())) continue;
            return true;
        }
        return false;
    }

    protected boolean isOverridden(ClassDoc classDoc, String name, Set<String> ignore) {
        if (classDoc.isInterface()) {
            for (ClassDoc interfaceDoc : classDoc.interfaces()) {
                cc.catalysts.cdoclet.generator.Type interfaceClass = GeneratorUtils.getType((Type)interfaceDoc, this.getGenerator(), ignore);
                if (interfaceClass == cc.catalysts.cdoclet.generator.Type.NULL) {
                    return false;
                }
                if (ignore.contains(interfaceDoc.qualifiedTypeName() + "." + name)) {
                    return false;
                }
                if (ignore.contains(interfaceDoc.qualifiedTypeName())) {
                    return false;
                }
                if (this.findMethod(name, interfaceDoc)) {
                    return true;
                }
                Map<String, String> commands = TagParser.processClassTags(this.getGenerator(), interfaceDoc);
                Set<String> interfaceIgnore = this.getIgnore(commands);
                interfaceIgnore.addAll(ignore);
                if (!this.isOverridden(interfaceDoc, name, interfaceIgnore)) continue;
                return true;
            }
        } else {
            for (ClassDoc superClassDoc = classDoc.superclass(); superClassDoc != null; superClassDoc = superClassDoc.superclass()) {
                cc.catalysts.cdoclet.generator.Type superClass = GeneratorUtils.getType((Type)superClassDoc, this.getGenerator(), ignore);
                if (superClass == cc.catalysts.cdoclet.generator.Type.NULL) {
                    return false;
                }
                if (ignore.contains(superClassDoc.qualifiedTypeName() + "." + name)) {
                    return false;
                }
                if (ignore.contains(superClassDoc.qualifiedTypeName())) {
                    return false;
                }
                if (this.findMethod(name, superClassDoc)) {
                    return true;
                }
                Map<String, String> commands = TagParser.processClassTags(this.getGenerator(), superClassDoc);
                ignore.addAll(this.getIgnore(commands));
            }
        }
        return false;
    }

    protected Set<String> getIgnore(Map<String, String> commands) {
        HashSet<String> ignore = new HashSet<String>();
        StringTokenizer tokenizer = new StringTokenizer(TagParser.getStringCommand("ignore", "", commands), ",;");
        while (tokenizer.hasMoreTokens()) {
            ignore.add(tokenizer.nextToken());
        }
        return ignore;
    }

    protected void processAnnotations(AnnotationDesc[] annotationDescs) {
        for (AnnotationDesc annotationDesc : annotationDescs) {
            cc.catalysts.cdoclet.generator.Type annotation = GeneratorUtils.getAnnotation(annotationDesc.annotationType().qualifiedTypeName(), this.getGenerator());
            if (annotation == null || annotation == cc.catalysts.cdoclet.generator.Type.NULL) continue;
            this.getGenerator().addAnnotation(annotation);
        }
    }

    protected void processAnnotationCommands(Map<String, String> commands) {
        if (commands.containsKey("annotation")) {
            StringTokenizer tokenizer = new StringTokenizer(commands.get("annotation"), ",");
            while (tokenizer.hasMoreTokens()) {
                this.getGenerator().addAnnotation(GeneratorUtils.getType(tokenizer.nextToken(), this.getGenerator()));
            }
        }
    }

    protected void processSuperCommands(Map<String, String> commands) {
        if (commands.containsKey("superclass")) {
            StringTokenizer tokenizer = new StringTokenizer(commands.get("superclass"), ",");
            while (tokenizer.hasMoreTokens()) {
                this.getGenerator().addSuperclass(GeneratorUtils.getType(tokenizer.nextToken(), this.getGenerator()));
            }
        }
    }

    protected void processClassComment(ClassDoc classDoc) {
        StringBuilder description = new StringBuilder();
        String comment = classDoc.commentText();
        if (comment != null) {
            description.append(comment.trim());
        }
        if (description.length() > 0) {
            description.append('\r').append(COMMENT_PREFIX);
            description.append('\r').append(COMMENT_PREFIX);
        }
        description.append("Generated by CDoclet from ").append(classDoc.qualifiedTypeName()).append('.').append('\r');
        description.append(COMMENT_PREFIX).append("Do not edit.");
        this.getGenerator().setTypeDescription(description.toString());
    }

    protected void processInterfaces(ClassDoc classDoc, Set<String> ignore) {
        for (Type type : classDoc.interfaceTypes()) {
            cc.catalysts.cdoclet.generator.Type interfaceName = GeneratorUtils.getType(type, this.getGenerator(), ignore);
            if (interfaceName == cc.catalysts.cdoclet.generator.Type.NULL || ignore.contains(interfaceName.getName())) continue;
            this.getGenerator().addInterface(interfaceName);
        }
    }
}

