/*
 * Decompiled with CFR 0.152.
 */
package cc.catalysts.cdoclet.generator.utils;

import cc.catalysts.cdoclet.generator.Generator;
import cc.catalysts.cdoclet.generator.Type;
import cc.catalysts.cdoclet.map.TypeMap;
import com.sun.javadoc.AnnotationDesc;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.ParameterizedType;
import com.sun.javadoc.TypeVariable;
import com.sun.javadoc.WildcardType;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GeneratorUtils {
    private static final Logger logger = LoggerFactory.getLogger(GeneratorUtils.class);
    private static Map<String, Type> enumerationTypes = new HashMap<String, Type>();

    public static Type getType(MethodDoc doc, Generator generator, Collection<String> ignore) {
        logger.debug("Generating type {} <{}>", (Object)doc.name(), (Object)doc.getClass().getCanonicalName());
        HashMap<String, Type> bounds = new HashMap<String, Type>();
        ArrayList<Type> arguments = new ArrayList<Type>();
        logger.debug("Parameters {}", (Object)Arrays.toString(doc.typeParameters()));
        for (TypeVariable argument : doc.typeParameters()) {
            GeneratorUtils.processArgument((com.sun.javadoc.Type)argument, generator, arguments, bounds, ignore, new HashSet<String>());
        }
        String name = generator.getTypeMap().getType(doc.name(), !arguments.isEmpty(), false);
        if ("null".equals(name)) {
            return Type.NULL;
        }
        return generator.postProcessType(new Type(name, arguments, bounds, 0, true));
    }

    private static void processArgument(com.sun.javadoc.Type argument, Generator generator, Collection<Type> arguments, Map<String, Type> bounds, Collection<String> ignore, Collection<String> visited) {
        logger.debug("Processing argument {} <{}>", (Object)argument.qualifiedTypeName(), (Object)argument.getClass().getCanonicalName());
        Type argumentType = GeneratorUtils.getType(argument, generator, ignore, visited);
        if (argumentType != Type.NULL) {
            GeneratorUtils.getTypeBounds(argument, generator, bounds, ignore, visited);
            if (arguments != null) {
                arguments.add(argumentType);
            }
        }
    }

    private static Type getType(com.sun.javadoc.Type type, Generator generator, Collection<String> ignore, Collection<String> visited) {
        String name;
        logger.debug("Generating type {} <{}>", (Object)type.qualifiedTypeName(), (Object)type.getClass().getCanonicalName());
        if (ignore.contains(type.qualifiedTypeName())) {
            return Type.NULL;
        }
        if (visited.contains(type.toString())) {
            return GeneratorUtils.getType(type.qualifiedTypeName(), generator);
        }
        visited.add(type.toString());
        Type enumerationType = GeneratorUtils.getEnumerationType(type, generator);
        if (enumerationType != Type.EMPTY) {
            return enumerationType;
        }
        HashMap<String, Type> bounds = new HashMap<String, Type>();
        ArrayList<Type> arguments = new ArrayList<Type>();
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = type.asParameterizedType();
            logger.debug("Arguments {}", (Object)Arrays.toString(parameterizedType.typeArguments()));
            for (com.sun.javadoc.Type argument : parameterizedType.typeArguments()) {
                GeneratorUtils.processArgument(argument, generator, arguments, bounds, ignore, visited);
            }
        } else if (type instanceof ClassDoc) {
            ClassDoc classDoc = type.asClassDoc();
            logger.debug("Parameters {}", (Object)Arrays.toString(classDoc.typeParameters()));
            for (TypeVariable argument : classDoc.typeParameters()) {
                GeneratorUtils.processArgument((com.sun.javadoc.Type)argument, generator, arguments, bounds, ignore, visited);
            }
        }
        if ("null".equals(name = generator.getTypeMap().getType(type.qualifiedTypeName(), !arguments.isEmpty(), GeneratorUtils.isEnum(type)))) {
            return Type.NULL;
        }
        if (name.endsWith("<>")) {
            arguments.clear();
            bounds.clear();
            name = name.substring(0, name.length() - 2);
        }
        return generator.postProcessType(new Type(name, arguments, bounds, GeneratorUtils.getDimensions(type), type instanceof TypeVariable));
    }

    private static Type getEnumerationType(com.sun.javadoc.Type enumerationType, Generator generator) {
        Class<? extends Annotation> enumAnnotation = generator.getEnumAnnotation();
        ClassDoc classDoc = enumerationType.asClassDoc();
        String typeName = enumerationType.qualifiedTypeName();
        if (generator.hasEnumSupport()) {
            return Type.EMPTY;
        }
        if (enumerationTypes.containsKey(typeName)) {
            return enumerationTypes.get(typeName);
        }
        if (classDoc != null && enumAnnotation != null) {
            for (MethodDoc methodDoc : classDoc.methods()) {
                for (AnnotationDesc annotationDesc : methodDoc.annotations()) {
                    if (!annotationDesc.annotationType().qualifiedTypeName().equals(enumAnnotation.getCanonicalName())) continue;
                    Type type = GeneratorUtils.getType(methodDoc.returnType(), generator, new HashSet<String>());
                    enumerationTypes.put(typeName, type);
                    return type;
                }
            }
            enumerationTypes.put(typeName, Type.EMPTY);
        }
        return Type.EMPTY;
    }

    public static Type getType(com.sun.javadoc.Type type, Generator generator, Collection<String> ignore) {
        return GeneratorUtils.getType(type, generator, ignore, new HashSet<String>());
    }

    public static boolean isEnum(com.sun.javadoc.Type type) {
        return type.asClassDoc() != null && type.asClassDoc().isEnum();
    }

    public static int getDimensions(com.sun.javadoc.Type type) {
        return type.dimension().length() / 2;
    }

    private static void getTypeBounds(com.sun.javadoc.Type argument, Generator generator, Map<String, Type> bounds, Collection<String> ignore, Collection<String> visited) {
        com.sun.javadoc.Type[] types = null;
        if (argument instanceof TypeVariable) {
            types = argument.asTypeVariable().bounds();
        } else if (argument instanceof WildcardType) {
            types = argument.asWildcardType().extendsBounds();
            bounds.put("?", GeneratorUtils.getType(Object.class.getCanonicalName(), generator, generator.getTypeMap()));
        }
        if (types != null) {
            Type bound;
            com.sun.javadoc.Type boundType;
            com.sun.javadoc.Type type = boundType = types.length > 0 ? types[0] : null;
            if (boundType != null && (bound = GeneratorUtils.getType(boundType, generator, ignore, visited)) != Type.NULL) {
                logger.debug("Adding boundary {} extends {} <{}>", new Object[]{argument.qualifiedTypeName(), boundType.qualifiedTypeName(), boundType.getClass().getCanonicalName()});
                bounds.put(argument.qualifiedTypeName(), bound);
            }
        }
    }

    private static Type getType(String name, Generator generator, TypeMap typeMap) {
        String type = typeMap.getType(name, false, false);
        if (type == null) {
            return null;
        }
        if ("null".equals(type)) {
            return Type.NULL;
        }
        return generator.postProcessType(new Type(type, null, null, 0, false));
    }

    public static Type getType(String name, Generator generator) {
        if (name == null) {
            return Type.NULL;
        }
        return GeneratorUtils.getType(name, generator, generator.getTypeMap());
    }

    public static Type getAnnotationType(String name, Generator generator) {
        return GeneratorUtils.getType(name, generator, generator.getAnnotationTypeMap());
    }

    public static Type getAnnotation(String name, Generator generator) {
        return GeneratorUtils.getType(name, generator, generator.getAnnotationMap());
    }
}

