/*
 * Decompiled with CFR 0.152.
 */
package cc.catalysts.cdoclet.handler;

import cc.catalysts.cdoclet.generator.Generator;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Tag;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TagParser {
    private static final Pattern parseCommandPattern = Pattern.compile("(\\S+)\\s*=\\s*(\\S+)");

    public static boolean getBooleanCommand(String string, Map<String, String> map) {
        boolean bl = false;
        if (map.containsKey(string)) {
            bl = Boolean.parseBoolean(map.get(string));
        }
        return bl;
    }

    public static String getStringCommand(String string, Map<String, String> map) {
        return TagParser.getStringCommand(string, null, map);
    }

    public static String getStringCommand(String string, String string2, Map<String, String> map) {
        String string3 = string2;
        if (map.containsKey(string)) {
            string3 = String.valueOf(map.get(string));
        }
        return string3;
    }

    public static boolean hasClassTags(Generator generator, ClassDoc classDoc) {
        if (classDoc == null) {
            return false;
        }
        Tag[] tagArray = classDoc.tags(generator.getName() + ".class");
        return tagArray.length > 0;
    }

    public static Map<String, String> processClassTags(Generator generator, ClassDoc classDoc) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        TagParser.processTags(classDoc.tags(generator.getName() + ".class"), hashMap);
        TagParser.processTags(classDoc.tags(generator.getName() + ".method"), hashMap);
        TagParser.processTags(classDoc.tags(generator.getName() + ".property"), hashMap);
        return hashMap;
    }

    public static void processTags(Tag[] tagArray, Map<String, String> map) {
        for (Tag tag : tagArray) {
            TagParser.processTag(tag, map);
        }
    }

    private static void processTag(Tag tag, Map<String, String> map) {
        Matcher matcher = parseCommandPattern.matcher(tag.text());
        while (matcher.find()) {
            String string = matcher.group(2).replaceAll("<.*?>", "");
            string = string.replaceAll("&lt;", "<");
            string = string.replaceAll("&gt;", ">");
            map.put(matcher.group(1), string);
        }
    }
}

