/*
 * Decompiled with CFR 0.152.
 */
package cc.catalysts.cdoclet.generator;

import cc.catalysts.cdoclet.generator.Generator;
import cc.catalysts.cdoclet.generator.Type;
import cc.catalysts.cdoclet.generator.utils.GeneratorUtils;
import cc.catalysts.cdoclet.generator.velocity.ClassDescriptor;
import cc.catalysts.cdoclet.generator.velocity.EnumDescriptor;
import cc.catalysts.cdoclet.generator.velocity.FieldDescriptor;
import cc.catalysts.cdoclet.generator.velocity.InterfaceDescriptor;
import cc.catalysts.cdoclet.generator.velocity.MethodDescriptor;
import cc.catalysts.cdoclet.generator.velocity.ParameterDescriptor;
import cc.catalysts.cdoclet.generator.velocity.PropertyDescriptor;
import cc.catalysts.cdoclet.generator.velocity.ProxyDescriptor;
import cc.catalysts.cdoclet.generator.velocity.TypeDescriptor;
import cc.catalysts.cdoclet.map.TypeMap;
import com.sun.javadoc.ClassDoc;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;

public class TemplateGenerator
implements Generator {
    private Collection<TypeDescriptor> typeDescriptors = new ArrayList<TypeDescriptor>();
    private TypeDescriptor typeDescriptor;
    private ClassDescriptor proxyTypeDescriptor;
    private FieldDescriptor fieldDescriptor;
    private MethodDescriptor methodDescriptor;
    private MethodDescriptor proxyMethodDescriptor;
    private PropertyDescriptor propertyDescriptor;
    private final File destination;
    private final String language;
    private final String namespace;
    private final TypeMap annotationMap;
    private final TypeMap annotationTypeMap;
    private final TypeMap typeMap;
    private final Class<? extends Annotation> enumAnnotation;

    public TemplateGenerator(String string, String string2, String string3, Class<? extends Annotation> clazz, TypeMap typeMap, TypeMap typeMap2, TypeMap typeMap3) throws Exception {
        this.destination = new File(string);
        this.namespace = string2;
        this.language = string3;
        this.enumAnnotation = clazz;
        this.typeMap = typeMap;
        this.annotationTypeMap = typeMap2;
        this.annotationMap = typeMap3;
        Velocity.setProperty((String)"runtime.log.logsystem.class", (Object)"cc.catalysts.cdoclet.generator.velocity.SLF4JLogChute");
        Velocity.setProperty((String)"resource.loader", (Object)"class");
        Velocity.setProperty((String)"class.resource.loader.class", (Object)"org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
        Velocity.init();
        this.initTypeMap();
    }

    private void initTypeMap() {
        if ("cs".equals(this.language)) {
            this.initCsTypeMap();
        } else if ("java".equals(this.language)) {
            this.initJavaTypeMap();
        }
    }

    private void initJavaTypeMap() {
        this.annotationMap.addTypeMapping("java.lang.Deprecated", "Deprecated");
        this.typeMap.addTypeMapping("java.lang.Boolean", "Boolean");
        this.typeMap.addTypeMapping("java.lang.Byte", "Byte");
        this.typeMap.addTypeMapping("java.lang.Double", "Double");
        this.typeMap.addTypeMapping("java.lang.Float", "Float");
        this.typeMap.addTypeMapping("java.lang.Integer", "Integer");
        this.typeMap.addTypeMapping("java.lang.Long", "Long");
        this.typeMap.addTypeMapping("java.lang.Number", "Number");
        this.typeMap.addTypeMapping("java.lang.Short", "Short");
        this.typeMap.addTypeMapping("java.lang.Class", "Class");
        this.typeMap.addTypeMapping("java.lang.Object", "Object");
        this.typeMap.addTypeMapping("java.lang.String", "String");
        this.typeMap.addTypeMapping("java.lang.Exception", "Exception");
        this.typeMap.addTypeMapping("java.lang.Throwable", "Throwable");
    }

    private void initCsTypeMap() {
        this.annotationMap.addTypeMapping("java.lang.Deprecated", "System.Obsolete");
        this.typeMap.addTypeMapping("boolean", "bool");
        this.typeMap.addTypeMapping("java.lang.Boolean", "bool?");
        this.typeMap.addTypeMapping("java.lang.Byte", "byte?");
        this.typeMap.addTypeMapping("java.lang.Double", "double?");
        this.typeMap.addTypeMapping("java.lang.Float", "float?");
        this.typeMap.addTypeMapping("java.lang.Integer", "int?");
        this.typeMap.addTypeMapping("java.lang.Long", "long?");
        this.typeMap.addTypeMapping("java.lang.Number", "long?");
        this.typeMap.addTypeMapping("java.lang.Short", "short?");
        this.typeMap.addTypeMapping("java.lang.Class", "System.Type<>");
        this.typeMap.addTypeMapping("java.lang.Object", "object");
        this.typeMap.addTypeMapping("java.lang.String", "string");
        this.typeMap.addTypeMapping("java.lang.Exception", "System.Exception");
        this.typeMap.addTypeMapping("java.util.Date", "System.DateTime?");
        this.typeMap.addTypeMapping("java.util.Collection", "System.Collections.ICollection");
        this.typeMap.addTypeMapping("java.util.List", "System.Collections.IList");
        this.typeMap.addTypeMapping("java.util.Map", "System.Collections.IDictionary");
        this.typeMap.addTypeMapping("java.util.Set", "System.Collections.ICollection");
        this.typeMap.addGenericTypeMapping("java.util.Collection", "System.Collections.Generic.ICollection");
        this.typeMap.addGenericTypeMapping("java.util.List", "System.Collections.Generic.IList");
        this.typeMap.addGenericTypeMapping("java.util.Map", "System.Collections.Generic.IDictionary");
        this.typeMap.addGenericTypeMapping("java.util.Set", "System.Collections.Generic.ICollection");
    }

    @Override
    public TypeMap getAnnotationMap() {
        return this.annotationMap;
    }

    @Override
    public TypeMap getAnnotationTypeMap() {
        return this.annotationTypeMap;
    }

    @Override
    public Class<? extends Annotation> getEnumAnnotation() {
        return this.enumAnnotation;
    }

    @Override
    public TypeMap getTypeMap() {
        return this.typeMap;
    }

    @Override
    public void addAnnotation(Type type) {
        if (this.methodDescriptor != null || this.proxyMethodDescriptor != null) {
            if (this.methodDescriptor != null) {
                this.methodDescriptor.addAnnotation(type);
            }
            if (this.proxyMethodDescriptor != null) {
                this.proxyMethodDescriptor.addAnnotation(type);
            }
        } else if (this.propertyDescriptor != null) {
            this.propertyDescriptor.addAnnotation(type);
        } else {
            this.typeDescriptor.addAnnotation(type);
        }
    }

    @Override
    public void addSuperclass(Type type) {
        if (this.methodDescriptor != null || this.proxyMethodDescriptor != null) {
            if (this.methodDescriptor != null) {
                this.methodDescriptor.addSuperclass(type);
            }
            if (this.proxyMethodDescriptor != null) {
                this.proxyMethodDescriptor.addSuperclass(type);
            }
        } else if (this.propertyDescriptor != null) {
            this.propertyDescriptor.addSuperclass(type);
        } else {
            this.typeDescriptor.addSuperclass(type);
        }
    }

    @Override
    public void addBody(String string) {
        if (this.methodDescriptor != null) {
            this.methodDescriptor.addBody(string);
        }
        if (this.proxyMethodDescriptor != null) {
            this.proxyMethodDescriptor.addBody(string);
        }
    }

    @Override
    public void addConstant(Type type, Type type2, String string, String string2, String string3) {
        this.addField(type, 8, type2, string, string2, string3);
    }

    @Override
    public void addEnumField(Type type, Type type2, String string, Object object, String string2) {
        this.addField(type, 0, type2, string, object, string2);
    }

    @Override
    public void addField(Type type, int n, Type type2, String string, Object object, String string2) {
        this.fieldDescriptor = new FieldDescriptor(n, type2, string, object);
        this.setFieldDescription(string2);
        this.typeDescriptor.addFieldDescriptor(this.fieldDescriptor);
    }

    @Override
    public void addInterface(Type type) {
        this.typeDescriptor.addInterface(type);
    }

    @Override
    public void addParameter(Type type, Type type2, Type type3, String string) {
        ParameterDescriptor parameterDescriptor;
        if (this.methodDescriptor != null) {
            parameterDescriptor = new ParameterDescriptor(type3, string);
            this.methodDescriptor.addParameterDescriptor(parameterDescriptor);
        }
        if (this.proxyMethodDescriptor != null) {
            type3 = this.replaceType(type3);
            parameterDescriptor = new ParameterDescriptor(type3, string);
            this.proxyMethodDescriptor.addParameterDescriptor(parameterDescriptor);
        }
    }

    private Type replaceType(Type type) {
        if (type.getTypeMap().containsKey(type.getName())) {
            return type.getTypeMap().get(type.getName());
        }
        ArrayList<Type> arrayList = new ArrayList<Type>();
        if (type.getArguments() != null) {
            for (Type type2 : type.getArguments()) {
                type2.setTypeMap(type.getTypeMap());
                arrayList.add(this.replaceType(type2));
            }
        }
        return new Type(type.getName(), arrayList, type.getBounds(), type.getDimensions(), type.isGeneric());
    }

    @Override
    public void beginClass(Type type) {
        this.beginType(new ClassDescriptor(type));
    }

    @Override
    public void beginEnum(Type type) {
        this.beginType(new EnumDescriptor(type));
    }

    @Override
    public void beginGetter(Type type, Type type2, int n, Type type3, String string, String string2, boolean bl) {
        this.propertyDescriptor = new PropertyDescriptor(n, type3, type2, string);
        this.propertyDescriptor.setGetter(true);
        this.propertyDescriptor.setOverride(bl);
        this.propertyDescriptor.setDescription(string2);
        this.typeDescriptor.addPropertyDescriptor(this.propertyDescriptor);
        if (this.typeDescriptor instanceof ClassDescriptor) {
            this.addField(type, 2, type3, string, null, string2);
        }
    }

    @Override
    public void beginInterface(Type type) {
        this.beginType(new InterfaceDescriptor(type));
    }

    @Override
    public void beginMethod(Type type, Type type2, int n, Type type3, String string, boolean bl, boolean bl2) {
        if (this.typeDescriptor != null) {
            this.methodDescriptor = new MethodDescriptor(n, type3, type2, string, bl);
            this.methodDescriptor.setOverride(bl2);
            this.typeDescriptor.addMethodDescriptor(this.methodDescriptor);
        }
        if (this.proxyTypeDescriptor != null) {
            this.proxyMethodDescriptor = new MethodDescriptor(n, type3, type2, string, bl);
            this.proxyTypeDescriptor.addMethodDescriptor(this.proxyMethodDescriptor);
        }
    }

    @Override
    public void beginProxy(Type type, Type type2, Type type3) {
        this.proxyTypeDescriptor = new ProxyDescriptor(type);
        this.proxyTypeDescriptor.addInterface(type3);
        if (type2 != Type.NULL) {
            this.proxyTypeDescriptor.setSuperclass(type2);
        }
        this.typeDescriptors.add(this.proxyTypeDescriptor);
    }

    @Override
    public void beginSetter(Type type, Type type2, int n, Type type3, String string, String string2, boolean bl) {
        this.propertyDescriptor = new PropertyDescriptor(n, type3, type2, string);
        this.propertyDescriptor.setSetter(true);
        this.propertyDescriptor.setOverride(bl);
        this.propertyDescriptor.setDescription(string2);
        this.typeDescriptor.addPropertyDescriptor(this.propertyDescriptor);
        if (this.typeDescriptor instanceof ClassDescriptor) {
            this.addField(type, 2, type3, string, null, string2);
        }
    }

    @Override
    public void endClass() {
        this.typeDescriptor = null;
    }

    @Override
    public void endEnum() {
        this.typeDescriptor = null;
    }

    @Override
    public void endGetter() {
        this.propertyDescriptor = null;
    }

    @Override
    public void endInterface() {
        this.typeDescriptor = null;
    }

    @Override
    public void endMethod(Type type) {
        if (type != Type.EMPTY) {
            if (this.methodDescriptor != null) {
                this.methodDescriptor.setCallbackType(type);
            }
            if (this.proxyMethodDescriptor != null) {
                this.proxyMethodDescriptor.setCallbackType(this.replaceType(type));
            }
        }
        this.methodDescriptor = null;
        this.proxyMethodDescriptor = null;
    }

    @Override
    public void endProxy() {
        this.proxyTypeDescriptor = null;
    }

    @Override
    public void endSetter() {
        this.propertyDescriptor = null;
    }

    @Override
    public void generate() throws Exception {
        for (TypeDescriptor typeDescriptor : this.typeDescriptors) {
            String string = typeDescriptor.getNameSpace();
            if (this.namespace != null && string.indexOf(this.namespace) == 0 && (string = string.substring(this.namespace.length())).startsWith(".")) {
                string = string.substring(1);
            }
            String string2 = string.replace('.', File.separatorChar);
            File file = new File(this.destination, string2);
            file.mkdirs();
            FileWriter fileWriter = new FileWriter(new File(file, typeDescriptor.getTypeName() + "." + this.language));
            VelocityContext velocityContext = new VelocityContext();
            String string3 = typeDescriptor.getTemplate();
            Template template = Velocity.getTemplate((String)("templates/" + this.language + "/" + string3));
            velocityContext.put("typeDescriptor", (Object)typeDescriptor);
            template.merge((Context)velocityContext, (Writer)fileWriter);
            ((Writer)fileWriter).close();
        }
    }

    @Override
    public String getName() {
        return this.language;
    }

    @Override
    public boolean hasEnumSupport() {
        return true;
    }

    @Override
    public Type postProcessType(Type type) {
        return type;
    }

    @Override
    public void setMethodDescription(String string) {
        if (!StringUtils.isEmpty((String)string)) {
            if (this.methodDescriptor != null) {
                this.methodDescriptor.setDescription(string.trim());
            }
            if (this.proxyMethodDescriptor != null) {
                this.proxyMethodDescriptor.setDescription(string.trim());
            }
        }
    }

    @Override
    public void setSuperclass(Type type, boolean bl) {
        ((ClassDescriptor)this.typeDescriptor).setSuperclass(type);
        if (bl) {
            if ("cs".equals(this.language)) {
                this.beginMethod(type, Type.EMPTY, 1, Type.EMPTY, this.typeDescriptor.getTypeName(), false, false);
                this.addBody(" : base() {}");
                this.endMethod(Type.EMPTY);
                this.beginMethod(type, Type.EMPTY, 1, Type.EMPTY, this.typeDescriptor.getTypeName(), false, false);
                this.addParameter(type, Type.EMPTY, GeneratorUtils.getType(String.class.getCanonicalName(), this), "message");
                this.addBody(" : base(message) {}");
                this.endMethod(Type.EMPTY);
                this.beginMethod(type, Type.EMPTY, 1, Type.EMPTY, this.typeDescriptor.getTypeName(), false, false);
                this.addParameter(type, Type.EMPTY, GeneratorUtils.getType(String.class.getCanonicalName(), this), "message");
                this.addParameter(type, Type.EMPTY, GeneratorUtils.getType(Exception.class.getCanonicalName(), this), "exception");
                this.addBody(" : base(message, exception) {}");
                this.endMethod(Type.EMPTY);
            } else if ("java".equals(this.language)) {
                this.beginMethod(type, Type.EMPTY, 1, Type.EMPTY, this.typeDescriptor.getTypeName(), false, false);
                this.addBody("{\n\t}");
                this.endMethod(Type.EMPTY);
                this.beginMethod(type, Type.EMPTY, 1, Type.EMPTY, this.typeDescriptor.getTypeName(), false, false);
                this.addParameter(type, Type.EMPTY, GeneratorUtils.getType(String.class.getCanonicalName(), this), "message");
                this.addBody("{\n\t\tsuper(message);\n\t}");
                this.endMethod(Type.EMPTY);
                this.beginMethod(type, Type.EMPTY, 1, Type.EMPTY, this.typeDescriptor.getTypeName(), false, false);
                this.addParameter(type, Type.EMPTY, GeneratorUtils.getType(Throwable.class.getCanonicalName(), this), "cause");
                this.addBody("{\n\t\tsuper(cause);\n\t}");
                this.endMethod(Type.EMPTY);
                this.beginMethod(type, Type.EMPTY, 1, Type.EMPTY, this.typeDescriptor.getTypeName(), false, false);
                this.addParameter(type, Type.EMPTY, GeneratorUtils.getType(String.class.getCanonicalName(), this), "message");
                this.addParameter(type, Type.EMPTY, GeneratorUtils.getType(Throwable.class.getCanonicalName(), this), "cause");
                this.addBody("{\n\t\tsuper(message, cause);\n\t}");
                this.endMethod(Type.EMPTY);
            }
        }
    }

    @Override
    public void setTypeDescription(String string) {
        if (!StringUtils.isEmpty((String)string)) {
            this.typeDescriptor.setDescription(string.trim());
        }
    }

    @Override
    public boolean traverse(ClassDoc classDoc) {
        return classDoc.isIncluded();
    }

    private void beginType(TypeDescriptor typeDescriptor) {
        this.typeDescriptor = typeDescriptor;
        this.typeDescriptors.add(typeDescriptor);
    }

    private void setFieldDescription(String string) {
        if (!StringUtils.isEmpty((String)string)) {
            this.fieldDescriptor.setDescription(string.trim());
        }
    }
}

