/*
 * Decompiled with CFR 0.152.
 */
package cc.catalysts.cdoclet.generator;

import cc.catalysts.cdoclet.generator.Generator;
import cc.catalysts.cdoclet.generator.Type;
import cc.catalysts.cdoclet.generator.utils.GeneratorUtils;
import cc.catalysts.cdoclet.map.TypeMap;
import com.sun.javadoc.ClassDoc;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.co.badgersinfoil.metaas.ActionScriptFactory;
import uk.co.badgersinfoil.metaas.ActionScriptProject;
import uk.co.badgersinfoil.metaas.dom.ASArg;
import uk.co.badgersinfoil.metaas.dom.ASClassType;
import uk.co.badgersinfoil.metaas.dom.ASCompilationUnit;
import uk.co.badgersinfoil.metaas.dom.ASField;
import uk.co.badgersinfoil.metaas.dom.ASInterfaceType;
import uk.co.badgersinfoil.metaas.dom.ASMethod;
import uk.co.badgersinfoil.metaas.dom.ASType;
import uk.co.badgersinfoil.metaas.dom.Visibility;

public class AsGenerator
implements Generator {
    private static ActionScriptFactory factory = new ActionScriptFactory();
    private final Logger logger = LoggerFactory.getLogger(AsGenerator.class);
    private ActionScriptProject project;
    private ASCompilationUnit unit;
    private ASCompilationUnit proxyUnit;
    private ASType type;
    private ASClassType eventType;
    private ASClassType proxyType;
    private ASMethod method;
    private ASMethod proxyMethod;
    private final TypeMap annotationMap;
    private final TypeMap annotationTypeMap;
    private final TypeMap typeMap;
    private final Class<? extends Annotation> enumAnnotation;
    private Collection<String> imports;
    private Collection<String> proxyImports;

    public AsGenerator(String string, String string2, Class<? extends Annotation> clazz, TypeMap typeMap, TypeMap typeMap2, TypeMap typeMap3) {
        this.enumAnnotation = clazz;
        this.typeMap = typeMap;
        this.annotationTypeMap = typeMap2;
        this.annotationMap = typeMap3;
        this.project = factory.newEmptyASProject(string);
        this.initTypeMap();
    }

    private void initTypeMap() {
        this.annotationMap.addTypeMapping("java.lang.Deprecated", "Deprecated");
        this.typeMap.setEnumType("String");
        this.typeMap.addTypeMapping("boolean", "Boolean");
        this.typeMap.addTypeMapping("byte", "Number");
        this.typeMap.addTypeMapping("double", "Number");
        this.typeMap.addTypeMapping("float", "Number");
        this.typeMap.addTypeMapping("long", "Number");
        this.typeMap.addTypeMapping("short", "Number");
        this.typeMap.addTypeMapping("java.lang.Boolean", "Object");
        this.typeMap.addTypeMapping("java.lang.Byte", "Object");
        this.typeMap.addTypeMapping("java.lang.Double", "Object");
        this.typeMap.addTypeMapping("java.lang.Float", "Object");
        this.typeMap.addTypeMapping("java.lang.Integer", "Object");
        this.typeMap.addTypeMapping("java.lang.Long", "Object");
        this.typeMap.addTypeMapping("java.lang.Number", "Object");
        this.typeMap.addTypeMapping("java.lang.Short", "Object");
        this.typeMap.addTypeMapping("java.lang.Class", "Object");
        this.typeMap.addTypeMapping("java.lang.Object", "Object");
        this.typeMap.addTypeMapping("java.lang.String", "String");
        this.typeMap.addTypeMapping("java.util.Collection", "Array");
        this.typeMap.addTypeMapping("java.util.Date", "Date");
        this.typeMap.addTypeMapping("java.util.List", "Array");
        this.typeMap.addTypeMapping("java.util.Map", "Array");
        this.typeMap.addTypeMapping("java.util.Set", "Array");
        this.typeMap.addTypeMapping("java.lang.Exception", "null");
    }

    @Override
    public TypeMap getAnnotationMap() {
        return this.annotationMap;
    }

    @Override
    public TypeMap getAnnotationTypeMap() {
        return this.annotationTypeMap;
    }

    @Override
    public Class<? extends Annotation> getEnumAnnotation() {
        return this.enumAnnotation;
    }

    @Override
    public TypeMap getTypeMap() {
        return this.typeMap;
    }

    @Override
    public void addAnnotation(Type type) {
        if (this.method != null) {
            this.method.newMetaTag(type.getName());
        } else {
            this.type.newMetaTag(type.getName());
        }
    }

    @Override
    public void addSuperclass(Type type) {
    }

    @Override
    public void addBody(String string) {
    }

    @Override
    public void addConstant(Type type, Type type2, String string, String string2, String string3) {
        this.createConst((ASClassType)this.type, string, string2, type2.getName(), string3);
    }

    @Override
    public void addEnumField(Type type, Type type2, String string, Object object, String string2) {
        if (object == null) {
            object = string;
        }
        String string3 = object instanceof Number ? object.toString() : MessageFormat.format("\"{0}\"", string);
        this.addConstant(type, type2, string, string3, string2);
    }

    @Override
    public void addField(Type type, int n, Type type2, String string, Object object, String string2) {
        type2 = this.resolveTypeArguments(type, null, type2);
        ASClassType aSClassType = (ASClassType)this.type;
        if (aSClassType.getField(string) == null) {
            aSClassType.newField(string, this.getVisibility(n), type2.getName());
        }
    }

    @Override
    public void addInterface(Type type) {
        if (this.type instanceof ASInterfaceType) {
            ASInterfaceType aSInterfaceType = (ASInterfaceType)this.type;
            aSInterfaceType.addSuperInterface(type.getName());
        } else {
            ASClassType aSClassType = (ASClassType)this.type;
            aSClassType.addImplementedInterface(type.getName());
        }
        this.addImport(type.getName());
    }

    @Override
    public void addParameter(Type type, Type type2, Type type3, String string) {
        type3 = this.resolveTypeArguments(type, type2, type3);
        if (this.method != null) {
            this.method.addParam(string, type3.getName());
        }
        if (this.proxyMethod != null) {
            this.proxyMethod.addParam(string, type3.getName());
        }
        this.addImport(type3.getName());
    }

    @Override
    public void beginClass(Type type) {
        this.logger.info("Creating ActionScript class {}", (Object)type);
        this.newClass(type, false);
        this.addAnnotation(GeneratorUtils.getType("RemoteClass(alias=\"" + type.getName() + "\")", this));
    }

    @Override
    public void beginEnum(Type type) {
        this.logger.info("Creating ActionScript enumeration {}", (Object)type);
        this.newClass(type, true);
    }

    @Override
    public void beginGetter(Type type, Type type2, int n, Type type3, String string, String string2, boolean bl) {
        type3 = this.resolveTypeArguments(type, type2, type3);
        if (this.type instanceof ASClassType) {
            this.addField(type, 2, type3, "_" + string, null, null);
            this.beginMethod(type, Type.EMPTY, n, type3, "get " + string, false, bl);
            this.method.addStmt("return _" + string + ";");
        } else {
            this.beginMethod(type, Type.EMPTY, n, type3, "get " + string, false, bl);
        }
        this.setMethodDescription(string2);
    }

    @Override
    public void beginInterface(Type type) {
        this.logger.info("Creating ActionScript interface {}", (Object)type);
        this.unit = this.project.newInterface(type.getName());
        this.type = this.unit.getType();
        this.imports = new TreeSet<String>();
    }

    @Override
    public void beginMethod(Type type, Type type2, int n, Type type3, String string, boolean bl, boolean bl2) {
        type3 = this.resolveTypeArguments(type, type2, type3);
        if (this.unit != null) {
            this.method = this.type.newMethod(string, this.getVisibility(n), type3.getName());
            this.method.setOverride(bl2);
        }
        if (this.proxyUnit != null) {
            String string2 = this.firstToUpper(string);
            boolean bl3 = false;
            for (Object e : this.eventType.getFields()) {
                ASField aSField = (ASField)e;
                if (!aSField.getName().equals(string2)) continue;
                bl3 = true;
                break;
            }
            if (!bl3) {
                this.createConst(this.eventType, string2, MessageFormat.format("\"{0}\"", string), "String", null);
                this.proxyMethod = this.proxyType.newMethod(string, Visibility.PUBLIC, type3.getName());
            }
        }
        this.addImport(type3.getName());
    }

    @Override
    public void beginProxy(Type type, Type type2, Type type3) {
        this.logger.info("Creating ActionScript proxy {}", (Object)type.getName());
        ASCompilationUnit aSCompilationUnit = this.project.newClass(type.getName() + "Events");
        this.proxyUnit = this.project.newClass(type.getName());
        this.eventType = (ASClassType)aSCompilationUnit.getType();
        this.proxyType = (ASClassType)this.proxyUnit.getType();
        this.proxyType.addImplementedInterface(type3.getName());
        this.proxyImports = new TreeSet<String>();
        this.proxyImports.add(type3.getName());
        if (type2 != Type.NULL) {
            this.proxyType.setSuperclass(type2.getName());
            this.proxyImports.add(type2.getName());
        }
        ASMethod aSMethod = this.proxyType.newMethod("dispatchCall", Visibility.PROTECTED, "Object");
        aSMethod.addParam("name", "String");
        aSMethod.addParam("...args", null);
        aSMethod.addStmt("throw new Error(\"Not Implemented\");");
        ASMethod aSMethod2 = this.proxyType.newMethod("onResult", Visibility.PROTECTED, Type.VOID.getName());
        aSMethod2.addParam("result", "Object");
        ASMethod aSMethod3 = this.proxyType.newMethod("onStatus", Visibility.PROTECTED, Type.VOID.getName());
        aSMethod3.addParam("status", "Object");
    }

    @Override
    public void beginSetter(Type type, Type type2, int n, Type type3, String string, String string2, boolean bl) {
        type3 = this.resolveTypeArguments(type, type2, type3);
        if (this.type instanceof ASClassType) {
            this.addField(type, 2, type3, "_" + string, null, null);
            this.beginMethod(type, Type.EMPTY, n, Type.VOID, "set " + string, false, bl);
            this.method.addParam("value", type3.getName());
            this.method.addStmt("_" + string + "=value;");
        } else {
            this.beginMethod(type, Type.EMPTY, n, Type.VOID, "set " + string, false, bl);
            this.method.addParam("value", type3.getName());
        }
        this.setMethodDescription(string2);
    }

    @Override
    public void endClass() {
        this.end();
    }

    @Override
    public void endEnum() {
        this.end();
    }

    @Override
    public void endGetter() {
        this.endMethod(Type.EMPTY);
    }

    @Override
    public void endInterface() {
        this.end();
    }

    @Override
    public void endMethod(Type type) {
        if (this.proxyMethod != null) {
            String string = this.eventType.getName() + '.' + this.firstToUpper(this.proxyMethod.getName());
            StringBuilder stringBuilder = new StringBuilder();
            for (Object e : this.proxyMethod.getArgs()) {
                ASArg aSArg = (ASArg)e;
                stringBuilder.append(", ").append(aSArg.getName());
            }
            if (Type.VOID.getQualifiedTypeName().equals(this.proxyMethod.getType())) {
                this.proxyMethod.addStmt(MessageFormat.format("{0}({1}{2});", "dispatchCall", string, stringBuilder));
            } else {
                this.proxyMethod.addStmt(MessageFormat.format("return {0}({1}{2}) as {3};", "dispatchCall", string, stringBuilder, this.proxyMethod.getType()));
            }
        }
        this.proxyMethod = null;
        this.method = null;
    }

    @Override
    public void endProxy() {
        for (String string : this.proxyImports) {
            this.proxyUnit.getPackage().addImport(string);
        }
        this.proxyImports = null;
        this.proxyUnit = null;
    }

    @Override
    public void endSetter() {
        this.endMethod(Type.EMPTY);
    }

    @Override
    public void generate() throws IOException {
        this.project.writeAll();
    }

    @Override
    public String getName() {
        return "as";
    }

    @Override
    public boolean hasEnumSupport() {
        return false;
    }

    @Override
    public Type postProcessType(Type type) {
        if (type.getDimensions() > 0) {
            return GeneratorUtils.getType(Collection.class.getCanonicalName(), this);
        }
        return type;
    }

    @Override
    public void setMethodDescription(String string) {
        if (this.unit != null && !StringUtils.isEmpty((String)string)) {
            this.method.setDescription(string.trim());
        }
    }

    @Override
    public void setSuperclass(Type type, boolean bl) {
        ((ASClassType)this.type).setSuperclass(type.getName());
        this.addImport(type.getName());
    }

    @Override
    public void setTypeDescription(String string) {
        if (!StringUtils.isEmpty((String)string)) {
            this.type.setDescription(string.trim());
        }
    }

    @Override
    public boolean traverse(ClassDoc classDoc) {
        return true;
    }

    private void createConst(ASClassType aSClassType, String string, String string2, String string3, String string4) {
        ASField aSField = aSClassType.newField(string, Visibility.PUBLIC, string3);
        aSField.setInitializer(string2);
        aSField.setStatic(true);
        aSField.setConst(true);
        if (!StringUtils.isEmpty((String)string4)) {
            aSField.setDescription(string4.trim());
        }
    }

    private void end() {
        for (String string : this.imports) {
            this.unit.getPackage().addImport(string);
        }
        this.type = null;
        this.unit = null;
        this.imports = null;
    }

    private String firstToUpper(String string) {
        return string.length() > 1 ? string.substring(0, 1).toUpperCase() + string.substring(1) : string.toUpperCase();
    }

    private Visibility getVisibility(int n) {
        switch (n) {
            case 1: {
                return Visibility.PUBLIC;
            }
            case 4: {
                return Visibility.PROTECTED;
            }
            case 2: {
                return Visibility.PRIVATE;
            }
            case 256: {
                return Visibility.INTERNAL;
            }
        }
        return Visibility.DEFAULT;
    }

    private void newClass(Type type, boolean bl) {
        this.unit = this.project.newClass(type.getName());
        this.type = this.unit.getType();
        ((ASClassType)this.type).setFinal(bl);
        this.imports = new TreeSet<String>();
    }

    private Type resolveTypeArguments(Type type, Type type2, Type type3) {
        Type type4;
        if (!type3.isGeneric()) {
            return type3;
        }
        String string = type3.getName();
        if (type2 != null && type2.getBounds() != null && type2.getBounds().containsKey(string) && (type4 = type2.getBounds().get(type3.getName())) != null) {
            string = type3.getName();
            this.addImport(string);
            return type4;
        }
        if (type != null && type.getBounds() != null && type.getBounds().containsKey(string) && (type4 = type.getBounds().get(type3.getName())) != null) {
            string = type3.getName();
            this.addImport(string);
            return type4;
        }
        return GeneratorUtils.getType(Object.class.getCanonicalName(), this);
    }

    private void addImport(String string) {
        if (string.indexOf(46) > -1) {
            if (this.unit != null) {
                this.imports.add(string);
            }
            if (this.proxyUnit != null) {
                this.proxyImports.add(string);
            }
        }
    }
}

