/*
 * Decompiled with CFR 0.152.
 */
package cc.catalysts.cdoclet;

import cc.catalysts.cdoclet.generator.AsGenerator;
import cc.catalysts.cdoclet.generator.Generator;
import cc.catalysts.cdoclet.generator.TemplateGenerator;
import cc.catalysts.cdoclet.handler.AbstractHandler;
import cc.catalysts.cdoclet.handler.ClassHandler;
import cc.catalysts.cdoclet.handler.EnumHandler;
import cc.catalysts.cdoclet.handler.Handler;
import cc.catalysts.cdoclet.handler.InterfaceHandler;
import cc.catalysts.cdoclet.handler.TagParser;
import cc.catalysts.cdoclet.map.ClassTypeMap;
import cc.catalysts.cdoclet.map.TypeMap;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.util.StatusPrinter;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.DocErrorReporter;
import com.sun.javadoc.LanguageVersion;
import com.sun.javadoc.RootDoc;
import java.net.URL;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CDoclet {
    private static final String PARAM_DESTINATION = "-d";
    private static final String PARAM_NAMESPACE = "-namespace";
    private static final String PARAM_GENERATOR = "-generator";
    private static final String PARAM_ENUM = "-enum";
    private static final String PARAM_MAP = "-map";
    private static final String PARAM_GENERIC_MAP = "-genericmap";
    private static final String PARAM_ANNOTATION_MAP = "-annotation";
    private static final String PARAM_ANNOTATION_TYPE_MAP = "-annotationmap";
    private static final Logger logger = LoggerFactory.getLogger(CDoclet.class);

    public static boolean start(RootDoc rootDoc) throws Exception {
        Generator generator = CDoclet.readOptions(rootDoc.options());
        ClassDoc[] classDocArray = rootDoc.specifiedClasses();
        if (classDocArray.length == 0) {
            classDocArray = rootDoc.classes();
        }
        for (ClassDoc classDoc : classDocArray) {
            logger.info("Processing {}", (Object)classDoc.qualifiedName());
            if (!TagParser.hasClassTags(generator, classDoc)) continue;
            Handler handler = CDoclet.createHandler(generator, classDoc);
            handler.process(classDoc);
        }
        generator.generate();
        return true;
    }

    private static Generator readOptions(String[][] stringArray) throws Exception {
        String string = ".";
        String string2 = null;
        String string3 = null;
        Class<?> clazz = null;
        ClassTypeMap classTypeMap = new ClassTypeMap();
        TypeMap typeMap = new TypeMap();
        TypeMap typeMap2 = new TypeMap();
        for (String[] stringArray2 : stringArray) {
            String[] stringArray3;
            if (stringArray2[0].equals(PARAM_DESTINATION)) {
                string = stringArray2[1];
                continue;
            }
            if (stringArray2[0].equals(PARAM_NAMESPACE)) {
                string2 = stringArray2[1];
                continue;
            }
            if (stringArray2[0].equals(PARAM_GENERATOR)) {
                string3 = stringArray2[1];
                continue;
            }
            if (stringArray2[0].equals(PARAM_ENUM)) {
                clazz = Class.forName(stringArray2[1]);
                continue;
            }
            if (stringArray2[0].equals(PARAM_MAP)) {
                stringArray3 = stringArray2[1].split(":");
                if (stringArray3.length != 2) continue;
                classTypeMap.addTypeMapping(stringArray3[0], stringArray3[1]);
                continue;
            }
            if (stringArray2[0].equals(PARAM_GENERIC_MAP)) {
                stringArray3 = stringArray2[1].split(":");
                if (stringArray3.length != 2) continue;
                classTypeMap.addGenericTypeMapping(stringArray3[0], stringArray3[1]);
                continue;
            }
            if (stringArray2[0].equals(PARAM_ANNOTATION_MAP)) {
                stringArray3 = stringArray2[1].split(":");
                if (stringArray3.length != 2) continue;
                typeMap.addTypeMapping(stringArray3[0], stringArray3[1]);
                continue;
            }
            if (!stringArray2[0].equals(PARAM_ANNOTATION_TYPE_MAP) || (stringArray3 = stringArray2[1].split(":")).length != 2) continue;
            typeMap2.addTypeMapping(stringArray3[0], stringArray3[1]);
        }
        if ("as".equals(string3)) {
            return new AsGenerator(string, string2, clazz, classTypeMap, typeMap2, typeMap);
        }
        if ("cs".equals(string3) || "java".equals(string3)) {
            return new TemplateGenerator(string, string2, string3, clazz, classTypeMap, typeMap2, typeMap);
        }
        return null;
    }

    private static Handler createHandler(Generator generator, ClassDoc classDoc) {
        AbstractHandler abstractHandler = classDoc.isInterface() ? new InterfaceHandler(generator) : (classDoc.isEnum() ? new EnumHandler(generator) : new ClassHandler(generator));
        return abstractHandler;
    }

    public static int optionLength(String string) {
        int n = 0;
        if (Arrays.asList(PARAM_DESTINATION, PARAM_NAMESPACE, PARAM_GENERATOR, PARAM_ENUM, PARAM_MAP, PARAM_GENERIC_MAP, PARAM_ANNOTATION_MAP, PARAM_ANNOTATION_TYPE_MAP).contains(string)) {
            n = 2;
        }
        return n;
    }

    public static boolean validOptions(String[][] stringArray, DocErrorReporter docErrorReporter) {
        return true;
    }

    public static LanguageVersion languageVersion() {
        return LanguageVersion.JAVA_1_5;
    }

    private CDoclet() {
    }

    static {
        try {
            URL uRL = CDoclet.class.getResource("logback-test.xml");
            if (uRL == null) {
                uRL = CDoclet.class.getResource("logback.xml");
            }
            LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
            loggerContext.reset();
            JoranConfigurator joranConfigurator = new JoranConfigurator();
            joranConfigurator.setContext((Context)loggerContext);
            joranConfigurator.doConfigure(uRL);
            StatusPrinter.printInCaseOfErrorsOrWarnings((Context)loggerContext);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

