/*
 * Decompiled with CFR 0.152.
 */
package cc.catalysts.cdoclet.handler;

import cc.catalysts.cdoclet.generator.Generator;
import cc.catalysts.cdoclet.generator.utils.GeneratorUtils;
import cc.catalysts.cdoclet.handler.AbstractHandler;
import cc.catalysts.cdoclet.handler.TagParser;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.Parameter;
import com.sun.javadoc.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class InterfaceHandler
extends AbstractHandler {
    public InterfaceHandler(Generator generator) {
        super(generator);
    }

    @Override
    public void process(ClassDoc classDoc) {
        Object object;
        Map<String, String> map = TagParser.processClassTags(this.getGenerator(), classDoc);
        boolean bl = TagParser.getBooleanCommand("proxy", map);
        if (bl) {
            object = GeneratorUtils.getType((Type)classDoc, this.getGenerator(), new HashSet<String>());
            String string = TagParser.getStringCommand("proxy.name", object + "Proxy", map);
            String string2 = TagParser.getStringCommand("proxy.superclass", map);
            cc.catalysts.cdoclet.generator.Type type = GeneratorUtils.getType(string, this.getGenerator());
            cc.catalysts.cdoclet.generator.Type type2 = GeneratorUtils.getType(string2, this.getGenerator());
            this.getGenerator().beginProxy(type, type2, (cc.catalysts.cdoclet.generator.Type)object);
        }
        this.processInterfaceInternal(classDoc, map);
        if (bl) {
            object = this.getIgnore(map);
            this.traverseInterfaces(classDoc, (Set<String>)object, map);
            this.getGenerator().endProxy();
        }
    }

    private void processInterfaceInternal(ClassDoc classDoc, Map<String, String> map) {
        boolean bl = TagParser.getBooleanCommand("bean", map);
        Set<String> set = this.getIgnore(map);
        cc.catalysts.cdoclet.generator.Type type = GeneratorUtils.getType((Type)classDoc, this.getGenerator(), set);
        this.getGenerator().beginInterface(type);
        this.processAnnotations(classDoc.annotations());
        this.processAnnotationCommands(map);
        this.processInterfaces(classDoc, set);
        this.processClassComment(classDoc);
        this.processMethods(classDoc, type, bl, set, map, null);
        this.getGenerator().endInterface();
    }

    private void processMethods(ClassDoc classDoc, cc.catalysts.cdoclet.generator.Type type, boolean bl, Set<String> set, Map<String, String> map, Map<String, cc.catalysts.cdoclet.generator.Type> map2) {
        for (MethodDoc methodDoc : classDoc.methods()) {
            boolean bl2;
            boolean bl3 = (methodDoc.name().startsWith("get") || methodDoc.name().startsWith("is")) && methodDoc.parameters().length == 0;
            boolean bl4 = bl2 = methodDoc.name().startsWith("set") && methodDoc.parameters().length == 1;
            if (bl && (bl3 || bl2)) {
                this.processBeanProperty(classDoc, type, methodDoc, set, map);
                continue;
            }
            this.processMethod(classDoc, type, methodDoc, set, map, map2);
        }
    }

    private void processMethod(ClassDoc classDoc, cc.catalysts.cdoclet.generator.Type type, MethodDoc methodDoc, Set<String> set, Map<String, String> map, Map<String, cc.catalysts.cdoclet.generator.Type> map2) {
        HashMap<String, String> hashMap = new HashMap<String, String>(map);
        HashMap<String, String> hashMap2 = new HashMap<String, String>();
        cc.catalysts.cdoclet.generator.Type type2 = GeneratorUtils.getType(methodDoc.returnType(), this.getGenerator(), set);
        cc.catalysts.cdoclet.generator.Type type3 = GeneratorUtils.getType(methodDoc, this.getGenerator(), set);
        if (map2 != null) {
            if (map2.containsKey(type2.getName())) {
                type2 = map2.get(type2.getName());
            }
            if (map2.containsKey(type3.getName())) {
                type3 = map2.get(type3.getName());
            }
        }
        type2.setTypeMap(map2);
        cc.catalysts.cdoclet.generator.Type type4 = type2;
        TagParser.processTags(methodDoc.tags(this.getGenerator().getName() + ".method"), hashMap2);
        hashMap.putAll(hashMap2);
        if (!TagParser.getBooleanCommand("ignore", hashMap)) {
            String string;
            cc.catalysts.cdoclet.generator.Type type5 = cc.catalysts.cdoclet.generator.Type.EMPTY;
            boolean bl = TagParser.getBooleanCommand("async", hashMap);
            if (bl) {
                String string2 = TagParser.getStringCommand("async.returntype", hashMap);
                string = TagParser.getStringCommand("async.callbacktype", hashMap);
                if (string != null) {
                    if (string.endsWith("<$type$>")) {
                        ArrayList<cc.catalysts.cdoclet.generator.Type> arrayList = new ArrayList<cc.catalysts.cdoclet.generator.Type>();
                        if (!cc.catalysts.cdoclet.generator.Type.VOID.getQualifiedTypeName().equals(type2.getQualifiedTypeName())) {
                            arrayList.add(type2);
                        }
                        type5 = new cc.catalysts.cdoclet.generator.Type(string.substring(0, string.length() - 8), arrayList, null, 0, false);
                    } else {
                        type5 = new cc.catalysts.cdoclet.generator.Type(string, null, null, 0, false);
                    }
                    type5.setTypeMap(map2);
                }
                type4 = string2 != null ? GeneratorUtils.getType(string2, this.getGenerator()) : cc.catalysts.cdoclet.generator.Type.VOID;
            }
            boolean bl2 = type5 != cc.catalysts.cdoclet.generator.Type.EMPTY;
            string = methodDoc.name();
            boolean bl3 = this.isOverridden(classDoc, string, set);
            this.getGenerator().beginMethod(type, type3, 0, type4, string, bl2, bl3);
            this.processAnnotations(methodDoc.annotations());
            this.processAnnotationCommands(hashMap2);
            if (bl2) {
                this.getGenerator().addParameter(type, type3, type5, "async");
            }
            for (Parameter parameter : methodDoc.parameters()) {
                cc.catalysts.cdoclet.generator.Type type6 = GeneratorUtils.getType(parameter.type(), this.getGenerator(), set);
                type6.setTypeMap(map2);
                this.getGenerator().addParameter(type, type3, type6, parameter.name());
            }
            this.processMethodComment(methodDoc);
            this.getGenerator().endMethod(type2);
        }
    }

    private void processMethodComment(MethodDoc methodDoc) {
        StringBuilder stringBuilder = new StringBuilder();
        String string = methodDoc.commentText();
        if (string != null) {
            stringBuilder.append(string.trim());
        }
        this.getGenerator().setMethodDescription(stringBuilder.toString());
    }

    private void traverseInterfaces(ClassDoc classDoc, Set<String> set, Map<String, String> map) {
        for (Type type : classDoc.interfaceTypes()) {
            cc.catalysts.cdoclet.generator.Type type2;
            ClassDoc classDoc2 = type.asClassDoc();
            if (!this.getGenerator().traverse(classDoc2) || (type2 = GeneratorUtils.getType(type, this.getGenerator(), set)) == cc.catalysts.cdoclet.generator.Type.NULL) continue;
            HashMap<String, String> hashMap = new HashMap<String, String>(map);
            hashMap.putAll(TagParser.processClassTags(this.getGenerator(), classDoc2));
            set = this.getIgnore(hashMap);
            cc.catalysts.cdoclet.generator.Type type3 = GeneratorUtils.getType((Type)classDoc2, this.getGenerator(), set);
            HashMap<String, cc.catalysts.cdoclet.generator.Type> hashMap2 = null;
            if (type3.getArguments() != null && type2.getArguments() != null) {
                hashMap2 = new HashMap<String, cc.catalysts.cdoclet.generator.Type>();
                Iterator<cc.catalysts.cdoclet.generator.Type> iterator = type3.getArguments().iterator();
                Iterator<cc.catalysts.cdoclet.generator.Type> iterator2 = type2.getArguments().iterator();
                while (iterator.hasNext() && iterator2.hasNext()) {
                    hashMap2.put(iterator.next().getName(), iterator2.next());
                }
            }
            boolean bl = TagParser.getBooleanCommand("bean", hashMap);
            this.processMethods(classDoc2, type3, bl, set, hashMap, hashMap2);
            this.traverseInterfaces(classDoc2, set, hashMap);
        }
    }
}

