/*
 * Decompiled with CFR 0.152.
 */
package cc.catalysts.cdoclet.generator.utils;

import cc.catalysts.cdoclet.generator.Generator;
import cc.catalysts.cdoclet.generator.Type;
import cc.catalysts.cdoclet.map.TypeMap;
import com.sun.javadoc.AnnotationDesc;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.ParameterizedType;
import com.sun.javadoc.TypeVariable;
import com.sun.javadoc.WildcardType;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GeneratorUtils {
    private static final Logger logger = LoggerFactory.getLogger(GeneratorUtils.class);
    private static Map<String, Type> enumerationTypes = new HashMap<String, Type>();

    public static Type getType(MethodDoc methodDoc, Generator generator, Collection<String> collection) {
        logger.debug("Generating type {} <{}>", (Object)methodDoc.name(), (Object)methodDoc.getClass().getCanonicalName());
        HashMap<String, Type> hashMap = new HashMap<String, Type>();
        ArrayList<Type> arrayList = new ArrayList<Type>();
        logger.debug("Parameters {}", (Object)Arrays.toString(methodDoc.typeParameters()));
        for (TypeVariable typeVariable : methodDoc.typeParameters()) {
            GeneratorUtils.processArgument((com.sun.javadoc.Type)typeVariable, generator, arrayList, hashMap, collection, new HashSet<String>());
        }
        String string = generator.getTypeMap().getType(methodDoc.name(), !arrayList.isEmpty(), false);
        if ("null".equals(string)) {
            return Type.NULL;
        }
        return generator.postProcessType(new Type(string, arrayList, hashMap, 0, true));
    }

    private static void processArgument(com.sun.javadoc.Type type, Generator generator, Collection<Type> collection, Map<String, Type> map, Collection<String> collection2, Collection<String> collection3) {
        logger.debug("Processing argument {} <{}>", (Object)type.qualifiedTypeName(), (Object)type.getClass().getCanonicalName());
        Type type2 = GeneratorUtils.getType(type, generator, collection2, collection3);
        if (type2 != Type.NULL) {
            GeneratorUtils.getTypeBounds(type, generator, map, collection2, collection3);
            if (collection != null) {
                collection.add(type2);
            }
        }
    }

    private static Type getType(com.sun.javadoc.Type type, Generator generator, Collection<String> collection, Collection<String> collection2) {
        Object object;
        logger.debug("Generating type {} <{}>", (Object)type.qualifiedTypeName(), (Object)type.getClass().getCanonicalName());
        if (collection.contains(type.qualifiedTypeName())) {
            return Type.NULL;
        }
        if (collection2.contains(type.toString())) {
            return GeneratorUtils.getType(type.qualifiedTypeName(), generator);
        }
        collection2.add(type.toString());
        Type type2 = GeneratorUtils.getEnumerationType(type, generator);
        if (type2 != Type.EMPTY) {
            return type2;
        }
        HashMap<String, Type> hashMap = new HashMap<String, Type>();
        ArrayList<Type> arrayList = new ArrayList<Type>();
        if (type instanceof ParameterizedType) {
            object = type.asParameterizedType();
            logger.debug("Arguments {}", (Object)Arrays.toString(object.typeArguments()));
            for (com.sun.javadoc.Type type3 : object.typeArguments()) {
                GeneratorUtils.processArgument(type3, generator, arrayList, hashMap, collection, collection2);
            }
        } else if (type instanceof ClassDoc) {
            object = type.asClassDoc();
            logger.debug("Parameters {}", (Object)Arrays.toString(object.typeParameters()));
            for (TypeVariable typeVariable : object.typeParameters()) {
                GeneratorUtils.processArgument((com.sun.javadoc.Type)typeVariable, generator, arrayList, hashMap, collection, collection2);
            }
        }
        if ("null".equals(object = generator.getTypeMap().getType(type.qualifiedTypeName(), !arrayList.isEmpty(), GeneratorUtils.isEnum(type)))) {
            return Type.NULL;
        }
        if (((String)object).endsWith("<>")) {
            arrayList.clear();
            hashMap.clear();
            object = ((String)object).substring(0, ((String)object).length() - 2);
        }
        return generator.postProcessType(new Type((String)object, arrayList, hashMap, GeneratorUtils.getDimensions(type), type instanceof TypeVariable));
    }

    private static Type getEnumerationType(com.sun.javadoc.Type type, Generator generator) {
        Class<? extends Annotation> clazz = generator.getEnumAnnotation();
        ClassDoc classDoc = type.asClassDoc();
        String string = type.qualifiedTypeName();
        if (generator.hasEnumSupport()) {
            return Type.EMPTY;
        }
        if (enumerationTypes.containsKey(string)) {
            return enumerationTypes.get(string);
        }
        if (classDoc != null && clazz != null) {
            for (MethodDoc methodDoc : classDoc.methods()) {
                for (AnnotationDesc annotationDesc : methodDoc.annotations()) {
                    if (!annotationDesc.annotationType().qualifiedTypeName().equals(clazz.getCanonicalName())) continue;
                    Type type2 = GeneratorUtils.getType(methodDoc.returnType(), generator, new HashSet<String>());
                    enumerationTypes.put(string, type2);
                    return type2;
                }
            }
            enumerationTypes.put(string, Type.EMPTY);
        }
        return Type.EMPTY;
    }

    public static Type getType(com.sun.javadoc.Type type, Generator generator, Collection<String> collection) {
        return GeneratorUtils.getType(type, generator, collection, new HashSet<String>());
    }

    public static boolean isEnum(com.sun.javadoc.Type type) {
        return type.asClassDoc() != null && type.asClassDoc().isEnum();
    }

    public static int getDimensions(com.sun.javadoc.Type type) {
        return type.dimension().length() / 2;
    }

    private static void getTypeBounds(com.sun.javadoc.Type type, Generator generator, Map<String, Type> map, Collection<String> collection, Collection<String> collection2) {
        com.sun.javadoc.Type[] typeArray = null;
        if (type instanceof TypeVariable) {
            typeArray = type.asTypeVariable().bounds();
        } else if (type instanceof WildcardType) {
            typeArray = type.asWildcardType().extendsBounds();
            map.put("?", GeneratorUtils.getType(Object.class.getCanonicalName(), generator, generator.getTypeMap()));
        }
        if (typeArray != null) {
            Type type2;
            com.sun.javadoc.Type type3;
            com.sun.javadoc.Type type4 = type3 = typeArray.length > 0 ? typeArray[0] : null;
            if (type3 != null && (type2 = GeneratorUtils.getType(type3, generator, collection, collection2)) != Type.NULL) {
                logger.debug("Adding boundary {} extends {} <{}>", new Object[]{type.qualifiedTypeName(), type3.qualifiedTypeName(), type3.getClass().getCanonicalName()});
                map.put(type.qualifiedTypeName(), type2);
            }
        }
    }

    private static Type getType(String string, Generator generator, TypeMap typeMap) {
        String string2 = typeMap.getType(string, false, false);
        if (string2 == null) {
            return null;
        }
        if ("null".equals(string2)) {
            return Type.NULL;
        }
        return generator.postProcessType(new Type(string2, null, null, 0, false));
    }

    public static Type getType(String string, Generator generator) {
        if (string == null) {
            return Type.NULL;
        }
        return GeneratorUtils.getType(string, generator, generator.getTypeMap());
    }

    public static Type getAnnotationType(String string, Generator generator) {
        return GeneratorUtils.getType(string, generator, generator.getAnnotationTypeMap());
    }

    public static Type getAnnotation(String string, Generator generator) {
        return GeneratorUtils.getType(string, generator, generator.getAnnotationMap());
    }
}

