/*
 * Decompiled with CFR 0.152.
 */
package cc.catalysts.boot.thymeleaf.webjars;

import cc.catalysts.boot.thymeleaf.webjars.WebjarRegistrar;
import cc.catalysts.boot.thymeleaf.webjars.processor.WebjarsLinkProcessor;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.thymeleaf.context.IProcessingContext;
import org.thymeleaf.dialect.AbstractDialect;
import org.thymeleaf.dialect.IExpressionEnhancingDialect;
import org.thymeleaf.processor.IProcessor;

public class WebjarsDialect
extends AbstractDialect
implements IExpressionEnhancingDialect {
    private final Collection<WebjarRegistrar> webjarRegistrars;

    public WebjarsDialect(Collection<WebjarRegistrar> webjarRegistrars) {
        this.webjarRegistrars = webjarRegistrars;
    }

    public Set<IProcessor> getProcessors() {
        HashSet<WebjarsLinkProcessor> processors = new HashSet<WebjarsLinkProcessor>();
        processors.add(new WebjarsLinkProcessor("src"));
        processors.add(new WebjarsLinkProcessor("href"));
        return Collections.unmodifiableSet(processors);
    }

    public Map<String, Object> getAdditionalExpressionObjects(IProcessingContext processingContext) {
        HashMap webjars = new HashMap();
        for (WebjarRegistrar webjarRegistrar : this.webjarRegistrars) {
            webjars.putAll(webjarRegistrar.getWebjarMap());
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("webjars", webjars);
        return map;
    }

    public String getPrefix() {
        return "webjars";
    }
}

