/*
 * Decompiled with CFR 0.152.
 */
package cc.catalysts.boot.report.pdf.impl;

import cc.catalysts.boot.report.pdf.config.PdfStyleSheet;
import cc.catalysts.boot.report.pdf.elements.ReportElement;
import cc.catalysts.boot.report.pdf.elements.ReportElementStatic;
import cc.catalysts.boot.report.pdf.elements.ReportPage;
import cc.catalysts.boot.report.pdf.elements.ReportTable;
import cc.catalysts.boot.report.pdf.elements.ReportTextBox;
import cc.catalysts.boot.report.pdf.utils.PositionOfStaticElements;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class PdfReportStructure {
    private final PdfStyleSheet configuration;
    private List<ReportElement> elements = new ArrayList<ReportElement>();
    private List<ReportElementStatic> staticElements = new ArrayList<ReportElementStatic>();
    private List<ReportElementStatic> staticElementsForEachPage = new ArrayList<ReportElementStatic>();

    public PdfReportStructure(PdfStyleSheet configuration) {
        this.configuration = configuration;
    }

    public PdfStyleSheet getConfiguration() {
        return this.configuration;
    }

    public void addElement(ReportElement elem) {
        this.elements.add(elem);
    }

    public List<ReportElement> getElements() {
        return this.elements;
    }

    public void addPage(ReportPage page) {
        for (ReportElement element : page.getPageElements()) {
            this.addElement(element);
        }
    }

    public void addStaticElement(ReportElementStatic elem) {
        this.staticElements.add(elem);
    }

    public List<ReportElementStatic> getStaticElements() {
        return this.staticElements;
    }

    public void addStaticElementsForEachPage(ReportElementStatic ... elements) {
        this.staticElementsForEachPage.addAll(Arrays.asList(elements));
    }

    public void expandPagesStaticElements(int totalPages) {
        for (int i = this.staticElementsForEachPage.size() - 1; i >= 0; --i) {
            ReportElementStatic elem = this.staticElementsForEachPage.get(i);
            for (int pageNo = 0; pageNo < totalPages; ++pageNo) {
                PositionOfStaticElements config = elem.getPosition();
                if (pageNo == 0 && config == PositionOfStaticElements.ON_ALL_PAGES_BUT_FIRST || pageNo == totalPages - 1 && config == PositionOfStaticElements.ON_ALL_PAGES_BUT_LAST) continue;
                this.addStaticElement(new ReportElementStatic(this.getFooterElementWithPagesSet(elem.getBase(), pageNo, totalPages), pageNo, elem.getX(), elem.getY(), elem.getWidth(), elem.getPosition()));
            }
        }
    }

    public ReportElement getFooterElementWithPagesSet(ReportElement baseElement, int pageNo, int totalPages) {
        if (baseElement instanceof ReportTextBox) {
            ReportTextBox oldFooterTextBox = (ReportTextBox)baseElement;
            String newText = oldFooterTextBox.getText().replaceAll("%PAGE_NUMBER%", pageNo + 1 + "").replaceAll("%TOTAL_PAGES%", totalPages + "");
            return oldFooterTextBox.clone(newText);
        }
        if (baseElement instanceof ReportTable) {
            ReportTable baseTable = (ReportTable)baseElement;
            ReportElement[][] oldElements = baseTable.getElements();
            ReportElement[][] newElements = new ReportElement[oldElements.length][];
            for (int row = oldElements.length - 1; row >= 0; --row) {
                newElements[row] = new ReportElement[oldElements[row].length];
                for (int col = oldElements[row].length - 1; col >= 0; --col) {
                    newElements[row][col] = this.getFooterElementWithPagesSet(oldElements[row][col], pageNo, totalPages);
                }
            }
            return new ReportTable(baseTable.getPdfStyleSheet(), baseTable.getCellWidths(), newElements, baseTable.getTitle());
        }
        return baseElement;
    }
}

