/*
 * Decompiled with CFR 0.152.
 */
package cc.catalysts.boot.report.pdf.impl;

import cc.catalysts.boot.report.pdf.PdfReport;
import cc.catalysts.boot.report.pdf.PdfReportBuilder;
import cc.catalysts.boot.report.pdf.ReportTableBuilder;
import cc.catalysts.boot.report.pdf.config.DefaultPdfStyleSheet;
import cc.catalysts.boot.report.pdf.config.PdfPageLayout;
import cc.catalysts.boot.report.pdf.config.PdfStyleSheet;
import cc.catalysts.boot.report.pdf.config.PdfTextStyle;
import cc.catalysts.boot.report.pdf.elements.ReportElement;
import cc.catalysts.boot.report.pdf.elements.ReportElementStatic;
import cc.catalysts.boot.report.pdf.elements.ReportImage;
import cc.catalysts.boot.report.pdf.elements.ReportPadding;
import cc.catalysts.boot.report.pdf.elements.ReportPageBreak;
import cc.catalysts.boot.report.pdf.elements.ReportTable;
import cc.catalysts.boot.report.pdf.elements.ReportTextBox;
import cc.catalysts.boot.report.pdf.impl.AbstractFixedLineGenerator;
import cc.catalysts.boot.report.pdf.impl.PdfFooterGenerator;
import cc.catalysts.boot.report.pdf.impl.PdfHeaderGenerator;
import cc.catalysts.boot.report.pdf.impl.PdfReportGenerator;
import cc.catalysts.boot.report.pdf.impl.PdfReportStructure;
import cc.catalysts.boot.report.pdf.impl.ReportTableBuilderImpl;
import cc.catalysts.boot.report.pdf.utils.PositionOfStaticElements;
import cc.catalysts.boot.report.pdf.utils.ReportAlignType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.springframework.core.io.Resource;

class PdfReportBuilderImpl
implements PdfReportBuilder {
    private final PdfStyleSheet configuration;
    private List<ReportElement> elements = new ArrayList<ReportElement>();
    private List<AbstractFixedLineGenerator> fixedLineGenerators = new ArrayList<AbstractFixedLineGenerator>();

    public PdfReportBuilderImpl(PdfStyleSheet configuration) {
        this.configuration = configuration;
    }

    @Override
    public PdfReportBuilderImpl addElement(ReportElement element) {
        this.elements.add(element);
        return this;
    }

    @Override
    public PdfReportBuilder withHeaderOnAllPages(String left, String middle, String right) {
        DefaultPdfStyleSheet HeaderTableConfiguration = new DefaultPdfStyleSheet();
        HeaderTableConfiguration.setTableTitleText(this.configuration.getFooterText());
        ReportTable headerTable = new ReportTableBuilderImpl(HeaderTableConfiguration, this).addColumn(left, 1.0f).addColumn(middle, 1.0f).addColumn(right, 1.0f).build();
        headerTable.setTextAlignInColumn(0, ReportAlignType.LEFT, false);
        headerTable.setTextAlignInColumn(1, ReportAlignType.CENTER, false);
        headerTable.setTextAlignInColumn(2, ReportAlignType.RIGHT, false);
        headerTable.setBorder(false);
        this.fixedLineGenerators.add(new PdfHeaderGenerator(headerTable, PositionOfStaticElements.ON_ALL_PAGES));
        return this;
    }

    @Override
    public PdfReportBuilder withHeaderOnAllPages(ReportElement headerElement) {
        this.fixedLineGenerators.add(new PdfHeaderGenerator(headerElement, PositionOfStaticElements.ON_ALL_PAGES));
        return this;
    }

    @Override
    public PdfReportBuilder withHeaderOnPages(String left, String middle, String right, PositionOfStaticElements headerPosition) {
        DefaultPdfStyleSheet HeaderTableConfiguration = new DefaultPdfStyleSheet();
        HeaderTableConfiguration.setTableTitleText(this.configuration.getFooterText());
        ReportTable headerTable = new ReportTableBuilderImpl(HeaderTableConfiguration, this).addColumn(left, 1.0f).addColumn(middle, 1.0f).addColumn(right, 1.0f).build();
        headerTable.setTextAlignInColumn(0, ReportAlignType.LEFT, false);
        headerTable.setTextAlignInColumn(1, ReportAlignType.CENTER, false);
        headerTable.setTextAlignInColumn(2, ReportAlignType.RIGHT, false);
        headerTable.setBorder(false);
        this.fixedLineGenerators.add(new PdfHeaderGenerator(headerTable, headerPosition));
        return this;
    }

    @Override
    public PdfReportBuilder withHeaderOnPages(ReportElement headerElement, PositionOfStaticElements headerPosition) {
        this.fixedLineGenerators.add(new PdfHeaderGenerator(headerElement, headerPosition));
        return this;
    }

    @Override
    public PdfReportBuilder withFooterOnAllPages(String left, String middle, String right) {
        DefaultPdfStyleSheet footerTableConfiguration = new DefaultPdfStyleSheet();
        footerTableConfiguration.setTableTitleText(this.configuration.getFooterText());
        ReportTable footerTable = new ReportTableBuilderImpl(footerTableConfiguration, this).addColumn(left, 1.0f).addColumn(middle, 1.0f).addColumn(right, 1.0f).build();
        footerTable.setTextAlignInColumn(0, ReportAlignType.LEFT, false);
        footerTable.setTextAlignInColumn(1, ReportAlignType.CENTER, false);
        footerTable.setTextAlignInColumn(2, ReportAlignType.RIGHT, false);
        footerTable.setBorder(false);
        this.fixedLineGenerators.add(new PdfFooterGenerator(footerTable, PositionOfStaticElements.ON_ALL_PAGES));
        return this;
    }

    @Override
    public PdfReportBuilder withFooterOnAllPages(ReportElement footerElement) {
        this.fixedLineGenerators.add(new PdfFooterGenerator(footerElement, PositionOfStaticElements.ON_ALL_PAGES));
        return this;
    }

    @Override
    public PdfReportBuilder withFooterOnPages(String left, String middle, String right, PositionOfStaticElements footerPosition) {
        DefaultPdfStyleSheet footerTableConfiguration = new DefaultPdfStyleSheet();
        footerTableConfiguration.setTableTitleText(this.configuration.getFooterText());
        ReportTable footerTable = new ReportTableBuilderImpl(footerTableConfiguration, this).addColumn(left, 1.0f).addColumn(middle, 1.0f).addColumn(right, 1.0f).build();
        footerTable.setTextAlignInColumn(0, ReportAlignType.LEFT, false);
        footerTable.setTextAlignInColumn(1, ReportAlignType.CENTER, false);
        footerTable.setTextAlignInColumn(2, ReportAlignType.RIGHT, false);
        footerTable.setBorder(false);
        this.fixedLineGenerators.add(new PdfFooterGenerator(footerTable, footerPosition));
        return this;
    }

    @Override
    public PdfReportBuilder withFooterOnPages(ReportElement footerElement, PositionOfStaticElements footerPosition) {
        this.fixedLineGenerators.add(new PdfFooterGenerator(footerElement, footerPosition));
        return this;
    }

    @Override
    public PdfReportBuilder addPadding(float padding) {
        this.elements.add(new ReportPadding(padding));
        return this;
    }

    @Override
    public ReportTableBuilder startTable() {
        return new ReportTableBuilderImpl(this.configuration, this);
    }

    public PdfReportStructure buildReport(PdfPageLayout pageConfig) {
        PdfReportStructure report = new PdfReportStructure(this.configuration);
        for (ReportElement element : this.elements) {
            if (element instanceof ReportElementStatic) {
                report.addStaticElement((ReportElementStatic)element);
                continue;
            }
            report.addElement(element);
        }
        for (AbstractFixedLineGenerator generator : this.fixedLineGenerators) {
            generator.addFooterToAllPages(report, pageConfig);
            if (generator instanceof PdfFooterGenerator) {
                pageConfig.setFooterPosition(generator.getFooterOnPages());
                pageConfig.setFooter(generator.getFooterElement().getHeight(pageConfig.getUsableWidth()) + this.configuration.getLineDistance());
                continue;
            }
            pageConfig.setHeaderPosition(generator.getFooterOnPages());
            pageConfig.setHeader(generator.getFooterElement().getHeight(pageConfig.getUsableWidth()) + this.configuration.getLineDistance());
        }
        return report;
    }

    @Override
    public PdfReport buildReport(String fileName, PdfPageLayout pageConfig, Resource templateResource) throws IOException {
        return this.buildReport(fileName, pageConfig, templateResource, new PDDocument());
    }

    @Override
    public PdfReport buildReport(String fileName, PdfPageLayout pageConfig, Resource templateResource, PDDocument document) throws IOException {
        PdfReportStructure report = this.buildReport(pageConfig);
        document = new PdfReportGenerator().generate(pageConfig, templateResource, report, document);
        return new PdfReport(fileName, document);
    }

    @Override
    public PdfReportBuilder addImage(Resource resource, float width, float height) throws IOException {
        return this.addElement(new ReportImage(ImageIO.read(resource.getFile()), width, height));
    }

    @Override
    public PdfReportBuilder beginNewSection(String title, boolean startNewPage) {
        if (startNewPage && !this.elements.isEmpty()) {
            this.elements.add(new ReportPageBreak());
        }
        this.addElement(new ReportPadding(this.configuration.getSectionPadding()));
        this.addHeading(title);
        return this;
    }

    @Override
    public PdfReportBuilderImpl addHeading(String heading) {
        this.addElement(new ReportTextBox(this.configuration.getHeading1Text(), this.configuration.getLineDistance(), heading));
        this.addPadding(this.configuration.getHeadingPaddingAfter());
        return this;
    }

    @Override
    public PdfReportBuilderImpl addText(String text, PdfTextStyle textConfig) {
        this.addElement(new ReportTextBox(textConfig, this.configuration.getLineDistance(), text));
        return this;
    }

    @Override
    public PdfReportBuilderImpl addText(String text) {
        this.addElement(new ReportTextBox(this.configuration.getBodyText(), this.configuration.getLineDistance(), text));
        return this;
    }

    public List<ReportElement> getElements() {
        return this.elements;
    }
}

