/*
 * Decompiled with CFR 0.152.
 */
package cc.catalysts.boot.report.pdf.impl;

import cc.catalysts.boot.report.pdf.config.PdfPageLayout;
import cc.catalysts.boot.report.pdf.elements.ReportElement;
import cc.catalysts.boot.report.pdf.elements.ReportElementStatic;
import cc.catalysts.boot.report.pdf.impl.PdfReportStructure;
import cc.catalysts.boot.report.pdf.utils.PositionOfStaticElements;

public abstract class AbstractFixedLineGenerator {
    private PositionOfStaticElements footerOnPages;
    private ReportElement footerElement;
    public static final String PAGE_TEMPLATE_CURR = "%PAGE_NUMBER%";
    public static final String PAGE_TEMPLATE_TOTAL = "%TOTAL_PAGES%";

    public AbstractFixedLineGenerator(ReportElement footerElement, PositionOfStaticElements footerOnPages) {
        this.footerElement = footerElement;
        this.footerOnPages = footerOnPages;
    }

    public void addFooterToAllPages(PdfReportStructure report, PdfPageLayout pageConfig) {
        float x = pageConfig.getStartX();
        float y = this.getVerticalPosition(pageConfig);
        float w = pageConfig.getUsableWidth();
        report.addStaticElementsForEachPage(new ReportElementStatic(this.footerElement, 0, x, y, w, this.footerOnPages));
    }

    protected abstract float getVerticalPosition(PdfPageLayout var1);

    public PositionOfStaticElements getFooterOnPages() {
        return this.footerOnPages;
    }

    public ReportElement getFooterElement() {
        return this.footerElement;
    }
}

