/*
 * Decompiled with CFR 0.152.
 */
package cc.catalysts.boot.report.pdf.elements;

import cc.catalysts.boot.report.pdf.config.PdfTextStyle;
import cc.catalysts.boot.report.pdf.elements.PdfBoxHelper;
import cc.catalysts.boot.report.pdf.elements.ReportElement;
import cc.catalysts.boot.report.pdf.elements.ReportImage;
import cc.catalysts.boot.report.pdf.utils.ReportAlignType;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.edit.PDPageContentStream;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.springframework.util.StringUtils;

public class ReportTextBox
implements ReportElement {
    protected PdfTextStyle textConfig;
    protected String text;
    protected final float lineDistance;
    protected ReportAlignType align = ReportAlignType.LEFT;
    protected Map<CacheKey, String[]> cache = new HashMap<CacheKey, String[]>();

    public ReportTextBox(PdfTextStyle textConfig, float lineDistance, String text) {
        this.textConfig = textConfig;
        this.text = text == null ? "" : text;
        this.lineDistance = lineDistance;
    }

    public ReportTextBox(ReportTextBox object, String text) {
        this.text = text;
        this.textConfig = object.textConfig;
        this.lineDistance = object.lineDistance;
        this.align = object.align;
    }

    public ReportTextBox clone(String newString) {
        return new ReportTextBox(this, newString);
    }

    @Override
    public float print(PDDocument document, PDPageContentStream stream, int pageNumber, float textX, float textY, float allowedWidth) {
        return PdfBoxHelper.addTextWithLineBreaks(stream, this.textConfig, textX, textY, allowedWidth, this.lineDistance, this.align, this.text);
    }

    @Override
    public float getHeight(float allowedWidth) {
        int height = 0;
        String currText = this.text;
        while (!StringUtils.isEmpty((Object)currText)) {
            String[] split = this.split(allowedWidth, currText);
            height = (int)((float)height + (this.getFirstSegmentHeight(allowedWidth) + this.lineDistance));
            currText = split[1];
        }
        return height;
    }

    @Override
    public boolean isSplitable() {
        return true;
    }

    @Override
    public float getFirstSegmentHeight(float allowedWidth) {
        return this.textConfig.getFontSize();
    }

    @Override
    public ReportElement[] split(float allowedWidth) {
        String[] split = this.split(allowedWidth, this.text);
        ReportTextBox firstLine = new ReportTextBox(this, split[0]);
        ReportTextBox nextLines = new ReportTextBox(this, split[1]);
        return new ReportElement[]{firstLine, nextLines};
    }

    @Override
    public ReportElement[] split(float allowedWidth, float allowedHeight) {
        StringBuilder sb = new StringBuilder();
        String currText = this.text;
        for (float currHeight = this.getFirstSegmentHeight(allowedWidth) + this.lineDistance; !StringUtils.isEmpty((Object)currText) && currHeight <= allowedHeight && currHeight + this.getFirstSegmentHeight(allowedWidth) <= allowedHeight; currHeight += this.getFirstSegmentHeight(allowedWidth) + this.lineDistance) {
            String[] split = this.split(allowedWidth, currText);
            sb.append(split[0].trim());
            sb.append(System.getProperty("line.separator"));
            currText = split[1];
        }
        ReportTextBox firstPart = new ReportTextBox(this, sb.toString());
        ReportTextBox nextLines = StringUtils.isEmpty((Object)currText) ? null : new ReportTextBox(this, currText);
        return new ReportElement[]{firstPart, nextLines};
    }

    @Override
    public Collection<ReportImage.ImagePrintIntent> getImageIntents() {
        return Collections.emptyList();
    }

    protected String[] split(float allowedWidth, String text) {
        if (text == null) {
            return new String[]{null, null};
        }
        CacheKey key = new CacheKey(this.textConfig.getFont(), this.textConfig.getFontSize(), allowedWidth, text);
        if (this.cache.containsKey(key)) {
            return this.cache.get(key);
        }
        String[] split = PdfBoxHelper.splitText(this.textConfig.getFont(), this.textConfig.getFontSize(), allowedWidth, text);
        this.cache.put(key, split);
        return split;
    }

    public ReportAlignType getAlign() {
        return this.align;
    }

    public void setAlign(ReportAlignType align) {
        this.align = align;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    private static final class CacheKey {
        private PDFont font;
        private int fontSize;
        private float width;
        private String text;

        private CacheKey(PDFont font, int fontSize, float width, String text) {
            this.font = font;
            this.fontSize = fontSize;
            this.width = width;
            this.text = text;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            if (!this.text.equals(cacheKey.text)) {
                return false;
            }
            if (this.fontSize != cacheKey.fontSize) {
                return false;
            }
            if (Float.compare(cacheKey.width, this.width) != 0) {
                return false;
            }
            return this.font.equals((Object)cacheKey.font);
        }

        public int hashCode() {
            int result = this.font.hashCode();
            result = 31 * result + this.fontSize;
            result = 31 * result + this.text.hashCode();
            result = 31 * result + (this.width != 0.0f ? Float.floatToIntBits(this.width) : 0);
            return result;
        }
    }
}

