/*
 * Decompiled with CFR 0.152.
 */
package cc.catalysts.boot.report.pdf.elements;

import cc.catalysts.boot.report.pdf.config.PdfStyleSheet;
import cc.catalysts.boot.report.pdf.elements.ReportElement;
import cc.catalysts.boot.report.pdf.elements.ReportImage;
import cc.catalysts.boot.report.pdf.elements.ReportTextBox;
import cc.catalysts.boot.report.pdf.utils.ReportAlignType;
import cc.catalysts.boot.report.pdf.utils.ReportVerticalAlignType;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.edit.PDPageContentStream;

public class ReportTable
implements ReportElement {
    private static final boolean DEFAULT_BORDER = false;
    private static final float DEFAULT_CELL_PADDING_LEFT_RIGHT = 2.0f;
    private static final float DEFAULT_CELL_PADDING_TOP_BOTTOM = 0.0f;
    private static final int BORDER_Y_DELTA = 1;
    private final PdfStyleSheet pdfStyleSheet;
    private float[] cellWidths;
    private ReportVerticalAlignType[] cellAligns;
    private ReportElement[][] elements;
    private ReportElement[] title;
    private boolean border = false;
    private boolean noBottomBorder;
    private boolean noTopBorder;
    private boolean noInnerBorders = false;
    private boolean placeFirstBorder = true;
    private boolean placeLastBorder = true;
    private boolean enableExtraSplitting;
    private boolean isSplitable = true;
    private Collection<ReportImage.ImagePrintIntent> intents = new LinkedList<ReportImage.ImagePrintIntent>();
    private float cellPaddingX = 2.0f;
    private float cellPaddingY = 0.0f;

    public ReportTable(PdfStyleSheet pdfStyleSheet, float[] cellWidths, ReportElement[][] elements, ReportElement[] title) {
        this.pdfStyleSheet = pdfStyleSheet;
        if (elements == null || cellWidths == null) {
            throw new IllegalArgumentException("Arguments cant be null");
        }
        if (elements.length > 0 && cellWidths.length != elements[0].length) {
            throw new IllegalArgumentException("The cell widths must have the same number of elements as 'elements'");
        }
        if (title != null && title.length != cellWidths.length) {
            throw new IllegalArgumentException("Title must be null, or the same size as elements");
        }
        this.cellWidths = cellWidths;
        this.cellAligns = new ReportVerticalAlignType[cellWidths.length];
        Arrays.fill((Object[])this.cellAligns, (Object)ReportVerticalAlignType.TOP);
        this.elements = elements;
        this.title = title;
    }

    public void setNoInnerBorders(boolean noInnerBorders) {
        this.noInnerBorders = noInnerBorders;
    }

    public void setNoBottomBorder(boolean border) {
        this.noBottomBorder = border;
    }

    public void setNoTopBorder(boolean border) {
        this.noTopBorder = border;
    }

    public void setBorder(boolean border) {
        this.border = border;
    }

    public void setExtraSplitting(boolean enableExtraSplitting) {
        this.enableExtraSplitting = enableExtraSplitting;
    }

    public void setCellPaddingX(float cellPaddingX) {
        this.cellPaddingX = cellPaddingX;
    }

    public void setCellPaddingY(float cellPaddingY) {
        this.cellPaddingY = cellPaddingY;
    }

    public boolean getExtraSplitting() {
        return this.enableExtraSplitting;
    }

    @Override
    public float print(PDDocument document, PDPageContentStream stream, int pageNumber, float startX, float startY, float allowedWidth) throws IOException {
        if (this.title != null) {
            throw new IllegalStateException("title not implemented!");
        }
        float y = startY;
        int i = 0;
        float lineY = 0.0f;
        for (ReportElement[] line : this.elements) {
            float lineHeight = this.getLineHeight(line, allowedWidth) + this.pdfStyleSheet.getLineDistance();
            y = this.printLine(document, stream, pageNumber, startX, y, allowedWidth, line, lineY);
            this.placeFirstBorder = i == 0;
            this.placeLastBorder = i == this.elements.length - 1;
            this.placeBorders(stream, startY, y, startX, allowedWidth);
            ++i;
            lineY += lineHeight;
        }
        return y;
    }

    private void placeBorders(PDPageContentStream stream, float startY, float endY, float x, float allowedWidth) throws IOException {
        if (this.border) {
            stream.setStrokingColor(0, 0, 0);
            stream.setLineWidth(0.3f);
            float y0 = startY - 1.0f;
            float y1 = endY - 2.0f;
            if (!this.noInnerBorders) {
                if (!this.noTopBorder || this.noTopBorder && !this.placeFirstBorder) {
                    stream.drawLine(x, y0, x + allowedWidth, y0);
                }
                if (!this.noBottomBorder || this.noBottomBorder && !this.placeLastBorder) {
                    stream.drawLine(x, y1, x + allowedWidth, y1);
                }
            } else {
                if (!this.noTopBorder && this.placeFirstBorder) {
                    stream.drawLine(x, y0, x + allowedWidth, y0);
                }
                if (!this.noBottomBorder && this.placeLastBorder) {
                    stream.drawLine(x, y1, x + allowedWidth, y1);
                }
            }
            float currX = x;
            stream.drawLine(currX, y0, currX, y1);
            for (float width : this.cellWidths) {
                if (!this.noInnerBorders) {
                    stream.drawLine(currX, y0, currX, y1);
                }
                currX += width * allowedWidth;
            }
            stream.drawLine(currX, y0, currX, y1);
        }
    }

    private float calculateVerticalAlignment(ReportElement[] line, int elementIndex, float y, float allowedWidth) {
        float yPos = 0.0f;
        float lineHeight = this.getLineHeight(line, allowedWidth);
        switch (this.cellAligns[elementIndex]) {
            case TOP: {
                yPos = y - this.cellPaddingY;
                break;
            }
            case BOTTOM: {
                yPos = y - this.cellPaddingY - lineHeight + line[elementIndex].getHeight(this.cellWidths[elementIndex] * allowedWidth - 2.0f * this.cellPaddingX);
                break;
            }
            case MIDDLE: {
                yPos = y - this.cellPaddingY - lineHeight / 2.0f + line[elementIndex].getHeight(this.cellWidths[elementIndex] * allowedWidth - 2.0f * this.cellPaddingX) / 2.0f;
                break;
            }
            default: {
                throw new IllegalArgumentException("Vertical align type " + (Object)((Object)this.cellAligns[elementIndex]) + " not implemented for tables");
            }
        }
        return yPos;
    }

    private float printLine(PDDocument document, PDPageContentStream stream, int pageNumber, float startX, float y, float allowedWidth, ReportElement[] line, float previousLineHeight) throws IOException {
        float x = startX + this.cellPaddingX;
        float minY = y;
        for (int i = 0; i < this.cellWidths.length; ++i) {
            if (line[i] != null) {
                float yi = 0.0f;
                float yPos = this.calculateVerticalAlignment(line, i, y, allowedWidth);
                if (line[i] instanceof ReportImage) {
                    ReportImage reportImage = (ReportImage)line[i];
                    float initialWidth = reportImage.getWidth();
                    reportImage.setWidth(this.cellWidths[i] * allowedWidth - this.cellPaddingX * 2.0f);
                    reportImage.setHeight(reportImage.getHeight() * (this.cellWidths[i] * allowedWidth - this.cellPaddingX * 2.0f) / initialWidth);
                    yi = line[i].print(document, stream, pageNumber, x, yPos, this.cellWidths[i] * allowedWidth - this.cellPaddingX * 2.0f);
                    reportImage.printImage(document, pageNumber, x, yPos);
                } else {
                    yi = line[i].print(document, stream, pageNumber, x, yPos, this.cellWidths[i] * allowedWidth - this.cellPaddingX * 2.0f);
                }
                this.intents.addAll(line[i].getImageIntents());
                minY = Math.min(minY, yi);
            }
            x += this.cellWidths[i] * allowedWidth;
        }
        return minY - this.cellPaddingY;
    }

    @Override
    public float getHeight(float allowedWidth) {
        float[] maxes = new float[this.elements.length];
        for (int i = 0; i < this.elements.length; ++i) {
            maxes[i] = this.getLineHeight(this.elements[i], allowedWidth);
        }
        float max = 0.0f;
        for (float f : maxes) {
            max += f;
        }
        return max;
    }

    @Override
    public boolean isSplitable() {
        return this.isSplitable;
    }

    public void setSplitable(boolean isSplitable) {
        this.isSplitable = isSplitable;
    }

    @Override
    public float getFirstSegmentHeight(float allowedWidth) {
        if (this.elements != null && this.elements.length > 0) {
            return this.border ? this.getFirstSegmentHeightFromLine(this.elements[0], allowedWidth) + 1.0f : this.getFirstSegmentHeightFromLine(this.elements[0], allowedWidth);
        }
        return 0.0f;
    }

    private float getFirstSegmentHeightFromLine(ReportElement[] line, float allowedWidth) {
        float maxHeight = 0.0f;
        for (int i = 0; i < line.length; ++i) {
            if (line[i] == null) continue;
            maxHeight = Math.max(maxHeight, line[i].getFirstSegmentHeight(this.cellWidths[i] * allowedWidth - this.cellPaddingX * 2.0f));
        }
        return maxHeight + 2.0f * this.cellPaddingY;
    }

    private float getLineHeight(ReportElement[] line, float allowedWidth) {
        float maxHeight = 0.0f;
        for (int i = 0; i < line.length; ++i) {
            float currentHeight;
            if (line[i] == null) continue;
            if (line[i] instanceof ReportImage) {
                ReportImage lineImage = (ReportImage)line[i];
                currentHeight = lineImage.getHeight() * (this.cellWidths[i] * allowedWidth - this.cellPaddingX * 2.0f) / lineImage.getWidth();
            } else {
                currentHeight = line[i].getHeight(this.cellWidths[i] * allowedWidth - this.cellPaddingX * 2.0f);
            }
            maxHeight = Math.max(maxHeight, currentHeight);
        }
        return maxHeight + 2.0f * this.cellPaddingY;
    }

    private ReportTable createNewTableWithClonedSettings(ReportElement[][] data) {
        ReportTable newTable = new ReportTable(this.pdfStyleSheet, this.cellWidths, data, this.title);
        newTable.setBorder(this.border);
        newTable.setCellPaddingX(this.cellPaddingX);
        newTable.setCellPaddingY(this.cellPaddingY);
        newTable.setExtraSplitting(this.enableExtraSplitting);
        return newTable;
    }

    @Override
    public Collection<ReportImage.ImagePrintIntent> getImageIntents() {
        return this.intents;
    }

    public ReportElement[] splitFirstCell(float allowedHeight, float allowedWidth) {
        ReportElement[] firstLineA = new ReportElement[this.elements[0].length];
        ReportElement[] firstLineB = new ReportElement[this.elements[0].length];
        boolean hasSecondPart = false;
        for (int i = 0; i < this.elements[0].length; ++i) {
            ReportElement elem = this.elements[0][i];
            float width = this.cellWidths[i] * allowedWidth - 2.0f * this.cellPaddingX;
            if (elem != null && elem.isSplitable()) {
                ReportElement[] split = elem.split(width, allowedHeight);
                firstLineA[i] = split[0];
                firstLineB[i] = split[1];
                if (firstLineB[i] == null) continue;
                hasSecondPart = true;
                continue;
            }
            firstLineA[i] = elem;
        }
        if (hasSecondPart) {
            ReportElement[][] newMatrix = new ReportElement[this.elements.length][this.elements[0].length];
            newMatrix[0] = firstLineB;
            for (int i = 1; i < this.elements.length; ++i) {
                newMatrix[i] = this.elements[i];
            }
            ReportTable firstLine = this.createNewTableWithClonedSettings(new ReportElement[][]{firstLineA});
            ReportTable nextLines = this.createNewTableWithClonedSettings(newMatrix);
            return new ReportElement[]{firstLine, nextLines};
        }
        return new ReportElement[]{this, null};
    }

    @Override
    public ReportElement[] split(float allowedWidth, float allowedHeight) {
        int i;
        float currentHeight = 0.0f;
        for (i = 0; i < this.elements.length && currentHeight + this.getLineHeight(this.elements[i], allowedWidth) < allowedHeight; ++i) {
            currentHeight += this.getLineHeight(this.elements[i], allowedWidth);
        }
        if (i > 0) {
            ReportElement[][] extraRows = new ReportElement[2][this.elements[0].length];
            boolean splittable = false;
            if (this.enableExtraSplitting) {
                int j;
                splittable = true;
                for (j = 0; j < this.elements[i].length; ++j) {
                    if (this.elements[i][j].isSplitable() && !(currentHeight + this.elements[i][j].getFirstSegmentHeight(this.cellWidths[j] * allowedWidth - this.cellPaddingX * 2.0f) + 2.0f * this.cellPaddingY >= allowedHeight)) continue;
                    splittable = false;
                }
                if (splittable) {
                    for (j = 0; j < this.elements[i].length; ++j) {
                        if (this.elements[i][j].getHeight(this.cellWidths[j] * allowedWidth - this.cellPaddingX * 2.0f) + currentHeight < allowedHeight) {
                            extraRows[0][j] = this.elements[i][j];
                            extraRows[1][j] = new ReportTextBox(this.pdfStyleSheet.getBodyText(), this.pdfStyleSheet.getLineDistance(), "");
                            continue;
                        }
                        ReportElement[] extraSplit = this.elements[i][j].split(this.cellWidths[j] * allowedWidth - this.cellPaddingX * 2.0f, allowedHeight - currentHeight - 2.0f * this.cellPaddingY);
                        extraRows[0][j] = extraSplit[0];
                        extraRows[1][j] = extraSplit[1];
                    }
                }
            }
            ReportElement[][] first = new ReportElement[splittable ? i + 1 : i][this.elements[0].length];
            ReportElement[][] next = new ReportElement[this.elements.length - i][this.elements[0].length];
            for (int j = 0; j < this.elements.length; ++j) {
                if (j < i) {
                    first[j] = this.elements[j];
                    continue;
                }
                next[j - i] = this.elements[j];
            }
            if (splittable) {
                first[i] = extraRows[0];
                next[0] = extraRows[1];
            }
            ReportTable firstLine = this.createNewTableWithClonedSettings(first);
            ReportTable nextLines = this.createNewTableWithClonedSettings(next);
            return new ReportElement[]{firstLine, nextLines};
        }
        ReportElement[][] first = new ReportElement[1][this.elements[0].length];
        ReportElement[][] next = new ReportElement[this.elements.length][this.elements[0].length];
        for (i = 1; i < this.elements.length; ++i) {
            next[i] = this.elements[i];
        }
        for (i = 0; i < this.elements[0].length; ++i) {
            ReportElement[] splits = this.elements[0][i].split(this.cellWidths[i] * allowedWidth - this.cellPaddingX * 2.0f, allowedHeight - 2.0f * this.cellPaddingY);
            first[0][i] = splits[0] != null ? splits[0] : new ReportTextBox(this.pdfStyleSheet.getBodyText(), this.pdfStyleSheet.getLineDistance(), "");
            next[0][i] = splits[1] != null ? splits[1] : new ReportTextBox(this.pdfStyleSheet.getBodyText(), this.pdfStyleSheet.getLineDistance(), "");
        }
        ReportTable firstLine = this.createNewTableWithClonedSettings(first);
        ReportTable nextLines = this.createNewTableWithClonedSettings(next);
        return new ReportElement[]{firstLine, nextLines};
    }

    @Override
    public ReportElement[] split(float allowedWidth) {
        ReportElement[][] first = new ReportElement[][]{this.elements[0]};
        ReportElement[][] next = (ReportElement[][])Arrays.copyOfRange(this.elements, 1, this.elements.length);
        ReportTable firstLine = this.createNewTableWithClonedSettings(first);
        ReportTable nextLines = this.createNewTableWithClonedSettings(next);
        return new ReportElement[]{firstLine, nextLines};
    }

    public void setTextAlignInColumn(int column, ReportAlignType alignType, boolean excludeHeader) {
        int i;
        int n = i = excludeHeader ? 1 : 0;
        while (i < this.elements.length) {
            ReportElement[] element = this.elements[i];
            if (element[column] instanceof ReportTextBox) {
                ((ReportTextBox)element[column]).setAlign(alignType);
            }
            ++i;
        }
    }

    public void setVerticalAlignInColumn(int column, ReportVerticalAlignType alignType) {
        this.cellAligns[column] = alignType;
    }

    public ReportElement[][] getElements() {
        return this.elements;
    }

    public ReportElement[] getTitle() {
        return this.title;
    }

    public float[] getCellWidths() {
        return this.cellWidths;
    }

    public PdfStyleSheet getPdfStyleSheet() {
        return this.pdfStyleSheet;
    }
}

