/*
 * Decompiled with CFR 0.152.
 */
package cc.catalysts.boot.report.pdf.elements;

import cc.catalysts.boot.report.pdf.config.PdfTextStyle;
import cc.catalysts.boot.report.pdf.elements.PdfBoxHelper;
import cc.catalysts.boot.report.pdf.elements.ReportElement;
import cc.catalysts.boot.report.pdf.elements.ReportTextBox;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.edit.PDPageContentStream;
import org.springframework.util.StringUtils;

public class ReportRichTextBox
extends ReportTextBox {
    public ReportRichTextBox(PdfTextStyle textConfig, float lineDistance, String text) {
        super(textConfig, lineDistance, text);
    }

    public ReportRichTextBox(ReportRichTextBox object, String text) {
        super(object, text);
    }

    @Override
    public ReportTextBox clone(String newString) {
        return new ReportRichTextBox(this, newString);
    }

    @Override
    public float print(PDDocument document, PDPageContentStream stream, int pageNumber, float textX, float textY, float allowedWidth) {
        return PdfBoxHelper.addRichText(stream, this.textConfig, textX, textY, allowedWidth, this.lineDistance, this.align, this.text);
    }

    @Override
    public ReportElement[] split(float allowedWidth) {
        String[] split = this.split(allowedWidth, this.text);
        ReportRichTextBox firstLine = new ReportRichTextBox(this, split[0]);
        ReportRichTextBox nextLines = new ReportRichTextBox(this, split[1]);
        return new ReportElement[]{firstLine, nextLines};
    }

    @Override
    public ReportElement[] split(float allowedWidth, float allowedHeight) {
        StringBuilder sb = new StringBuilder();
        String currText = this.text;
        for (float currHeight = this.getFirstSegmentHeight(allowedWidth) + this.lineDistance; !StringUtils.isEmpty((Object)currText) && currHeight <= allowedHeight && currHeight + this.getFirstSegmentHeight(allowedWidth) <= allowedHeight; currHeight += this.getFirstSegmentHeight(allowedWidth) + this.lineDistance) {
            String[] split = this.split(allowedWidth, currText);
            sb.append(split[0].trim());
            sb.append(System.getProperty("line.separator"));
            currText = split[1];
        }
        ReportRichTextBox firstPart = new ReportRichTextBox(this, sb.toString());
        ReportRichTextBox nextLines = StringUtils.isEmpty((Object)currText) ? null : new ReportRichTextBox(this, currText);
        return new ReportElement[]{firstPart, nextLines};
    }
}

