/*
 * Decompiled with CFR 0.152.
 */
package cc.catalysts.boot.report.pdf.elements;

import cc.catalysts.boot.report.pdf.elements.AbstractReportElement;
import cc.catalysts.boot.report.pdf.elements.ReportElement;
import cc.catalysts.boot.report.pdf.utils.ReportAlignType;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.edit.PDPageContentStream;
import org.apache.pdfbox.pdmodel.graphics.xobject.PDJpeg;
import org.apache.pdfbox.pdmodel.graphics.xobject.PDXObject;

public class ReportImage
extends AbstractReportElement
implements ReportElement {
    private BufferedImage img;
    private ImagePrintIntent intent;
    private float width;
    private float height;
    private ReportAlignType align = ReportAlignType.LEFT;

    public ReportImage(BufferedImage img, float width, float height) {
        this.img = img;
        this.width = width;
        this.height = height;
    }

    @Override
    public float print(PDDocument document, PDPageContentStream stream, int pageNumber, float leftX, float startY, float allowedWidth) throws IOException {
        this.intent = new ImagePrintIntent(this, pageNumber, this.calcStartX(leftX, allowedWidth, this.width), startY);
        return startY - this.height;
    }

    @Override
    public float getHeight(float allowedWidth) {
        return this.height;
    }

    public void printImage(PDDocument document, int pageNumber, float x, float y) throws IOException {
        PDJpeg obj = new PDJpeg(document, this.img);
        PDPageContentStream currentStream = new PDPageContentStream(document, (PDPage)document.getDocumentCatalog().getAllPages().get(pageNumber), true, false);
        currentStream.drawXObject((PDXObject)obj, x, y - this.height, this.width, this.height);
        currentStream.close();
    }

    private float calcStartX(float leftX, float allowedWidth, float imgWidth) {
        switch (this.getAlign()) {
            case LEFT: {
                return leftX;
            }
            case CENTER: {
                return (allowedWidth - imgWidth) / 2.0f + leftX;
            }
        }
        throw new IllegalStateException("align type not implemented");
    }

    @Override
    public Collection<ImagePrintIntent> getImageIntents() {
        if (this.intent == null) {
            throw new IllegalStateException("print must be called before getImage intents");
        }
        return Collections.singletonList(this.intent);
    }

    public void setAlign(ReportAlignType align) {
        this.align = align;
    }

    public ReportAlignType getAlign() {
        return this.align;
    }

    public void setWidth(float width) {
        this.width = width;
    }

    public void setHeight(float height) {
        this.height = height;
    }

    public float getWidth() {
        return this.width;
    }

    public float getHeight() {
        return this.height;
    }

    public static class ImagePrintIntent {
        private ReportImage img;
        private int page;
        private float x;
        private float y;

        public ImagePrintIntent(ReportImage img, int page, float x, float y) {
            this.img = img;
            this.page = page;
            this.x = x;
            this.y = y;
        }

        public ReportImage getImg() {
            return this.img;
        }

        public int getPage() {
            return this.page;
        }

        public float getX() {
            return this.x;
        }

        public float getY() {
            return this.y;
        }
    }
}

