/*
 * Decompiled with CFR 0.152.
 */
package cc.catalysts.boot.report.pdf.elements;

import cc.catalysts.boot.report.pdf.elements.ReportElement;
import cc.catalysts.boot.report.pdf.elements.ReportImage;
import cc.catalysts.boot.report.pdf.utils.PositionOfStaticElements;
import java.io.IOException;
import java.util.Collection;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.edit.PDPageContentStream;

public class ReportElementStatic
implements ReportElement {
    private ReportElement base;
    private float x;
    private float y;
    private float width;
    private int pageNo;
    private PositionOfStaticElements position;

    public ReportElementStatic(ReportElement base, int pageNo, float x, float y, float width, PositionOfStaticElements position) {
        this.base = base;
        this.x = x;
        this.y = y;
        this.pageNo = pageNo;
        this.width = width;
        this.position = position;
    }

    public ReportElement getBase() {
        return this.base;
    }

    @Override
    public float print(PDDocument document, PDPageContentStream stream, int pageNumber, float startX, float startY, float allowedWidth) throws IOException {
        PDPage currPage = (PDPage)document.getDocumentCatalog().getAllPages().get(this.pageNo);
        PDPageContentStream pageStream = new PDPageContentStream(document, currPage, true, false);
        this.base.print(document, pageStream, this.pageNo, this.x, this.y, this.width);
        pageStream.close();
        return 0.0f;
    }

    @Override
    public float getHeight(float allowedWidth) {
        throw new IllegalStateException("Height of static elements is irrelevant");
    }

    @Override
    public boolean isSplitable() {
        return false;
    }

    @Override
    public float getFirstSegmentHeight(float allowedWidth) {
        throw new IllegalStateException("static elements are not splittable");
    }

    @Override
    public ReportElement[] split(float allowedWidth) {
        throw new IllegalStateException("static elements are not splittable");
    }

    @Override
    public ReportElement[] split(float allowedWidth, float allowedHeight) {
        throw new IllegalStateException("static elements are not splittable");
    }

    @Override
    public Collection<ReportImage.ImagePrintIntent> getImageIntents() {
        return this.base.getImageIntents();
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public float getWidth() {
        return this.width;
    }

    public int getPageNo() {
        return this.pageNo;
    }

    public PositionOfStaticElements getPosition() {
        return this.position;
    }
}

