/*
 * Decompiled with CFR 0.152.
 */
package cc.catalysts.boot.report.pdf.elements;

import cc.catalysts.boot.report.pdf.elements.AbstractReportElement;
import cc.catalysts.boot.report.pdf.elements.ReportElement;
import cc.catalysts.boot.report.pdf.elements.ReportImage;
import cc.catalysts.boot.report.pdf.elements.ReportPadding;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.edit.PDPageContentStream;

public class ReportCompositeElement
extends AbstractReportElement {
    private final List<ReportElement> elements = new ArrayList<ReportElement>();
    private Collection<ReportImage.ImagePrintIntent> intents = new LinkedList<ReportImage.ImagePrintIntent>();

    public ReportCompositeElement addElement(ReportElement element) {
        this.elements.add(element);
        return this;
    }

    @Override
    public float print(PDDocument document, PDPageContentStream stream, int pageNumber, float startX, float startY, float allowedWidth) throws IOException {
        float lastY = startY;
        for (ReportElement element : this.elements) {
            lastY = element.print(document, stream, pageNumber, startX, lastY, allowedWidth);
            this.intents.addAll(element.getImageIntents());
        }
        return lastY;
    }

    @Override
    public float getHeight(float allowedWidth) {
        float height = 0.0f;
        for (ReportElement element : this.elements) {
            if (element instanceof ReportPadding) {
                height += ((ReportPadding)element).getPadding();
                continue;
            }
            height += element.getHeight(allowedWidth);
        }
        return height;
    }

    @Override
    public Collection<ReportImage.ImagePrintIntent> getImageIntents() {
        return this.intents;
    }
}

