/*
 * Decompiled with CFR 0.152.
 */
package cc.catalysts.boot.report.pdf.elements;

import cc.catalysts.boot.report.pdf.config.PdfTextStyle;
import cc.catalysts.boot.report.pdf.exception.PdfBoxHelperException;
import cc.catalysts.boot.report.pdf.utils.ReportAlignType;
import java.io.IOException;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.pdfbox.encoding.WinAnsiEncoding;
import org.apache.pdfbox.pdmodel.edit.PDPageContentStream;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

final class PdfBoxHelper {
    private static final Logger LOG = LoggerFactory.getLogger(PdfBoxHelper.class);
    private static final char FALLBACK_CHAR = '?';
    private static float lastTextEndX = 0.0f;

    private PdfBoxHelper() {
    }

    private static float calculateAlignPosition(float x, ReportAlignType align, PdfTextStyle textConfig, float allowedWidth, String text) {
        switch (align) {
            case LEFT: {
                return x;
            }
            case RIGHT: {
                float w = PdfBoxHelper.getTextWidth(textConfig.getFont(), textConfig.getFontSize(), text);
                return x + allowedWidth - w;
            }
            case CENTER: {
                float halfW = PdfBoxHelper.getTextWidth(textConfig.getFont(), textConfig.getFontSize(), text) / 2.0f;
                float absoluteCenter = allowedWidth / 2.0f + x;
                return absoluteCenter - halfW;
            }
        }
        throw new IllegalArgumentException("Align type " + (Object)((Object)align) + " not implemented for text");
    }

    public static float addText(PDPageContentStream stream, PdfTextStyle textConfig, float firstLineTextX, float textX, float textY, float allowedWidth, float lineHeightD, ReportAlignType align, String text, boolean underline) {
        String fixedText = text;
        if (textConfig.getFont() == null || textConfig.getFont().getFontEncoding() instanceof WinAnsiEncoding) {
            fixedText = PdfBoxHelper.fixString(text);
        }
        float nextLineY = PdfBoxHelper.nextLineY((int)textY, textConfig.getFontSize(), lineHeightD);
        try {
            String[] split = PdfBoxHelper.splitText(textConfig.getFont(), textConfig.getFontSize(), allowedWidth - (firstLineTextX - textX), fixedText);
            float x = PdfBoxHelper.calculateAlignPosition(firstLineTextX, align, textConfig, allowedWidth, split[0]);
            if (!underline) {
                PdfBoxHelper.addTextSimple(stream, textConfig, x, nextLineY, split[0]);
            } else {
                PdfBoxHelper.addTextSimpleUnderlined(stream, textConfig, x, nextLineY, split[0]);
            }
            if (!StringUtils.isEmpty((Object)split[1])) {
                return PdfBoxHelper.addText(stream, textConfig, textX, textX, nextLineY, allowedWidth, lineHeightD, align, split[1], underline);
            }
            return nextLineY;
        }
        catch (Exception e) {
            LOG.warn("Could not add text: " + e.getClass() + " - " + e.getMessage());
            return textY;
        }
    }

    public static float addText(PDPageContentStream stream, PdfTextStyle textConfig, float textX, float textY, float allowedWidth, float lineHeightD, ReportAlignType align, String text) {
        return PdfBoxHelper.addText(stream, textConfig, textX, textX, textY, allowedWidth, lineHeightD, align, text, false);
    }

    private static String generalizeLineSeparators(String text) {
        String generalizedString = text.replace("\r\n", "\n");
        if (System.lineSeparator().equals("\r\n")) {
            generalizedString = generalizedString.replace("\n", "\r\n");
        }
        return generalizedString;
    }

    private static String replaceBulletPoints(String str) {
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) == '-') {
                return str.substring(0, i) + "\u2022" + str.substring(i + 1);
            }
            if (str.charAt(i) != ' ' && str.charAt(i) != '\t') break;
        }
        return str;
    }

    private static List<TextSegment> findTextSegments(PdfTextStyle bodyText, String str) {
        ArrayList<TextSegment> segments = new ArrayList<TextSegment>();
        if (str.isEmpty()) {
            segments.add(new TextSegment("", bodyText));
            return segments;
        }
        List<Character> markdownChars = Arrays.asList(Character.valueOf('*'), Character.valueOf('+'));
        List<Character> whiteSpaces = Arrays.asList(Character.valueOf(' '), Character.valueOf('\r'), Character.valueOf('\n'), Character.valueOf('\t'));
        PdfTextStyle boldText = new PdfTextStyle(bodyText.getFontSize(), PDType1Font.HELVETICA_BOLD, bodyText.getColor());
        String temp = "";
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (markdownChars.contains(Character.valueOf(c)) && i < str.length() - 1 && !whiteSpaces.contains(Character.valueOf(str.charAt(i + 1)))) {
                if (temp.length() > 0) {
                    segments.add(new TextSegment(temp.replaceAll("\\s+$", ""), bodyText));
                }
                temp = "";
                int endIndex = -1;
                for (int end = i + 1; end < str.length(); ++end) {
                    if (str.charAt(end) != c) continue;
                    if (whiteSpaces.contains(Character.valueOf(str.charAt(end - 1)))) {
                        temp = temp + c;
                        break;
                    }
                    endIndex = end;
                    break;
                }
                if (endIndex == -1) continue;
                String stringSegment = str.substring(i + 1, endIndex);
                List<TextSegment> subSegments = PdfBoxHelper.findTextSegments(bodyText, stringSegment);
                segments.addAll(subSegments);
                for (TextSegment segment : subSegments) {
                    switch (c) {
                        case '*': {
                            segment.setStyle(boldText);
                            break;
                        }
                        case '+': {
                            segment.setUnderlined(true);
                        }
                    }
                }
                i = endIndex;
                continue;
            }
            temp = temp + c;
        }
        if (temp.length() > 0) {
            segments.add(new TextSegment(temp.replaceAll("\\s+$", ""), bodyText));
        }
        return segments;
    }

    public static float addRichText(PDPageContentStream stream, PdfTextStyle textConfig, float textX, float textY, float allowedWidth, float lineHeightD, ReportAlignType align, String text) {
        String[] lines = PdfBoxHelper.generalizeLineSeparators(text).split(System.lineSeparator());
        float currX = textX;
        float currY = textY;
        for (String line : lines) {
            List<TextSegment> segments = PdfBoxHelper.findTextSegments(textConfig, PdfBoxHelper.replaceBulletPoints(line));
            int i = 0;
            for (TextSegment seg : segments) {
                float absoluteLineHeight = -PdfBoxHelper.nextLineY(0, seg.getStyle().getFontSize(), lineHeightD);
                float endY = PdfBoxHelper.addText(stream, seg.getStyle(), currX, textX, currY, allowedWidth, lineHeightD, align, seg.getText(), seg.isUnderlined());
                currY = endY + absoluteLineHeight;
                currX = lastTextEndX;
                boolean underline = seg.isUnderlined() && i + 1 < segments.size() && segments.get(i + 1).isUnderlined();
                endY = PdfBoxHelper.addText(stream, seg.getStyle(), currX, textX, currY, allowedWidth, lineHeightD, align, " ", underline);
                currX = lastTextEndX;
                currY = endY + absoluteLineHeight;
                ++i;
            }
            currY = PdfBoxHelper.nextLineY((int)currY, textConfig.getFontSize(), lineHeightD);
            currX = textX;
        }
        return currY;
    }

    public static float addTextWithLineBreaks(PDPageContentStream stream, PdfTextStyle textConfig, float textX, float textY, float allowedWidth, float lineHeightD, ReportAlignType align, String text) {
        String[] lines = PdfBoxHelper.generalizeLineSeparators(text).split(System.lineSeparator());
        float currY = textY;
        for (String line : lines) {
            currY = PdfBoxHelper.addText(stream, textConfig, textX, currY, allowedWidth, lineHeightD, align, line);
        }
        return currY;
    }

    private static String fixString(String original) {
        StringBuilder sb = new StringBuilder();
        try {
            block9: for (char ch : original.toCharArray()) {
                if (WinAnsiEncoding.INSTANCE.hasNameForCode((int)ch)) {
                    sb.append(ch);
                    continue;
                }
                switch (ch) {
                    case '\u201c': 
                    case '\u201e': {
                        sb.append('\"');
                        continue block9;
                    }
                    case '\u2026': {
                        sb.append("...");
                        continue block9;
                    }
                    case '\u20ac': {
                        sb.append('\u0080');
                        continue block9;
                    }
                    case '\u2022': {
                        sb.append('\u0095');
                        continue block9;
                    }
                    case '\u2013': {
                        sb.append('\u0096');
                        continue block9;
                    }
                    default: {
                        char decodedChar;
                        String decoded = Normalizer.normalize(String.valueOf(ch), Normalizer.Form.NFD);
                        char c = decodedChar = decoded != null && decoded.length() > 0 ? (char)decoded.charAt(0) : (char)'?';
                        if (WinAnsiEncoding.INSTANCE.getCharacter((int)decodedChar) != null) {
                            sb.append(decodedChar);
                            continue block9;
                        }
                        sb.append('?');
                    }
                }
            }
        }
        catch (Exception e) {
            throw new PdfBoxHelperException("unexpected character decoding error for input " + original, e);
        }
        return sb.toString();
    }

    public static void addTextSimple(PDPageContentStream stream, PdfTextStyle textConfig, float textX, float textY, String text) {
        try {
            stream.setFont(textConfig.getFont(), (float)textConfig.getFontSize());
            stream.setNonStrokingColor(textConfig.getColor());
            stream.beginText();
            stream.moveTextPositionByAmount(textX, textY);
            stream.drawString(text);
            stream.endText();
            lastTextEndX = textX + PdfBoxHelper.getTextWidth(textConfig.getFont(), textConfig.getFontSize(), text);
        }
        catch (Exception e) {
            LOG.warn("Could not add text: " + e.getClass() + " - " + e.getMessage());
        }
    }

    public static void addTextSimpleUnderlined(PDPageContentStream stream, PdfTextStyle textConfig, float textX, float textY, String text) {
        PdfBoxHelper.addTextSimple(stream, textConfig, textX, textY, text);
        try {
            float lineOffset = (float)textConfig.getFontSize() / 8.0f;
            stream.setStrokingColor(textConfig.getColor());
            stream.setLineWidth(0.5f);
            stream.drawLine(textX, textY - lineOffset, textX + PdfBoxHelper.getTextWidth(textConfig.getFont(), textConfig.getFontSize(), text), textY - lineOffset);
            stream.stroke();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static List<Integer> getWrapableIndexes(String text) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        Pattern pt = Pattern.compile("\\s+");
        Matcher m = pt.matcher(text);
        while (m.find()) {
            list.add(m.start());
        }
        list.add(text.length());
        return list;
    }

    public static String[] splitText(PDFont font, int fontSize, float allowedWidth, String text) {
        String part2;
        String part1;
        String endPart = "";
        String shortenedText = text;
        if (PdfBoxHelper.getTextWidth(font, fontSize, shortenedText) <= allowedWidth && shortenedText.indexOf(13) == -1) {
            return new String[]{shortenedText, null};
        }
        boolean cleanSplit = true;
        List<Integer> indexes = PdfBoxHelper.getWrapableIndexes(shortenedText);
        int start = 0;
        int j = indexes.size() - 1;
        int end = indexes.get(j);
        int lineBreakPos = shortenedText.indexOf(10);
        if (lineBreakPos != -1 && PdfBoxHelper.getTextWidth(font, fontSize, shortenedText.substring(start, lineBreakPos)) <= allowedWidth) {
            end = lineBreakPos;
        } else {
            while (PdfBoxHelper.getTextWidth(font, fontSize, shortenedText.substring(start, end)) > allowedWidth) {
                if (j == 0) {
                    cleanSplit = false;
                    break;
                }
                end = indexes.get(--j);
            }
        }
        if (!cleanSplit) {
            end = shortenedText.length();
            while (PdfBoxHelper.getTextWidth(font, fontSize, shortenedText.substring(start, end)) > allowedWidth) {
                --end;
            }
        }
        if (cleanSplit) {
            part1 = shortenedText.substring(start, end).trim();
            part2 = shortenedText.substring(end + 1, shortenedText.length()).concat(endPart).trim();
        } else {
            part1 = shortenedText.substring(start, end - 1).concat("-").trim();
            part2 = shortenedText.substring(end - 1, shortenedText.length()).concat(endPart).trim();
        }
        return new String[]{part1, part2};
    }

    public static float getTextWidth(PDFont font, int fontSize, String text) {
        try {
            return font.getStringWidth(text) / 1000.0f * (float)fontSize;
        }
        catch (Exception e) {
            LOG.warn("Could not calculate string length: " + e.getClass() + " - " + e.getMessage());
            return 0.0f;
        }
    }

    public static float nextLineY(int currentY, int fontSize, float lineHeightD) {
        return (float)(currentY - fontSize) - lineHeightD;
    }

    private static class TextSegment {
        private String text;
        private PdfTextStyle style;
        private boolean underlined;

        public TextSegment(String text, PdfTextStyle style) {
            this(text, style, false);
        }

        public TextSegment(String text, PdfTextStyle style, boolean underline) {
            this.text = text;
            this.style = style;
            this.underlined = underline;
        }

        public boolean isUnderlined() {
            return this.underlined;
        }

        public void setUnderlined(boolean underlined) {
            this.underlined = underlined;
        }

        public String getText() {
            return this.text;
        }

        public void setText(String text) {
            this.text = text;
        }

        public PdfTextStyle getStyle() {
            return this.style;
        }

        public void setStyle(PdfTextStyle style) {
            this.style = style;
        }
    }
}

