/*
 * Decompiled with CFR 0.152.
 */
package cc.catalysts.boot.report.pdf.impl;

import cc.catalysts.boot.report.pdf.PdfReportBuilder;
import cc.catalysts.boot.report.pdf.ReportTableBuilder;
import cc.catalysts.boot.report.pdf.ReportTableRowBuilder;
import cc.catalysts.boot.report.pdf.config.PdfStyleSheet;
import cc.catalysts.boot.report.pdf.elements.ReportElement;
import cc.catalysts.boot.report.pdf.elements.ReportTable;
import cc.catalysts.boot.report.pdf.elements.ReportTextBox;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ReportTableBuilderImpl
implements ReportTableBuilder {
    private final PdfStyleSheet pdfStyleSheet;
    private List<String> columnNames = new ArrayList<String>();
    private List<Float> columnWeights = new ArrayList<Float>();
    private List<List<String>> tableValues = new ArrayList<List<String>>();
    private PdfReportBuilder reportBuilder;

    public ReportTableBuilderImpl(PdfStyleSheet pdfStyleSheet, PdfReportBuilder reportBuilder) {
        this.pdfStyleSheet = pdfStyleSheet;
        this.reportBuilder = reportBuilder;
    }

    public ReportTableBuilderImpl addColumn(String name) {
        this.addColumn(name, 1.0f);
        return this;
    }

    @Override
    public ReportTableBuilderImpl addColumn(String name, float weight) {
        this.columnNames.add(name);
        this.columnWeights.add(Float.valueOf(weight));
        return this;
    }

    public ReportTableBuilderImpl setColumns(String ... names) {
        this.columnNames.addAll(Arrays.asList(names));
        for (int i = 0; i < names.length; ++i) {
            this.columnWeights.add(Float.valueOf(1.0f));
        }
        return this;
    }

    @Override
    public ReportTableRowBuilderImpl createRow() {
        return new ReportTableRowBuilderImpl(this);
    }

    void addRow(List<String> values) {
        if (values.size() != this.columnNames.size()) {
            throw new IllegalArgumentException("invalid value count, must match column count: " + this.columnNames.size());
        }
        this.tableValues.add(values);
    }

    @Override
    public ReportTable build() {
        float[] widths = new float[this.columnNames.size()];
        float sum = 0.0f;
        for (Float weight : this.columnWeights) {
            sum += weight.floatValue();
        }
        float singlePartWidth = 1.0f / sum;
        for (int i = 0; i < widths.length; ++i) {
            widths[i] = singlePartWidth * this.columnWeights.get(i).floatValue();
        }
        return this.buildTableWithWidths(widths);
    }

    public ReportTable buildTableWithWidths(float[] widths) {
        ReportTable reportTable = new ReportTable(this.pdfStyleSheet, widths, this.toArray(), null);
        reportTable.setBorder(true);
        return reportTable;
    }

    private ReportElement[][] toArray() {
        ReportElement[][] result = new ReportElement[this.tableValues.size() + 1][this.columnNames.size()];
        int row = 0;
        int col = 0;
        for (col = 0; col < this.columnNames.size(); ++col) {
            result[row][col] = new ReportTextBox(this.pdfStyleSheet.getTableTitleText(), this.pdfStyleSheet.getLineDistance(), this.columnNames.get(col));
        }
        ++row;
        for (List<String> rowValues : this.tableValues) {
            col = 0;
            for (String value : rowValues) {
                result[row][col] = new ReportTextBox(this.pdfStyleSheet.getTableBodyText(), this.pdfStyleSheet.getLineDistance(), value);
                ++col;
            }
            ++row;
        }
        return result;
    }

    @Override
    public PdfReportBuilder endTable() {
        this.reportBuilder.addElement(this.build());
        return this.reportBuilder;
    }

    public static class ReportTableRowBuilderImpl
    implements ReportTableRowBuilder {
        private final ReportTableBuilderImpl parent;
        private List<String> values = new ArrayList<String>();

        ReportTableRowBuilderImpl(ReportTableBuilderImpl parent) {
            this.parent = parent;
        }

        @Override
        public ReportTableRowBuilderImpl addValue(String value) {
            this.values.add(value);
            return this;
        }

        @Override
        public ReportTableBuilderImpl withValues(String ... rowValues) {
            this.values.addAll(Arrays.asList(rowValues));
            return this.endRow();
        }

        @Override
        public ReportTableBuilderImpl endRow() {
            this.parent.addRow(this.values);
            return this.parent;
        }
    }
}

