/*
 * Decompiled with CFR 0.152.
 */
package cc.catalysts.boot.report.pdf.impl;

import cc.catalysts.boot.report.pdf.config.PdfPageLayout;
import cc.catalysts.boot.report.pdf.config.PdfStyleSheet;
import cc.catalysts.boot.report.pdf.elements.ReportElementStatic;
import cc.catalysts.boot.report.pdf.elements.ReportTextBox;
import cc.catalysts.boot.report.pdf.impl.PdfReportStructure;
import cc.catalysts.boot.report.pdf.utils.ReportAlignType;
import java.util.ArrayList;
import org.springframework.util.StringUtils;

public abstract class AbstractFixedLineGenerator {
    private final PdfStyleSheet pdfStyleSheet;
    private String leftText;
    private String centerText;
    private String rightText;
    public static final String PAGE_TEMPLATE_CURR = "%PAGE_NUMBER%";
    public static final String PAGE_TEMPLATE_TOTAL = "%TOTAL_PAGES%";

    public AbstractFixedLineGenerator(PdfStyleSheet pdfStyleSheet, String leftText, String centerText, String rightText) {
        this.pdfStyleSheet = pdfStyleSheet;
        this.leftText = leftText;
        this.centerText = centerText;
        this.rightText = rightText;
    }

    public void addFooterToAllPages(PdfReportStructure report, PdfPageLayout pageConfig) {
        ReportTextBox footerElem;
        float x = pageConfig.getStartX();
        float y = this.getVerticalPosition(pageConfig);
        float w = pageConfig.getUsableWidth();
        ArrayList<ReportElementStatic> staticElements = new ArrayList<ReportElementStatic>();
        if (!StringUtils.isEmpty((Object)this.leftText)) {
            footerElem = new ReportTextBox(this.pdfStyleSheet.getFooterText(), this.pdfStyleSheet.getLineDistance(), this.leftText);
            footerElem.setAlign(ReportAlignType.LEFT);
            staticElements.add(new ReportElementStatic(footerElem, 0, x, y, w));
        }
        if (!StringUtils.isEmpty((Object)this.centerText)) {
            footerElem = new ReportTextBox(this.pdfStyleSheet.getFooterText(), this.pdfStyleSheet.getLineDistance(), this.centerText);
            footerElem.setAlign(ReportAlignType.CENTER);
            staticElements.add(new ReportElementStatic(footerElem, 0, x, y, w));
        }
        if (!StringUtils.isEmpty((Object)this.rightText)) {
            footerElem = new ReportTextBox(this.pdfStyleSheet.getFooterText(), this.pdfStyleSheet.getLineDistance(), this.rightText);
            footerElem.setAlign(ReportAlignType.RIGHT);
            staticElements.add(new ReportElementStatic(footerElem, 0, x, y, w));
        }
        report.addStaticElementsForEachPage(staticElements.toArray(new ReportElementStatic[staticElements.size()]));
    }

    abstract float getVerticalPosition(PdfPageLayout var1);
}

