/*
 * Decompiled with CFR 0.152.
 */
package cc.catalysts.boot.report.pdf.elements;

import cc.catalysts.boot.report.pdf.config.PdfTextStyle;
import cc.catalysts.boot.report.pdf.exception.PdfBoxHelperException;
import cc.catalysts.boot.report.pdf.utils.ReportAlignType;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.pdfbox.encoding.WinAnsiEncoding;
import org.apache.pdfbox.pdmodel.edit.PDPageContentStream;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

final class PdfBoxHelper {
    private static final Logger LOG = LoggerFactory.getLogger(PdfBoxHelper.class);
    private static final char FALLBACK_CHAR = '?';
    private static final int MAX_CHARS_IN_LINE = 200;

    private PdfBoxHelper() {
    }

    public static float addText(PDPageContentStream stream, PdfTextStyle textConfig, float textX, float textY, float allowedWidth, float lineHeightD, ReportAlignType align, String text) {
        String fixedText = text;
        if (textConfig.getFont() == null || textConfig.getFont().getFontEncoding() instanceof WinAnsiEncoding) {
            fixedText = PdfBoxHelper.fixString(text);
        }
        float nextLineY = PdfBoxHelper.nextLineY((int)textY, textConfig.getFontSize(), lineHeightD);
        try {
            float x;
            String[] split = PdfBoxHelper.splitText(textConfig.getFont(), textConfig.getFontSize(), allowedWidth, fixedText);
            switch (align) {
                case LEFT: {
                    x = textX;
                    break;
                }
                case RIGHT: {
                    float w = PdfBoxHelper.getTextWidth(textConfig.getFont(), textConfig.getFontSize(), split[0]);
                    x = textX + allowedWidth - w;
                    break;
                }
                case CENTER: {
                    float halfW = PdfBoxHelper.getTextWidth(textConfig.getFont(), textConfig.getFontSize(), split[0]) / 2.0f;
                    float absoluteCenter = allowedWidth / 2.0f + textX;
                    x = absoluteCenter - halfW;
                    break;
                }
                default: {
                    throw new IllegalStateException("Align type " + (Object)((Object)align) + " not implemented for text");
                }
            }
            PdfBoxHelper.addTextSimple(stream, textConfig, x, nextLineY, split[0]);
            if (!StringUtils.isEmpty((Object)split[1])) {
                return PdfBoxHelper.addText(stream, textConfig, textX, nextLineY, allowedWidth, lineHeightD, align, split[1]);
            }
            return nextLineY;
        }
        catch (Exception e) {
            LOG.warn("Could not add text: " + e.getClass() + " - " + e.getMessage());
            return textY;
        }
    }

    private static String fixString(String original) {
        StringBuilder sb = new StringBuilder();
        try {
            for (char ch : original.toCharArray()) {
                char decodedChar;
                if (WinAnsiEncoding.INSTANCE.hasNameForCode((int)ch)) {
                    sb.append(ch);
                    continue;
                }
                if (ch == '\u201c' || ch == '\u201e') {
                    sb.append('\"');
                    continue;
                }
                if (ch == '\u2026') {
                    sb.append("...");
                    continue;
                }
                if (ch == '\u20ac') {
                    sb.append('\u0080');
                    continue;
                }
                String decoded = Normalizer.normalize(String.valueOf(ch), Normalizer.Form.NFD);
                char c = decodedChar = decoded != null && decoded.length() > 0 ? (char)decoded.charAt(0) : (char)'?';
                if (WinAnsiEncoding.INSTANCE.getCharacter((int)decodedChar) != null) {
                    sb.append(decodedChar);
                    continue;
                }
                sb.append('?');
            }
        }
        catch (Exception e) {
            throw new PdfBoxHelperException("unexpected character decoding error for input " + original, e);
        }
        return sb.toString();
    }

    public static void addTextSimple(PDPageContentStream stream, PdfTextStyle textConfig, float textX, float textY, String text) {
        try {
            stream.setFont(textConfig.getFont(), (float)textConfig.getFontSize());
            stream.setNonStrokingColor(textConfig.getColor());
            stream.beginText();
            stream.moveTextPositionByAmount(textX, textY);
            stream.drawString(text);
            stream.endText();
        }
        catch (Exception e) {
            LOG.warn("Could not add text: " + e.getClass() + " - " + e.getMessage());
        }
    }

    private static List<Integer> getWrapableIndexes(String text) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        Pattern pt = Pattern.compile("\\s+");
        Matcher m = pt.matcher(text);
        while (m.find()) {
            list.add(m.start());
        }
        list.add(text.length());
        return list;
    }

    public static String[] splitText(PDFont font, int fontSize, float allowedWidth, String text) {
        String part2;
        String part1;
        String endPart;
        String shortenedText = text;
        if (shortenedText.length() > 200) {
            endPart = shortenedText.substring(200);
            shortenedText = shortenedText.substring(0, 200);
        } else {
            endPart = "";
        }
        if (PdfBoxHelper.getTextWidth(font, fontSize, shortenedText) <= allowedWidth && shortenedText.indexOf(13) == -1) {
            return new String[]{shortenedText, null};
        }
        boolean cleanSplit = true;
        List<Integer> indexes = PdfBoxHelper.getWrapableIndexes(shortenedText);
        int start = 0;
        int j = indexes.size() - 1;
        int end = indexes.get(j);
        int lineBreakPos = shortenedText.indexOf(10);
        if (lineBreakPos != -1 && PdfBoxHelper.getTextWidth(font, fontSize, shortenedText.substring(start, lineBreakPos)) <= allowedWidth) {
            end = lineBreakPos;
        } else {
            while (PdfBoxHelper.getTextWidth(font, fontSize, shortenedText.substring(start, end)) > allowedWidth) {
                if (j == 0) {
                    cleanSplit = false;
                    break;
                }
                end = indexes.get(--j);
            }
        }
        if (!cleanSplit) {
            end = shortenedText.length();
            while (PdfBoxHelper.getTextWidth(font, fontSize, shortenedText.substring(start, end)) > allowedWidth) {
                --end;
            }
        }
        if (cleanSplit) {
            part1 = shortenedText.substring(start, end).trim();
            part2 = shortenedText.substring(end + 1, shortenedText.length()).concat(endPart).trim();
        } else {
            part1 = shortenedText.substring(start, end - 1).concat("-").trim();
            part2 = shortenedText.substring(end - 1, shortenedText.length()).concat(endPart).trim();
        }
        return new String[]{part1, part2};
    }

    public static float getTextWidth(PDFont font, int fontSize, String text) {
        try {
            return font.getStringWidth(text) / 1000.0f * (float)fontSize;
        }
        catch (Exception e) {
            LOG.warn("Could not calculate string length: " + e.getClass() + " - " + e.getMessage());
            return 0.0f;
        }
    }

    public static float nextLineY(int currentY, int fontSize, float lineHeightD) {
        return (float)(currentY - fontSize) - lineHeightD;
    }
}

