/*
 * Decompiled with CFR 0.152.
 */
package cc.catalysts.boot.javamelody.config;

import cc.catalysts.boot.javamelody.config.JavaMelodyConfigurationProperties;
import java.util.EventListener;
import java.util.HashSet;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import net.bull.javamelody.MonitoredWithAnnotationPointcut;
import net.bull.javamelody.MonitoringFilter;
import net.bull.javamelody.MonitoringSpringAdvisor;
import net.bull.javamelody.Parameter;
import net.bull.javamelody.SessionListener;
import net.bull.javamelody.SpringDataSourceBeanPostProcessor;
import org.springframework.aop.Pointcut;
import org.springframework.aop.support.annotation.AnnotationMatchingPointcut;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.embedded.FilterRegistrationBean;
import org.springframework.boot.context.embedded.ServletContextInitializer;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.stereotype.Controller;
import org.springframework.stereotype.Service;

@Configuration
@EnableConfigurationProperties(value={JavaMelodyConfigurationProperties.class})
@ConditionalOnProperty(name={"javamelody.disabled"}, havingValue="false", matchIfMissing=true)
public class JavaMelodyAutoConfiguration
implements ServletContextInitializer {
    public void onStartup(ServletContext servletContext) throws ServletException {
        servletContext.addListener((EventListener)new SessionListener());
    }

    @Bean
    public FilterRegistrationBean javaMelody(JavaMelodyConfigurationProperties configurationProperties) {
        FilterRegistrationBean javaMelody = new FilterRegistrationBean();
        javaMelody.setFilter((Filter)new MonitoringFilter());
        javaMelody.setAsyncSupported(true);
        javaMelody.setName("javamelody");
        javaMelody.setDispatcherTypes(DispatcherType.REQUEST, new DispatcherType[]{DispatcherType.ASYNC});
        javaMelody.addInitParameter(Parameter.LOG.getCode(), Boolean.toString(false));
        javaMelody.addInitParameter(Parameter.DISABLED.getCode(), Boolean.toString(configurationProperties.isDisabled()));
        javaMelody.addInitParameter(Parameter.MONITORING_PATH.getCode(), configurationProperties.getMonitoringPath());
        javaMelody.addInitParameter(Parameter.STORAGE_DIRECTORY.getCode(), configurationProperties.getStorageDirectory());
        javaMelody.addInitParameter(Parameter.URL_EXCLUDE_PATTERN.getCode(), configurationProperties.getUrlExcludePattern());
        javaMelody.addUrlPatterns(configurationProperties.getUrlPatterns());
        return javaMelody;
    }

    @Bean
    public SpringDataSourceBeanPostProcessor monitoringDataSourceBeanPostProcessor(@Value(value="${javamelody.excludedDataSources:}") String[] excludedDataSourcesArray) {
        SpringDataSourceBeanPostProcessor processor = new SpringDataSourceBeanPostProcessor();
        HashSet<String> excludedDataSources = new HashSet<String>();
        for (String s : excludedDataSourcesArray) {
            excludedDataSources.add(s);
        }
        processor.setExcludedDatasources(excludedDataSources);
        return processor;
    }

    @Bean
    public MonitoringSpringAdvisor monitoringAdvisor() {
        MonitoringSpringAdvisor interceptor = new MonitoringSpringAdvisor();
        interceptor.setPointcut((Pointcut)new MonitoredWithAnnotationPointcut());
        return interceptor;
    }

    @ConditionalOnProperty(name={"javamelody.enableSpringServiceMonitoring"}, havingValue="true")
    @Bean
    public MonitoringSpringAdvisor springServiceMonitoringAdvisor() {
        MonitoringSpringAdvisor interceptor = new MonitoringSpringAdvisor();
        interceptor.setPointcut((Pointcut)new AnnotationMatchingPointcut(Service.class));
        return interceptor;
    }

    @ConditionalOnProperty(name={"javamelody.enableSpringControllerMonitoring"}, havingValue="true")
    @Bean
    public MonitoringSpringAdvisor springControllerMonitoringAdvisor() {
        MonitoringSpringAdvisor interceptor = new MonitoringSpringAdvisor();
        interceptor.setPointcut((Pointcut)new AnnotationMatchingPointcut(Controller.class));
        return interceptor;
    }
}

