/*
 * Decompiled with CFR 0.152.
 */
package cc.catalysts.boot.javamelody.config;

import java.util.EventListener;
import java.util.HashSet;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import net.bull.javamelody.MonitoredWithAnnotationPointcut;
import net.bull.javamelody.MonitoringFilter;
import net.bull.javamelody.MonitoringSpringAdvisor;
import net.bull.javamelody.Parameter;
import net.bull.javamelody.SessionListener;
import net.bull.javamelody.SpringDataSourceBeanPostProcessor;
import org.springframework.aop.Pointcut;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.embedded.FilterRegistrationBean;
import org.springframework.boot.context.embedded.ServletContextInitializer;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties
@ConditionalOnProperty(name={"javamelody.disabled"}, havingValue="false", matchIfMissing=true)
@ConfigurationProperties(prefix="javamelody")
public class JavaMelodyAutoConfiguration
implements ServletContextInitializer {
    private boolean disabled = false;
    private String monitoringPath = "/monitoring";
    private String urlExcludePattern = "(/webjars/.*|/css/.*|/images/.*|/fonts/.*|/ui/.*|/js/.*|/views/.*|/monitoring/.*|/lesscss/.*|/favicon.ico)";
    private String storageDirectory = "/tmp/javamelody";
    private String[] urlPatterns = new String[]{"/*"};
    private String[] excludedDataSources;

    public void onStartup(ServletContext servletContext) throws ServletException {
        servletContext.addListener((EventListener)new SessionListener());
    }

    @Bean
    public FilterRegistrationBean javaMelody() {
        FilterRegistrationBean javaMelody = new FilterRegistrationBean();
        javaMelody.setFilter((Filter)new MonitoringFilter());
        javaMelody.setAsyncSupported(true);
        javaMelody.setName("javamelody");
        javaMelody.setDispatcherTypes(DispatcherType.REQUEST, new DispatcherType[]{DispatcherType.ASYNC});
        javaMelody.addInitParameter(Parameter.LOG.getCode(), Boolean.toString(false));
        javaMelody.addInitParameter(Parameter.DISABLED.getCode(), Boolean.toString(this.disabled));
        javaMelody.addInitParameter(Parameter.MONITORING_PATH.getCode(), this.monitoringPath);
        javaMelody.addInitParameter(Parameter.STORAGE_DIRECTORY.getCode(), this.storageDirectory);
        javaMelody.addInitParameter(Parameter.URL_EXCLUDE_PATTERN.getCode(), this.urlExcludePattern);
        javaMelody.addUrlPatterns(this.urlPatterns);
        return javaMelody;
    }

    @Bean
    public SpringDataSourceBeanPostProcessor monitoringDataSourceBeanPostProcessor(@Value(value="${javamelody.excludedDataSources:}") String[] excludedDataSourcesArray) {
        SpringDataSourceBeanPostProcessor processor = new SpringDataSourceBeanPostProcessor();
        HashSet<String> excludedDataSources = new HashSet<String>();
        for (String s : excludedDataSourcesArray) {
            excludedDataSources.add(s);
        }
        processor.setExcludedDatasources(excludedDataSources);
        return processor;
    }

    @Bean
    public MonitoringSpringAdvisor monitoringAdvisor() {
        MonitoringSpringAdvisor interceptor = new MonitoringSpringAdvisor();
        interceptor.setPointcut((Pointcut)new MonitoredWithAnnotationPointcut());
        return interceptor;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public String getMonitoringPath() {
        return this.monitoringPath;
    }

    public void setMonitoringPath(String monitoringPath) {
        this.monitoringPath = monitoringPath;
    }

    public String getUrlExcludePattern() {
        return this.urlExcludePattern;
    }

    public void setUrlExcludePattern(String urlExcludePattern) {
        this.urlExcludePattern = urlExcludePattern;
    }

    public String getStorageDirectory() {
        return this.storageDirectory;
    }

    public void setStorageDirectory(String storageDirectory) {
        this.storageDirectory = storageDirectory;
    }

    public String[] getUrlPatterns() {
        return this.urlPatterns;
    }

    public void setUrlPatterns(String[] urlPatterns) {
        this.urlPatterns = urlPatterns;
    }

    public String[] getExcludedDataSources() {
        return this.excludedDataSources;
    }

    public void setExcludedDataSources(String[] excludedDataSources) {
        this.excludedDataSources = excludedDataSources;
    }
}

