/*
 * Decompiled with CFR 0.152.
 */
package cc.catalysts.boot.i18n.controller;

import cc.catalysts.boot.dto.NamedDto;
import cc.catalysts.boot.exception.NotFoundException;
import cc.catalysts.boot.i18n.service.ClientEnumRegistry;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/enum"})
public class ClientEnumController
implements ClientEnumRegistry {
    private final MessageSource messageSource;
    private final Map<Locale, Map<String, List<NamedDto<String>>>> clientEnums = new ConcurrentHashMap<Locale, Map<String, List<NamedDto<String>>>>();
    private final Map<String, Class> nameToClassMap = new ConcurrentHashMap<String, Class>();

    @Autowired
    public ClientEnumController(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/{name}"})
    public List<NamedDto<String>> getEnumValues(@PathVariable(value="name") String name) {
        Locale locale = LocaleContextHolder.getLocale();
        this.checkIfCurrentLocaleRegistered(locale);
        if (this.clientEnums.get(locale).containsKey(name)) {
            return this.clientEnums.get(locale).get(name);
        }
        throw new NotFoundException(name);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/", ""})
    public Map<String, List<NamedDto<String>>> getAll() {
        Locale locale = LocaleContextHolder.getLocale();
        this.checkIfCurrentLocaleRegistered(locale);
        return this.clientEnums.get(locale);
    }

    private void checkIfCurrentLocaleRegistered(Locale locale) {
        if (!this.clientEnums.containsKey(locale)) {
            for (Map.Entry<String, Class> stringClassEntry : this.nameToClassMap.entrySet()) {
                this.register(stringClassEntry.getKey(), stringClassEntry.getValue(), locale);
            }
        }
    }

    @Override
    public void registerClientEnum(String name, Class<? extends Enum> enumClazz) {
        if (this.nameToClassMap.containsKey(name)) {
            throw new IllegalArgumentException("Client-Enum '" + name + "' already exists");
        }
        this.nameToClassMap.put(name, enumClazz);
        Locale defaultLocale = Locale.getDefault();
        this.register(name, enumClazz, defaultLocale);
        for (Locale locale : this.clientEnums.keySet()) {
            if (locale.equals(defaultLocale)) continue;
            this.clientEnums.remove(locale);
        }
    }

    private void register(String name, Class<? extends Enum> enumClazz, Locale locale) {
        ArrayList<NamedDto> list = new ArrayList<NamedDto>();
        String messageKeyRoot = "enum." + enumClazz.getSimpleName() + ".";
        for (Enum anEnum : enumClazz.getEnumConstants()) {
            list.add(new NamedDto((Serializable)((Object)anEnum.name()), this.messageSource.getMessage(messageKeyRoot + anEnum.name(), new Object[0], locale)));
        }
        if (!this.clientEnums.containsKey(locale)) {
            this.clientEnums.put(locale, new ConcurrentHashMap());
        }
        Map<String, List<NamedDto<String>>> localeMap = this.clientEnums.get(locale);
        localeMap.put(name, Collections.unmodifiableList(list));
    }

    @Override
    public void registerClientEnum(Class<? extends Enum> enumClazz) {
        this.registerClientEnum(enumClazz.getSimpleName(), enumClazz);
    }
}

